/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.redshift.RedshiftModLikeStoredTable;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.database.model.redshift.RedshiftModViewColumn;
import com.intellij.database.model.redshift.RedshiftView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModView
extends RedshiftView,
RedshiftModLikeStoredTable,
PostgresBaseModView {
    @Override
    @NotNull
    public RedshiftModSchema getSchema();

    @Override
    @NotNull
    default public RedshiftModSchema getParent() {
        RedshiftModSchema redshiftModSchema = this.getSchema();
        if (redshiftModSchema == null) {
            RedshiftModView.$$$reportNull$$$0(0);
        }
        return redshiftModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModView> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends RedshiftModViewColumn> getColumns();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getColumns());
        if (list == null) {
            RedshiftModView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setOwner(@Nullable String var1);

    @Override
    public void setFaceless(boolean var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setSourceTextLength(int var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    public void setBoundless(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            RedshiftModView.$$$reportNull$$$0(2);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String system = _properties.get("System");
        String stateNumber = _properties.get("StateNumber");
        String sourceTextLength = _properties.get("SourceTextLength");
        String invalid = _properties.get("Invalid");
        String boundless = _properties.get("Boundless");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOwner(owner != null ? PropertyConverter.importString(owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean(faceless) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong(stateNumber) : 0L);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt(sourceTextLength) : 0);
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean(invalid) : false);
        this.setBoundless(boundless != null ? PropertyConverter.importBoolean(boundless) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/redshift/RedshiftModView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/redshift/RedshiftModView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

