/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseRegularTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftForeignKey;
import com.intellij.database.model.redshift.RedshiftKey;
import com.intellij.database.model.redshift.RedshiftLikeStoredTable;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftTable
extends RedshiftLikeStoredTable,
PostgresBaseRegularTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            RedshiftTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftSchema getSchema();

    @Override
    @Nullable
    default public RedshiftSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends RedshiftTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends RedshiftTableColumn> getColumns();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftKey> getKeys();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftForeignKey> getForeignKeys();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY);
        if (list == null) {
            RedshiftTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getKeys(), this.getForeignKeys());
        if (list == null) {
            RedshiftTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getOwner() {
        return null;
    }

    @Override
    default public boolean isFaceless() {
        return false;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @NotNull
    default public RedshiftTableDistStyle getDistStyle() {
        RedshiftTableDistStyle redshiftTableDistStyle = RedshiftTableDistStyle.EVEN;
        if (redshiftTableDistStyle == null) {
            RedshiftTable.$$$reportNull$$$0(3);
        }
        return redshiftTableDistStyle;
    }

    @NotNull
    default public RedshiftTableBackupMode getBackupMode() {
        RedshiftTableBackupMode redshiftTableBackupMode = RedshiftTableBackupMode.ON;
        if (redshiftTableBackupMode == null) {
            RedshiftTable.$$$reportNull$$$0(4);
        }
        return redshiftTableBackupMode;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        boolean temporary;
        RedshiftTableBackupMode backupMode;
        RedshiftTableDistStyle distStyle;
        long stateNumber;
        boolean system;
        boolean faceless;
        String owner;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            RedshiftTable.$$$reportNull$$$0(5);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((owner = this.getOwner()) != null) {
            consumer2.accept("Owner", PropertyConverter.export(owner));
        }
        if (faceless = this.isFaceless()) {
            consumer2.accept("Faceless", PropertyConverter.export(faceless));
        }
        if (system = this.isSystem()) {
            consumer2.accept("System", PropertyConverter.export(system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer2.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((distStyle = this.getDistStyle()) != null && distStyle != RedshiftTableDistStyle.EVEN) {
            consumer2.accept("DistStyle", PropertyConverter.export(distStyle));
        }
        if ((backupMode = this.getBackupMode()) != null && backupMode != RedshiftTableBackupMode.ON) {
            consumer2.accept("BackupMode", PropertyConverter.export(backupMode));
        }
        if (temporary = this.isTemporary()) {
            consumer2.accept("Temporary", PropertyConverter.export(temporary));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Owner", "Faceless", "System", "StateNumber", "DistStyle", "BackupMode", "Temporary");
        if (list == null) {
            RedshiftTable.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/redshift/RedshiftTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackupMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/redshift/RedshiftTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

