/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteCheck;
import com.intellij.database.model.sqlite.SqliteForeignKey;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.model.sqlite.SqliteLikeTable;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.model.sqlite.SqliteTrigger;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteTable
extends SqliteLikeTable,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqliteTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public SqliteSchema getSchema();

    @Override
    @Nullable
    default public SqliteSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingFamily<@NotNull ? extends SqliteTable> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteTrigger> getTriggers();

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends SqliteTableColumn> getColumns();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteIndex> getIndices();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteKey> getKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteForeignKey> getForeignKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteCheck> getChecks();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);
        if (list == null) {
            SqliteTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getTriggers(), this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks());
        if (list == null) {
            SqliteTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    default public boolean isWithoutRowId() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        boolean withoutRowId;
        boolean temporary;
        boolean system;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer2 == null) {
            SqliteTable.$$$reportNull$$$0(3);
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer2.accept("System", PropertyConverter.export(system));
        }
        if (temporary = this.isTemporary()) {
            consumer2.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (withoutRowId = this.isWithoutRowId()) {
            consumer2.accept("WithoutRowId", PropertyConverter.export(withoutRowId));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "System", "Temporary", "WithoutRowId");
        if (list == null) {
            SqliteTable.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/sqlite/SqliteTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/sqlite/SqliteTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

