/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseRoot;
import com.intellij.database.model.sybase.SybaseSchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseDatabase
extends BasicMateDatabase,
BasicScriptable,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.DATABASE;
        if (objectKind == null) {
            SybaseDatabase.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public SybaseRoot getRoot();

    @Override
    @Nullable
    default public SybaseRoot getParent() {
        return this.getRoot();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends SybaseDatabase> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends SybaseSchema> getSchemas();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.SCHEMA);
        if (list == null) {
            SybaseDatabase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<NamingFamily> list = Collections.singletonList(this.getSchemas());
        if (list == null) {
            SybaseDatabase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        boolean visible;
        boolean current;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            SybaseDatabase.$$$reportNull$$$0(3);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (current = this.isCurrent()) {
            consumer2.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer2.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Current", "Visible");
        if (list == null) {
            SybaseDatabase.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/sybase/SybaseDatabase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/sybase/SybaseDatabase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

