/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.db2;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.plan.db2.Db2BuilderState;
import com.intellij.util.Consumer;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntObjectIterator;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2PlanModelBuilder
extends AbstractPlanModelBuilder<Db2BuilderState> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = ContainerUtil.newHashMap();
    private static final Set<String> INDICES = ContainerUtil.newHashSet();
    private static final Set<String> RELATIONS = ContainerUtil.newHashSet();
    private final String myStatement;
    private Db2BuilderState.Shared myShared;

    public Db2PlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement) {
        if (owner == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer2, EnumSet.noneOf(PlanModel.Feature.class));
        this.myStatement = statement;
    }

    private void extractStreams(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        while (resultSet.next()) {
            Db2BuilderState.NodeId tid;
            Db2BuilderState.NodeId sid;
            int id = resultSet.getInt("STREAM_ID");
            String sourceType = resultSet.getString("SOURCE_TYPE");
            int sourceId = resultSet.getInt("SOURCE_ID");
            String targetType = resultSet.getString("TARGET_TYPE");
            int targetId = resultSet.getInt("TARGET_ID");
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            BigDecimal streamCount = resultSet.getBigDecimal("STREAM_COUNT");
            int predicateId = resultSet.getInt("PREDICATE_ID");
            if (sourceType.equals("O")) {
                if (sourceId == -1) {
                    this.unsupportedFormat();
                }
                sid = new Db2BuilderState.NodeId(sourceId);
            } else {
                sid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            if (targetType.equals("O")) {
                if (targetId == -1) {
                    this.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(targetId);
            } else {
                if (sourceId == -1) {
                    this.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            Db2BuilderState.Stream stream = new Db2BuilderState.Stream(id, streamCount, predicateId, sid, tid);
            ArrayList streams = shared.streamsByTargetId.get(tid);
            if (streams == null) {
                streams = ContainerUtil.newArrayListWithCapacity((int)2);
                shared.streamsByTargetId.put(tid, streams);
            }
            streams.add(stream);
            shared.streamBySourceId.put(sid, stream);
        }
    }

    private void extractOperators(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        while (resultSet.next()) {
            int id = resultSet.getInt("OPERATOR_ID");
            String operatorType = resultSet.getString("OPERATOR_TYPE").trim();
            double totalCost = resultSet.getDouble("TOTAL_COST");
            double ioCost = resultSet.getDouble("IO_COST");
            double cpuCost = resultSet.getDouble("CPU_COST");
            double firstRowCost = resultSet.getDouble("FIRST_ROW_COST");
            Db2BuilderState.Operator operator = new Db2BuilderState.Operator(id, operatorType, totalCost, ioCost, cpuCost, firstRowCost);
            shared.operatorById.put(id, (Object)operator);
        }
    }

    private void extractObjects(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(5);
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        while (resultSet.next()) {
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            String objectType = resultSet.getString("OBJECT_TYPE");
            Db2BuilderState.Obj obj = new Db2BuilderState.Obj(new Db2BuilderState.ObjectId(objectSchema, objectName), objectType);
            shared.objectById.put(obj.id, obj);
        }
    }

    private void fillSharedData(@NotNull DatabaseConnection connection, final @NotNull Db2BuilderState.Shared shared) {
        if (connection == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (shared == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(7);
        }
        Db2PlanModelBuilder.useStatementWithPreserved(connection, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                String uuid = Db2PlanModelBuilder.randomShorterUUID().substring(0, 20);
                statement.barren().execute("EXPLAIN PLAN SET QUERYTAG = '" + uuid + "' FOR " + Db2PlanModelBuilder.this.myStatement);
                statement.noisy().execute("SELECT STREAM_ID, SOURCE_TYPE, SOURCE_ID, TARGET_TYPE, TARGET_ID, OBJECT_SCHEMA, OBJECT_NAME, STREAM_COUNT, PREDICATE_ID\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_STREAM ess\n    ON es.STMTNO = ess.STMTNO\n       AND es.SECTNO = ess.SECTNO\n       AND es.EXPLAIN_TIME = ess.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = ess.EXPLAIN_LEVEL WHERE QUERYTAG = '" + uuid + "'", Db2PlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (shared == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    Db2PlanModelBuilder.this.extractStreams(rs, shared);
                }));
                statement.noisy().execute("SELECT OPERATOR_ID, OPERATOR_TYPE, eos.TOTAL_COST, IO_COST, CPU_COST, FIRST_ROW_COST\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_OPERATOR eos\n    ON es.STMTNO = eos.STMTNO\n       AND es.SECTNO = eos.SECTNO\n       AND es.EXPLAIN_TIME = eos.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eos.EXPLAIN_LEVEL WHERE QUERYTAG = '" + uuid + "'", Db2PlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (shared == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Db2PlanModelBuilder.this.extractOperators(rs, shared);
                }));
                statement.noisy().execute("SELECT OBJECT_SCHEMA, OBJECT_NAME, OBJECT_TYPE\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_OBJECT eo\n    ON es.STMTNO = eo.STMTNO\n       AND es.SECTNO = eo.SECTNO\n       AND es.EXPLAIN_TIME = eo.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eo.EXPLAIN_LEVEL\n       AND es.SOURCE_NAME = eo.SOURCE_NAME WHERE QUERYTAG = '" + uuid + "'", Db2PlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (shared == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Db2PlanModelBuilder.this.extractObjects(rs, shared);
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "shared";
                objectArray2[1] = "com/intellij/database/plan/db2/Db2PlanModelBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$use$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$use$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$use$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (Db2BuilderState.Obj obj : this.myShared.objectById.values()) {
            sb.append(obj.id.schema).append(" ").append(obj.id.name).append(" ").append(obj.type).append("\n");
        }
        sb.append("\n");
        TIntObjectIterator it = this.myShared.operatorById.iterator();
        while (it.hasNext()) {
            it.advance();
            Db2BuilderState.Operator op = (Db2BuilderState.Operator)it.value();
            sb.append(op.id).append(" ").append(op.type).append(" ").append(op.cpuCost).append(" ").append(op.firstRowCost).append(" ").append(op.ioCost).append(" ").append(op.totalCost).append("\n");
        }
        sb.append("\n");
        HashSet visited = ContainerUtil.newHashSet();
        for (Db2BuilderState.Stream s : JBIterable.from(this.myShared.streamsByTargetId.values()).flatten(Functions.identity()).append(this.myShared.streamBySourceId.values())) {
            if (!visited.add(s)) continue;
            sb.append(s.id).append(" ").append(s.predId).append(" ").append(s.numRows).append(" ").append(s.sourceId.objectId).append(" ").append(s.sourceId.operatorId).append(" ").append(s.targetId.objectId).append(" ").append(s.targetId.operatorId).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) {
        if (context == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(10);
        }
        this.myShared = new Db2BuilderState.Shared();
        this.fillSharedData(connection, this.myShared);
        this.showRaw();
        this.parseRoot(new Db2BuilderState(this.myShared, null));
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull Db2BuilderState state) {
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        for (Db2BuilderState.ObjectId id : state.nextObjectsIds()) {
            sb.append(id.toString()).append(";\n");
        }
        String string = sb.toString();
        if (string == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Db2BuilderState state) {
        List objs;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(13);
        }
        if ((objs = ContainerUtil.filter(state.nextObjects(), obj -> RELATIONS.contains(obj.type))).size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Db2BuilderState state) {
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(14);
        }
        return state.prevStream == null ? null : state.prevStream.numRows;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Db2BuilderState state) {
        List objs;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(15);
        }
        if ((objs = ContainerUtil.filter(state.nextObjects(), obj -> INDICES.contains(obj.type))).size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Nullable
    private static Db2BuilderState.Operator getOperator(@NotNull Db2BuilderState state) {
        Db2BuilderState.NodeId nodeId;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(16);
        }
        return (nodeId = state.getCurrentNodeId()) == null || nodeId.operatorId == null ? null : (Db2BuilderState.Operator)state.shared.operatorById.get(nodeId.operatorId.intValue());
    }

    @Override
    protected void parsePlan(@NotNull Db2BuilderState state) {
        Db2BuilderState.Operator op;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(17);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state)) == null) {
            return;
        }
        this.openNode();
        this.parseSubPlans(state);
        String operatorType = op.type;
        PlanModel.NodeType type = TYPE_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, operatorType);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Db2BuilderState state) {
        List<Db2BuilderState.Stream> streams;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(18);
        }
        if ((streams = state.shared.streamsByTargetId.get(state.getCurrentNodeId())) == null) {
            return;
        }
        for (Db2BuilderState.Stream stream : streams) {
            this.parsePlan(new Db2BuilderState(state.shared, stream));
        }
    }

    protected void parseRoot(@NotNull Db2BuilderState state) {
        Db2BuilderState.Operator op;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(19);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state)) == null || !"RETURN".equals(op.type)) {
            this.unsupportedFormat();
        }
        List<Db2BuilderState.Stream> streams = state.shared.streamsByTargetId.get(state.getCurrentNodeId());
        this.openNode();
        for (Db2BuilderState.Stream stream : streams) {
            this.parseStatement(new Db2BuilderState(state.shared, stream));
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    protected void parseStatement(@NotNull Db2BuilderState state) {
        Db2BuilderState.Operator op;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(20);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state)) == null) {
            this.unsupportedFormat();
        }
        this.openNode();
        PlanModel.NodeType type = STATEMENT_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.SELECT;
            this.parsePlan(state);
        } else {
            this.parseSubPlans(state);
        }
        this.closeNode(this.createNode(state, type, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Db2BuilderState state) {
        Db2BuilderState.Operator operator;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(21);
        }
        return (operator = Db2PlanModelBuilder.getOperator(state)) == null ? null : Double.valueOf(operator.totalCost);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Db2BuilderState state) {
        Db2BuilderState.Operator operator;
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(22);
        }
        return (operator = Db2PlanModelBuilder.getOperator(state)) == null ? null : Double.valueOf(operator.firstRowCost);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Db2BuilderState state) {
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(23);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Db2BuilderState state) {
        if (state == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(24);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("TBFUNC", PlanModel.NodeType.TABLE_FUNCTION);
        TYPE_MAPPING.put("EISCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FETCH", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("GENROW", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("CMPEXP", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("GRPBY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HSJOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("IXAND", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("IXSCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("MSJOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOIN", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("RIDSCN", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("RPD", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SHIP", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TBSCAN", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("TEMP", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("TQ", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNIQUE", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("XISCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XSCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XANDOR", PlanModel.NodeType.UNKNOWN);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        INDICES.add("IX");
        INDICES.add("RX");
        INDICES.add("XI");
        INDICES.add("PI");
        INDICES.add("LI");
        INDICES.add("LX");
        INDICES.add("LP");
        RELATIONS.add("NK");
        RELATIONS.add("DP");
        RELATIONS.add("TA");
        RELATIONS.add("TF");
        RELATIONS.add("+A");
        RELATIONS.add("+C");
        RELATIONS.add("+F");
        RELATIONS.add("+G");
        RELATIONS.add("+N");
        RELATIONS.add("+T");
        RELATIONS.add("+V");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/db2/Db2PlanModelBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/db2/Db2PlanModelBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractStreams";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractOperators";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractObjects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillSharedData";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOperator";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

