/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.sqlite;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlitePlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private final List<PlanRow> myRows;
    private final TIntObjectHashMap<MetaNode> myStructure;
    private int myMaxId;

    public SqlitePlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement) {
        if (owner == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer2, EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST, PlanModel.Feature.NUM_ROWS));
        this.myRows = ContainerUtil.newArrayList();
        this.myStructure = new TIntObjectHashMap();
        this.myMaxId = 0;
        this.myStatement = statement;
    }

    private void getData(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(3);
        }
        SqlitePlanModelBuilder.useStatementWithPreserved(connection, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                statement.noisy().execute("EXPLAIN QUERY PLAN " + SqlitePlanModelBuilder.this.myStatement, SqlitePlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (rs.getMetaData().getColumnCount() != 4) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    while (rs.next()) {
                        SqlitePlanModelBuilder.this.myRows.add(new PlanRow(rs.getInt("selectid"), rs.getInt("order"), rs.getInt("from"), rs.getString("detail")));
                    }
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (PlanRow row : this.myRows) {
            sb.append("\t").append(row.subqueryId).append("\t").append(row.order).append("\t").append(row.from).append("\t").append(row.detail).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void processDump(@NotNull String dump) {
        if (dump == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(5);
        }
        this.parseDump(dump);
        this.processData();
    }

    private void parseDump(String dump) {
        this.myRows.clear();
        for (String line : dump.split("\\r?\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 5);
            this.myRows.add(new PlanRow(Integer.parseInt((String)split.get(1)), Integer.parseInt((String)split.get(2)), Integer.parseInt((String)split.get(3)), (String)split.get(4)));
        }
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) {
        if (context == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.getData(connection);
        this.showRaw();
        this.processData();
    }

    private void processData() {
        this.parseStructure();
        this.cacheNodes();
        this.openNode();
        MetaNode root2 = (MetaNode)this.myStructure.get(0);
        this.parseStatement(root2);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.modelReady();
    }

    private void cacheNodes() {
        this.openNode();
        TIntObjectIterator it = this.myStructure.iterator();
        while (it.hasNext()) {
            it.advance();
            this.parseSubPlans((MetaNode)it.value());
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.resetRoot();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(8);
        }
        if ("" == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @NotNull
    private PlanModel.GenericAccessNode buildTableScanNode(@NotNull ListIterator<String> tok) {
        PlanModel.GenericAccessNode res;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(13);
        }
        String tableName = tok.next();
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "AS")) {
            tok.next();
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            PlanModel.IndexScanNode node = (PlanModel.IndexScanNode)this.createNode(null, PlanModel.NodeType.INDEX_SCAN, null);
            res = node;
            if (SqlitePlanModelBuilder.checkOrRecover(tok, "INTEGER")) {
                this.consumeTokens(tok, "PRIMARY", "KEY");
            } else {
                String token = tok.next();
                if ("AUTOMATIC".equals(token)) {
                    token = tok.next();
                }
                if ("COVERING".equals(token)) {
                    token = tok.next();
                }
                this.checkToken(token, "INDEX");
                String indexName = tok.next();
                node.setIndex(indexName);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(", "=?)")) {
                tok.next();
            }
        } else {
            res = (PlanModel.GenericAccessNode)this.createNode(null, PlanModel.NodeType.SEQ_SCAN, null);
        }
        res.setRelation(tableName);
        PlanModel.GenericAccessNode genericAccessNode = res;
        if (genericAccessNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return genericAccessNode;
    }

    @NotNull
    private PlanModel.GenericNode buildScanNode(@NotNull ListIterator<String> tok) {
        String token;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(15);
        }
        if ((token = tok.next()).equals("TABLE")) {
            PlanModel.GenericAccessNode genericAccessNode = this.buildTableScanNode(tok);
            if (genericAccessNode == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(16);
            }
            return genericAccessNode;
        }
        this.checkToken("SUBQUERY", token);
        PlanModel.GenericNode genericNode = this.buildSubqueryScanNode(tok);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(17);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildSubqueryScanNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(18);
        }
        this.parseSubquery(Integer.parseInt(tok.next()), true);
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(19);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull ListIterator<String> tok) {
        PlanModel.GenericNode genericNode;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(20);
        }
        try {
            String token = tok.next();
            PlanModel.GenericNode node = "SCAN".equals(token) || "SEARCH".equals(token) ? this.buildScanNode(tok) : ("EXECUTE".equals(token) ? this.buildSubqueryNode(tok) : ("COMPOUND".equals(token) ? this.buildCompoundNode(tok) : ("USE".equals(token) ? this.buildUseNode(tok) : this.createNode(null, PlanModel.NodeType.UNKNOWN, null))));
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(~", null)) {
                node.setPlanNumRows(new BigDecimal(tok.next().substring(2)));
                this.consumeToken(tok, "rows)");
            }
            genericNode = node;
        }
        catch (NoSuchElementException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode2 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode2 == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(22);
            }
            return genericNode2;
        }
        catch (NumberFormatException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode3 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode3 == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(23);
            }
            return genericNode3;
        }
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(21);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildUseNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(24);
        }
        this.consumeTokens(tok, "TEMP", "B-TREE", "FOR");
        String op = tok.next();
        while (tok.hasNext()) {
            op = op + " " + tok.next();
        }
        PlanModel.NodeType type = TYPE_MAPPING.get(op);
        if (type == null) {
            type = PlanModel.NodeType.TRANSFORM;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.TRANSFORM ? op : null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(25);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildCompoundNode(@NotNull ListIterator<String> tok) {
        PlanModel.NodeType type;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(26);
        }
        this.consumeToken(tok, "SUBQUERIES");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        this.consumeToken(tok, "AND");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            this.consumeTokens(tok, "TEMP", "B-TREE");
        }
        String token = "";
        while (tok.hasNext()) {
            token = token + " " + tok.next();
        }
        if (!(token = token.trim()).startsWith("(") && token.endsWith(")")) {
            this.unsupportedFormat(token);
        }
        if ((type = TYPE_MAPPING.get(token = token.substring(1, token.length() - 1))) == null) {
            type = PlanModel.NodeType.SET_OP;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.SET_OP ? token : null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(27);
        }
        return genericNode;
    }

    private PlanModel.GenericNode buildSubqueryNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(28);
        }
        boolean scalar = false;
        boolean correlated = false;
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "CORRELATED")) {
            correlated = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "SCALAR")) {
            scalar = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "LIST")) {
            // empty if block
        }
        this.consumeToken(tok, "SUBQUERY");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        PlanModel.SubQueryNode res = (PlanModel.SubQueryNode)this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        res.setCorrelated(correlated);
        res.setScalar(scalar);
        return res;
    }

    private static boolean checkOrRecover(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(29);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(30);
        }
        if (tok.hasNext()) {
            if (tok.next().equals(token)) {
                return true;
            }
            tok.previous();
        }
        return false;
    }

    private static boolean checkPrefSufAndRecover(@NotNull ListIterator<String> tok, @Nullable String prefix, @Nullable String suffix) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(31);
        }
        if (tok.hasNext()) {
            String token = tok.next();
            tok.previous();
            if ((prefix == null || token.startsWith(prefix)) && (suffix == null || token.endsWith(suffix))) {
                return true;
            }
        }
        return false;
    }

    private void checkToken(@NotNull String current, @NotNull String token) {
        if (current == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(32);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(33);
        }
        if (!token.equals(current)) {
            this.unsupportedFormat("unexpected " + current + " != " + token);
        }
    }

    private void consumeToken(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(34);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(35);
        }
        this.checkToken(tok.next(), token);
    }

    private void consumeTokens(@NotNull ListIterator<String> tok, String ... tokens) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(36);
        }
        if (tokens == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(37);
        }
        for (String s : tokens) {
            this.consumeToken(tok, s);
        }
    }

    @Nullable
    private MetaNode removeSubquery(int id, boolean byteOverflow) {
        MetaNode node;
        MetaNode metaNode = node = id == 0 && byteOverflow ? null : (MetaNode)this.myStructure.get(id);
        if (byteOverflow) {
            while (node == null && id < this.myMaxId) {
                node = (MetaNode)this.myStructure.get(id += 256);
            }
        }
        return node != null ? (MetaNode)this.myStructure.remove(id) : null;
    }

    private void parseSubquery(int id, boolean byteOverflow) {
        MetaNode node = this.removeSubquery(id, byteOverflow);
        if (node == null) {
            node = new MetaNode(id, MetaNode.Type.DUMMY);
            node.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myMaxId = Math.max(this.myMaxId, id);
        }
        this.parseSubPlans(node);
    }

    @Override
    protected void parsePlan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(38);
        }
        assert (state.type != MetaNode.Type.DUMMY);
        this.addLazyNode((Getter<PlanModel.GenericNode>)((Getter)() -> {
            PlanModel.GenericNode node;
            if (state == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(48);
            }
            if (state.cache != null) {
                return state.cache;
            }
            if (state.type == MetaNode.Type.NESTED) {
                node = this.createNode(state, PlanModel.NodeType.NESTED_LOOPS, null);
            } else if (state.type == MetaNode.Type.TEMP) {
                node = this.createNode(state, PlanModel.NodeType.TEMPORARY, null);
            } else if (state.type == MetaNode.Type.SIMPLE) {
                node = this.createNode(state, PlanModel.NodeType.VALUE, null);
            } else {
                assert (state.type == MetaNode.Type.ROW);
                PlanRow curRow = this.myRows.get(state.rowId);
                try {
                    node = this.buildNode(Arrays.asList(curRow.detail.split(" ")).listIterator());
                }
                catch (PlanRetrievalException e) {
                    throw new PlanRetrievalException("while building for" + curRow.detail, e);
                }
                node.setRawDescription(curRow.detail);
            }
            this.parseSubPlans(state);
            state.cache = node;
            return node;
        }), this.isScan(state));
    }

    private boolean isScan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(39);
        }
        if (state.type != MetaNode.Type.ROW) {
            return false;
        }
        PlanRow curRow = this.myRows.get(state.rowId);
        return StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SCAN") || StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SEARCH");
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(40);
        }
        for (MetaNode child : state.children) {
            this.parsePlan(child);
        }
    }

    private void parseStructure() {
        if (!this.myRows.isEmpty()) {
            for (PlanRow myRow : this.myRows) {
                if (this.myStructure.containsKey(myRow.subqueryId)) continue;
                MetaNode node = new MetaNode(-1, MetaNode.Type.DUMMY);
                node.children.addAll(this.parseSubqueryStructure(myRow.subqueryId));
                this.myStructure.put(myRow.subqueryId, (Object)node);
                this.myMaxId = Math.max(this.myMaxId, myRow.subqueryId);
            }
        } else {
            MetaNode value = new MetaNode(0, MetaNode.Type.DUMMY);
            value.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myStructure.put(0, (Object)value);
        }
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(41);
        }
        if (node.type == MetaNode.Type.ROW && this.myRows.get((int)node.rowId).detail.contains("TEMP B-TREE")) {
            boolean child = this.myRows.get((int)node.rowId).detail.startsWith("USING");
            MetaNode temp = new MetaNode(-1, MetaNode.Type.TEMP);
            if (child) {
                temp.children.addAll(node.children);
                node.children.clear();
                node.children.add(temp);
            } else {
                temp.children.add(node);
                node = temp;
            }
        }
        MetaNode metaNode = node;
        if (metaNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(42);
        }
        return metaNode;
    }

    private List<MetaNode> parseSubqueryStructure(int id) {
        ArrayList res;
        List<Object> toPutScalarSubqueries = res = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < this.myRows.size(); ++i2) {
            if (this.myRows.get((int)i2).subqueryId != id || this.myRows.get((int)i2).order != 0) continue;
            MetaNode node = this.parseNestedStructure(i2);
            if (!res.isEmpty() && this.myRows.get((int)i2).detail.startsWith("EXECUTE")) {
                toPutScalarSubqueries.add(node);
                continue;
            }
            node.children.addAll(res);
            if (toPutScalarSubqueries == res) {
                toPutScalarSubqueries = node.children;
            }
            res.clear();
            res.add(this.expandStructure(node));
        }
        return res;
    }

    private MetaNode parseNestedStructure(int idx) {
        ArrayList res = ContainerUtil.newArrayList();
        int i2 = idx;
        int depth = 0;
        while (i2 < this.myRows.size() && this.myRows.get((int)i2).subqueryId == this.myRows.get((int)idx).subqueryId) {
            if (depth != this.myRows.get((int)i2).order) {
                if (this.myRows.get((int)i2).order == 0) break;
                this.unsupportedFormat(null);
            }
            res.add(new MetaNode(i2, MetaNode.Type.ROW));
            ++i2;
            ++depth;
        }
        if (res.size() == 1) {
            return (MetaNode)res.get(0);
        }
        MetaNode nested = new MetaNode(-1, MetaNode.Type.NESTED);
        nested.children.addAll(res);
        return nested;
    }

    @Override
    protected void parseStatement(@NotNull MetaNode s) {
        String[] split;
        if (s == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(43);
        }
        this.openNode();
        PlanModel.NodeType type = PlanModel.NodeType.STATEMENT;
        if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"select") || StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"with")) {
            type = PlanModel.NodeType.SELECT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"update")) {
            type = PlanModel.NodeType.UPDATE;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"insert")) {
            type = PlanModel.NodeType.INSERT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"delete")) {
            type = PlanModel.NodeType.DELETE;
        }
        if (!this.myRows.isEmpty()) {
            this.parseSubPlans(s);
        }
        String title = null;
        if (type == PlanModel.NodeType.STATEMENT && (split = this.myStatement.split(" ")).length > 0) {
            title = StringUtil.toLowerCase((String)split[0]);
        }
        this.closeNode(this.createNode(s, type, title));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(44);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(45);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(46);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(47);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNION ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("EXCEPT", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("INTERSECT", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("GROUP BY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("ORDER BY", PlanModel.NodeType.ORDER_BY);
        TYPE_MAPPING.put("DISTINCT", PlanModel.NodeType.UNIQUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 38: 
            case 39: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tok";
                break;
            }
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTableScanNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildScanNode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubqueryScanNode";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNode";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUseNode";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCompoundNode";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "expandStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 42: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDump";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildTableScanNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildScanNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryScanNode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildNode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildUseNode";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildCompoundNode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryNode";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkOrRecover";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefSufAndRecover";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkToken";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "consumeToken";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "consumeTokens";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isScan";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "expandStructure";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parsePlan$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MetaNode {
        public final int rowId;
        public final Type type;
        public final List<MetaNode> children = ContainerUtil.newArrayListWithCapacity((int)0);
        public PlanModel.GenericNode cache = null;

        public MetaNode(int id, Type type) {
            this.rowId = id;
            this.type = type;
        }

        static enum Type {
            ROW,
            NESTED,
            DUMMY,
            TEMP,
            SIMPLE;

        }
    }

    public static class PlanRow {
        public final int subqueryId;
        public final int order;
        public final int from;
        public final String detail;

        public PlanRow(int subqueryId, int order, int from, String detail) {
            this.subqueryId = subqueryId;
            this.order = order;
            this.from = from;
            this.detail = detail;
        }
    }
}

