/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.Branch;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DocumentationLink;
import com.intellij.database.serialization.ModelSerializationFun;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"makeDocumentationLink", "Lcom/intellij/database/psi/DocumentationLink;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "makeDocumentationLinkOnPostgresElement", "branch", "Lcom/intellij/database/model/Branch;", "intellij.database.impl"})
@JvmName(name="DbDocumentationLinks")
public final class DbDocumentationLinks {
    @Nullable
    public static final DocumentationLink makeDocumentationLink(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        Rdbms rdbms = basicModel != null ? basicModel.getRdbms() : null;
        return Intrinsics.areEqual((Object)rdbms, (Object)Postgres.RDBMS) || Intrinsics.areEqual((Object)rdbms, (Object)Redshift.RDBMS) ? DbDocumentationLinks.makeDocumentationLinkOnPostgresElement(ModelFun.branch(element)) : null;
    }

    @Nullable
    public static final DocumentationLink makeDocumentationLinkOnPostgresElement(@NotNull Branch branch) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Object object = branch.getSchema();
        if (object == null || (object = object.getNaturalName()) == null) {
            return null;
        }
        Object schemaName = object;
        String versionRef = "current";
        String p = "https://www.postgresql.org/docs/" + versionRef + "/static";
        ObjectKind kind = branch.getKind();
        String kindName = kind.code();
        String string = name = branch.getTarget().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        String name2 = StringsKt.replace$default((String)string, (char)'_', (char)'-', (boolean)false, (int)4, null);
        if (ModelSerializationFun.startsWith(name, '_')) {
            return null;
        }
        return Intrinsics.areEqual((Object)schemaName, (Object)"pg_catalog") && (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW)) ? new DocumentationLink(p + "/catalog-" + name2 + ".html", kindName + ' ' + name) : (Intrinsics.areEqual((Object)schemaName, (Object)"pg_catalog") && Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEMA) ? new DocumentationLink(p + "/catalogs.html", "System Catalog") : (Intrinsics.areEqual((Object)schemaName, (Object)"information_schema") && (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW)) ? new DocumentationLink(p + "/infoschema-" + name2 + ".html", kindName + ' ' + name) : (Intrinsics.areEqual((Object)schemaName, (Object)"information_schema") && Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEMA) ? new DocumentationLink(p + "/information-schema.html", "Information Schema") : null)));
    }
}

