/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenameHandler;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;

public class DbVetoRenameCondition
implements Condition<PsiElement> {
    public boolean value(PsiElement element) {
        if (element instanceof DatabaseStructure.Group) {
            return true;
        }
        if (element instanceof DbElement) {
            return DbRenameHandler.isVetoedElement((DbElement)element);
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile != null && DbConsoleRootType.isConsoleFile(virtualFile)) {
            return Comparing.equal((Object)DbConsoleRootType.getDataSourceRoot(virtualFile), (Object)virtualFile);
        }
        return false;
    }
}

