/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDataSourceManager
extends DefaultDbPsiManager {
    private static final String LRU_KEY = "DatabaseDriversLRU";
    private final DataSourceStorage myProjectStorage;

    @NotNull
    public static LocalDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(0);
        }
        LocalDataSourceManager localDataSourceManager = (LocalDataSourceManager)((Object)ObjectUtils.notNull((Object)ContainerUtil.findInstance((Object[])EP_NAME.getExtensions((AreaInstance)project), LocalDataSourceManager.class)));
        if (localDataSourceManager == null) {
            LocalDataSourceManager.$$$reportNull$$$0(1);
        }
        return localDataSourceManager;
    }

    public LocalDataSourceManager(Project project, DataSourceStorage.Prj projectStorage) {
        super(project, projectStorage.getDataSources());
        this.myProjectStorage = projectStorage;
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDataSourceManager.this.attachDataSource(dataSource);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalDataSourceManager.this.detachDataSource(dataSource);
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null) {
                    LocalDataSourceManager.this.resetElementMap(LocalDataSourceManager.this.myProjectStorage.getDataSources());
                } else {
                    LocalDataSourceManager.this.updateDataSource(dataSource);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/psi/LocalDataSourceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void addDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(2);
        }
        this.myProjectStorage.addDataSource(element);
    }

    public void removeDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myProjectStorage.removeDataSource(element);
    }

    public void renameDataSource(@NotNull LocalDataSource element, @NotNull String name) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            LocalDataSourceManager.$$$reportNull$$$0(5);
        }
        element.setName(name);
        this.myProjectStorage.updateDataSource(element);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(6);
        }
        DataSourceConfigurable dataSourceConfigurable = new DataSourceConfigurable(this, element, this.myProject);
        if (dataSourceConfigurable == null) {
            LocalDataSourceManager.$$$reportNull$$$0(7);
        }
        return dataSourceConfigurable;
    }

    @NotNull
    public AnAction getCreateDataSourceAction(@NotNull Consumer<LocalDataSource> consumer2) {
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(8);
        }
        List<AnAction> actions = this.getCreateDataSourceActions(DatabaseDriverManager.getInstance().getDrivers(), consumer2);
        DefaultActionGroup group2 = new DefaultActionGroup("Data Source", true);
        group2.addAll(actions);
        group2.getTemplatePresentation().setIcon(DatabaseIcons.Dbms);
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            LocalDataSourceManager.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @NotNull
    public List<AnAction> getCreateDataSourceActions(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull Consumer<LocalDataSource> consumer2) {
        if (allDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(11);
        }
        List<String> lruNames = DatabaseViewActions.getLRUNames(this.myProject, LRU_KEY);
        final Function keyProvider = o -> o.isPredefined() ? StringUtil.notNullize((String)StringUtil.substringBefore((String)o.getId(), (String)"."), (String)o.getId()) : o.getId();
        Function displayNameProvider = o -> o.isPredefined() ? StringUtil.notNullize((String)StringUtil.substringBefore((String)o.getName(), (String)" ("), (String)o.getName()) : o.getName();
        JBIterable drivers = JBIterable.from(allDrivers).unique(keyProvider).collect();
        Condition isPredefined = DatabaseDriver::isPredefined;
        Condition isInLRU = o -> lruNames.contains(keyProvider.fun(o));
        Comparator<DatabaseDriver> comparator = Comparator.comparing(o -> o.getName());
        Comparator<DatabaseDriver> lruComparator = Comparator.comparingInt(o -> lruNames.indexOf(keyProvider.fun(o))).thenComparing(o -> (String)displayNameProvider.fun(o));
        Function toAction = driver -> {
            if (consumer2 == null) {
                LocalDataSourceManager.$$$reportNull$$$0(22);
            }
            return new DumbAwareAction((String)displayNameProvider.fun(driver), null, driver.getIcon(0), (DatabaseDriver)driver, (Consumer)consumer2){
                final /* synthetic */ DatabaseDriver val$driver;
                final /* synthetic */ Consumer val$consumer;
                {
                    this.val$driver = databaseDriver;
                    this.val$consumer = consumer2;
                    super(arg0, arg1, arg2);
                }

                public void actionPerformed(AnActionEvent e) {
                    DatabaseViewActions.addToLRUNames(LocalDataSourceManager.this.myProject, 5, LocalDataSourceManager.LRU_KEY, (String)keyProvider.fun((Object)this.val$driver));
                    this.val$consumer.consume((Object)this.val$driver.createDataSource(null, null));
                }
            };
        };
        List list = drivers.filter(isInLRU).sort(lruComparator).map(toAction).append((Object)Separator.getInstance()).append((Iterable)drivers.filter(isPredefined).filter(Conditions.not((Condition)isInLRU)).sort(comparator).map(toAction)).append((Object)Separator.getInstance()).append((Iterable)drivers.filter(Conditions.not((Condition)isPredefined)).filter(Conditions.not((Condition)isInLRU)).sort(comparator).map(toAction)).toList();
        if (list == null) {
            LocalDataSourceManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public LocalDataSource copyDataSource(@NotNull String newName, @NotNull LocalDataSource copyFrom) {
        if (newName == null) {
            LocalDataSourceManager.$$$reportNull$$$0(13);
        }
        if (copyFrom == null) {
            LocalDataSourceManager.$$$reportNull$$$0(14);
        }
        LocalDataSource result2 = copyFrom.copy();
        result2.setName(StringUtil.notNullize((String)newName, (String)""));
        result2.setFirstSync(ThreeState.NO);
        DatabaseCredentials.getInstance().copyCredentials(copyFrom, result2);
        LocalDataSource localDataSource = result2;
        if (localDataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(15);
        }
        return localDataSource;
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            LocalDataSourceManager.$$$reportNull$$$0(16);
        }
        for (VirtualFile file : files) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<LocalDataSource> createDataSourceByFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            LocalDataSourceManager.$$$reportNull$$$0(17);
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        DataSourceRegistry registry = new DataSourceRegistry(this.myProject);
        registry.setImportedFlag(false);
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DasDataSource dataSource) {
                if (dataSource == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.add((LocalDataSource)dataSource);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/LocalDataSourceManager$3", "onCreated"));
            }
        };
        for (VirtualFile file : files) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType)) continue;
            DatabaseFamilyId familyId = ((DbStorageFileType)fileType).getFamilyId();
            String defaultName = DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)file.getNameWithoutExtension());
            final String path = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
            DataSourceConfigUtil.buildDataSource(familyId, defaultName, null, null, new DataSourceConfiguration(){

                @Override
                public String getDatabase() {
                    return path;
                }
            }, registry.getBuilder().withCallback(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myProject, registry, true, true);
        DataSourceConfigUtil.refreshTablesInBackground(this.myProject, registry.getDataSources());
        ArrayList arrayList = result2;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(19);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(20);
        }
        return DbImplUtil.guessDatabaseDialect(element);
    }

    @Override
    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(21);
        }
        return DbSqlUtil.findSqlDialect(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/LocalDataSourceManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/LocalDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceActions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCreateDataSourceActions$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

