/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequest
extends DataRequest.QueryRequest {
    private final Shared shared;
    public final int queryIndex;
    public final boolean hasNext;
    public final Object resultType;
    public final boolean newTab;
    public boolean force;
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");
    private static final Accepter WARNING = (request, isWarning) -> isWarning;
    private static final Accepter WARNING_NOT_LAST = (request, isWarning) -> isWarning && !request.isLastInChain();
    private static final Accepter ERROR = (request, isWarning) -> !isWarning;
    private static final Accepter ERROR_NOT_LAST = (request, isWarning) -> !isWarning && !request.isLastInChain();
    private static final Accepter NOT_LAST = (request, isWarning) -> !request.isLastInChain();

    @NotNull
    public static ConsoleDataRequest newConsoleRequest(@NotNull AbstractQueryLanguageConsole<?, ?> console, @NotNull Editor editor, @NotNull ScriptModel<?> model, boolean newTab) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ConsoleDataRequest.$$$reportNull$$$0(2);
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints();
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.advance();
        DataRequest.TxMarker batchTx = console.getCurrentTx();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, batchTx, shared, 0, newTab, false);
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(3);
        }
        return consoleDataRequest;
    }

    private ConsoleDataRequest(@NotNull AbstractQueryLanguageConsole<?, ?> console, @NotNull DataRequest.TxMarker txMarker, @NotNull Shared shared, int queryIndex, boolean newTab, boolean force) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(4);
        }
        if (txMarker == null) {
            ConsoleDataRequest.$$$reportNull$$$0(5);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(6);
        }
        super(console, txMarker, ConsoleDataRequest.currentQueryText(console, shared), shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.newTab = newTab;
        this.force = force;
        this.resultType = ((ScriptModel.StatementIt)shared.queries.current()).resultType(console);
        this.hasNext = shared.queries.hasNext();
    }

    @NotNull
    private static String currentQueryText(@NotNull AbstractQueryLanguageConsole<?, ?> console, @NotNull Shared shared) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(7);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(8);
        }
        ScriptModel.PStorage storage = console.getView().getParametersHolder().getPStorage();
        String currentText = ((ScriptModel.StatementIt)shared.queries.current()).text(storage, Conditions.alwaysFalse());
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getLanguageConsole().getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)currentText, (String)lineSeparator);
        if (string == null) {
            ConsoleDataRequest.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private AbstractQueryLanguageConsole<?, ?> getConsole() {
        AbstractQueryLanguageConsole abstractQueryLanguageConsole = (AbstractQueryLanguageConsole)this.owner;
        if (abstractQueryLanguageConsole == null) {
            ConsoleDataRequest.$$$reportNull$$$0(10);
        }
        return abstractQueryLanguageConsole;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            ConsoleDataRequest.$$$reportNull$$$0(11);
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(12);
        }
        return shared;
    }

    public void onError(@Nullable String message, @Nullable Throwable th) {
        if (message != null) {
            this.reportError(ConsoleDataRequest.createThrowable(message, th), false);
            return;
        }
        if (th != null) {
            this.reportError(th, false);
        }
    }

    public void onWarning(@Nullable String message) {
        if (message != null) {
            this.reportError(ConsoleDataRequest.createThrowable(message, null), true);
        }
    }

    public void onFinished() {
        if (!this.isExecutionStopper()) {
            this.getDataProducer().processRequest(this.nextRequest());
        }
    }

    public boolean isExecutionStopper() {
        return this.isLastInChain() || this.hasPendingProblems();
    }

    public boolean isLastInChain() {
        return !this.hasNext;
    }

    private boolean hasPendingProblems() {
        return JBIterable.of((Object[])new ProblemSolver[]{this.shared.errorsSolver, this.shared.warningsSolver}).filter(s -> s.isEnabled() && s.hasUnsolvedProblems()).isNotEmpty();
    }

    @NotNull
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        AbstractQueryLanguageConsole<?, ?> console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex + 1, this.newTab, this.shared.warningsSolver.isForceAll());
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(13);
        }
        return consoleDataRequest;
    }

    @NotNull
    private ConsoleDataRequest cloneRequest() {
        AbstractQueryLanguageConsole<?, ?> console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex, this.newTab, this.force || this.shared.warningsSolver.isForceAll());
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(14);
        }
        return consoleDataRequest;
    }

    public void onStarted() {
        DbUIUtil.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                this.updateConsoleUI(false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.getRange()) != null) {
            this.scrollToRange(range);
        }
        this.updateHighlighting();
    }

    private void reportError(@NotNull Throwable error2, boolean warning) {
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(15);
        }
        ProblemSolver solver = warning ? this.shared.warningsSolver : this.shared.errorsSolver;
        solver.newProblem();
        DbUIUtil.invokeLater(() -> {
            if (error2 == null) {
                ConsoleDataRequest.$$$reportNull$$$0(37);
            }
            this.updateConsoleUI(solver.isEnabled());
            if (!solver.isEnabled()) {
                return;
            }
            this.handleQueryError(error2, (Consumer<Decision>)((Consumer)feedback -> {
                this.closeErrorPanel();
                solver.solve((Decision)((Object)((Object)feedback)), this);
            }), warning);
        });
    }

    public void closeErrorPanel() {
        ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor);
    }

    private void handleQueryError(@NotNull Throwable error2, @Nullable Consumer<Decision> feedbackListener, boolean warning) {
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(16);
        }
        if (error2 instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.shared.sourceEditor.getContentComponent().isShowing()) {
            return;
        }
        Project project = this.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            DatabaseDialect databaseDialect;
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(this.shared.sourceEditor, error2, feedbackListener, warning);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent = errorPanel.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setBorder((Border)JBUI.Borders.empty());
            }
            ERROR_PANEL_KEY.set((UserDataHolder)this.shared.sourceEditor, (Object)new ErrorPanelInfo(errorPanel, feedbackListener));
            this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
            TextRange queryRange = this.getRange();
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((PsiElement)file);
            DatabaseDialect databaseDialect2 = databaseDialect = dialect != null ? dialect.getDatabaseDialect() : null;
            if (queryRange != null && databaseDialect != null) {
                int offset;
                int position = ConsoleDataRequest.getOffsetFromErrorMessage(databaseDialect.getFamilyId(), StringUtil.notNullize((String)error2.getMessage()), this.query, dialect, project);
                int n = offset = position >= 0 ? position + queryRange.getStartOffset() : -1;
                if (offset >= queryRange.getEndOffset()) {
                    offset = queryRange.getEndOffset();
                }
                if (offset > -1) {
                    this.scrollToRange(TextRange.create((int)offset, (int)offset));
                }
            }
        }
    }

    @NotNull
    private static Throwable createThrowable(@NotNull String message, @Nullable Throwable th) {
        if (message == null) {
            ConsoleDataRequest.$$$reportNull$$$0(17);
        }
        Throwable throwable = new Throwable(message);
        throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(18);
        }
        return throwable2;
    }

    private static int getOffsetFromErrorMessage(@NotNull DatabaseFamilyId dialect, @NotNull String message, @NotNull String queryText, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (dialect == null) {
            ConsoleDataRequest.$$$reportNull$$$0(19);
        }
        if (message == null) {
            ConsoleDataRequest.$$$reportNull$$$0(20);
        }
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(21);
        }
        if (language == null) {
            ConsoleDataRequest.$$$reportNull$$$0(22);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(23);
        }
        if (dialect.isPostgres()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bPosition: (\\d+)\\z", -1, -1, 1, message, queryText, null);
        }
        if (dialect.isMysql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)' at line (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        if (dialect.isTransactSql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)'\\.\\z", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, 126));
        }
        if (dialect.isSqlite()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear \"([^\"]*)\":", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, Integer.MAX_VALUE));
        }
        if (dialect.isDerby()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bat line (\\d+), column (\\d+)\\.\\z", -1, 1, 2, message, queryText, null);
        }
        if (dialect.isHsqldb()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(": (.*) : line: (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        return -1;
    }

    private static StringFinder byTokenFinder(@NotNull SqlLanguageDialect dialect, @NotNull Project project, int cropping) {
        if (dialect == null) {
            ConsoleDataRequest.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(25);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser;
            if (dialect == null) {
                ConsoleDataRequest.$$$reportNull$$$0(35);
            }
            if (project == null) {
                ConsoleDataRequest.$$$reportNull$$$0(36);
            }
            if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)dialect)) == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    private static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText, @Nullable StringFinder finder) {
        Matcher matcher;
        if (pattern == null) {
            ConsoleDataRequest.$$$reportNull$$$0(26);
        }
        if (message == null) {
            ConsoleDataRequest.$$$reportNull$$$0(27);
        }
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(28);
        }
        if ((matcher = Pattern.compile(pattern).matcher(message)).find()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    private static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column2;
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(29);
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column2 = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column2 < 0 ? -1 : column2 - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column2 < 0 ? 0 : column2 - 1)));
        if (line > -1 && column2 > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range) {
        Editor editor;
        if (range == null) {
            ConsoleDataRequest.$$$reportNull$$$0(30);
        }
        if ((editor = this.shared.sourceEditor).isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        int offset = range.getEndOffset();
        editor.getCaretModel().moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (!existing.containsOffset(offset)) {
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting() {
        Project project = this.getConsole().getProject();
        if (!project.isOpen() || this.shared.sourceEditor.isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    @NotNull
    private ErrorNotificationPanel createErrorNotificationPanel(@NotNull Editor sourceEditor, @NotNull Throwable error2, @Nullable Consumer<Decision> feedbackListener, boolean warning) {
        if (sourceEditor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(31);
        }
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(32);
        }
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error2, sourceEditor.getContentComponent());
        Iterable<ErrorPanelConfigurator> configurators = ErrorPanelConfigurator.filterFor(this, warning);
        configurators.forEach(c -> c.configure(builder, this, feedbackListener));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TextRange range;
                if (e.getClickCount() == 2 && (range = ConsoleDataRequest.this.getRange()) != null) {
                    ConsoleDataRequest.this.scrollToRange(range);
                    ((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent().requestFocusInWindow();
                    ConsoleDataRequest.this.updateHighlighting();
                }
            }
        });
        ErrorNotificationPanel errorNotificationPanel = notificationPanel;
        if (errorNotificationPanel == null) {
            ConsoleDataRequest.$$$reportNull$$$0(33);
        }
        return errorNotificationPanel;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        ErrorPanelInfo epInfo;
        if (sourceEditor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(34);
        }
        if ((epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)sourceEditor)) == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    static /* synthetic */ Accepter access$600() {
        return NOT_LAST;
    }

    static /* synthetic */ Accepter access$700() {
        return ERROR_NOT_LAST;
    }

    static /* synthetic */ Accepter access$800() {
        return WARNING_NOT_LAST;
    }

    static /* synthetic */ Accepter access$900() {
        return WARNING;
    }

    static /* synthetic */ Accepter access$1000() {
        return ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 15: 
            case 16: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 17: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: 
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 21: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 23: 
            case 25: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsoleRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "currentQueryText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProducer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "nextRequest";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneRequest";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrowable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsoleRequest";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 33: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "currentQueryText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createThrowable";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromErrorMessage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromMessageImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNotificationPanel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hideErrorPanel";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byTokenFinder$4";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reportError$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WarningsSolver
    extends ProblemSolver {
        private boolean myForceAll;

        private WarningsSolver() {
        }

        @Override
        void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request) {
            if (decision == null) {
                WarningsSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                WarningsSolver.$$$reportNull$$$0(1);
            }
            switch (decision) {
                case FORCE_EXECUTE: {
                    ++this.myIgnored;
                    request.force = true;
                    request.getDataProducer().processRequest(request.cloneRequest());
                    break;
                }
                case FORCE_EXECUTE_ALL: {
                    this.myForceAll = true;
                    request.getDataProducer().processRequest(request.cloneRequest());
                    break;
                }
                default: {
                    super.solve(decision, request);
                }
            }
        }

        boolean isForceAll() {
            return this.myForceAll;
        }

        @Override
        boolean isEnabled() {
            return super.isEnabled() && !this.myForceAll;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
            objectArray[2] = "solve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProblemSolver {
        int myCount;
        int myIgnored;
        boolean myIgnoreAll;

        private ProblemSolver() {
        }

        void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request) {
            if (decision == null) {
                ProblemSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ProblemSolver.$$$reportNull$$$0(1);
            }
            switch (decision) {
                case STOP: {
                    break;
                }
                case RETRY: {
                    --this.myCount;
                    request.getDataProducer().processRequest(request.cloneRequest());
                    break;
                }
                case IGNORE_ALL: {
                    this.myIgnoreAll = true;
                    request.getDataProducer().processRequest(request.nextRequest());
                    break;
                }
                case IGNORE: {
                    ++this.myIgnored;
                    request.getDataProducer().processRequest(request.nextRequest());
                    break;
                }
            }
        }

        void newProblem() {
            ++this.myCount;
        }

        boolean hasUnsolvedProblems() {
            return this.myCount > this.myIgnored;
        }

        boolean isEnabled() {
            return !this.myIgnoreAll;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$ProblemSolver";
            objectArray[2] = "solve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LinkConfigurator
    implements Configurator {
        private final Decision myDecision;
        private final String myText;
        private final String myLinkHtml;

        LinkConfigurator(@NotNull Decision decision, @NotNull String text2, @NotNull String linkHtml) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LinkConfigurator.$$$reportNull$$$0(1);
            }
            if (linkHtml == null) {
                LinkConfigurator.$$$reportNull$$$0(2);
            }
            this.myDecision = decision;
            this.myText = text2;
            this.myLinkHtml = linkHtml;
        }

        @Override
        public void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<Decision> listener) {
            if (builder == null) {
                LinkConfigurator.$$$reportNull$$$0(3);
            }
            if (request == null) {
                LinkConfigurator.$$$reportNull$$$0(4);
            }
            if (listener != null) {
                builder.addLink(this.myText, this.myLinkHtml, () -> listener.consume((Object)this.myDecision));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkHtml";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$LinkConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Accepter {
        public boolean accept(@NotNull ConsoleDataRequest var1, boolean var2);
    }

    private static interface Configurator {
        public void configure(@NotNull ErrorNotificationPanel.Builder var1, @NotNull ConsoleDataRequest var2, @Nullable Consumer<Decision> var3);
    }

    private static enum ErrorPanelConfigurator {
        STOP(ConsoleDataRequest.access$600(), new LinkConfigurator(Decision.STOP, "&stop", "<span style=\"text-decoration:underline;\">S</span>top")),
        RETRY(ConsoleDataRequest.access$700(), new LinkConfigurator(Decision.RETRY, "&retry", "<span style=\"text-decoration:underline;\">R</span>etry")),
        IGNORE_ERROR(ConsoleDataRequest.access$700(), new LinkConfigurator(Decision.IGNORE, "&ignore", "<span style=\"text-decoration:underline;\">I</span>gnore")),
        IGNORE_ALL_ERRORS(ConsoleDataRequest.access$700(), new LinkConfigurator(Decision.IGNORE_ALL, "ignore_&all", "Ignore <span style=\"text-decoration:underline;\">A</span>ll")),
        SKIP(ConsoleDataRequest.access$800(), new LinkConfigurator(Decision.IGNORE, "&skip", "<span style=\"text-decoration:underline;\">S</span>kip")),
        SKIP_ALL(ConsoleDataRequest.access$800(), new LinkConfigurator(Decision.IGNORE_ALL, "skip &all", "Skip <span style=\"text-decoration:underline;\">A</span>ll")),
        FORCE_EXECUTE(ConsoleDataRequest.access$900(), new LinkConfigurator(Decision.FORCE_EXECUTE, "&execute", "<span style=\"text-decoration:underline;\">E</span>xecute")),
        FORCE_EXECUTE_ALL(ConsoleDataRequest.access$800(), new LinkConfigurator(Decision.FORCE_EXECUTE_ALL, "execute_&all", "Execute <span style=\"text-decoration:underline;\">A</span>ll")),
        WARNING_MESSAGE_TYPE(ConsoleDataRequest.access$900(), (b, r, l) -> b.messageType(MessageType.WARNING)),
        ERROR_MESSAGE_TYPE(ConsoleDataRequest.access$1000(), (b, r, l) -> b.messageType(MessageType.ERROR)),
        CLOSE((r, w) -> true, (b, r, l) -> b.addCloseButton(() -> ConsoleDataRequest.hideErrorPanel(((ConsoleDataRequest)r).shared.sourceEditor)));

        private final Accepter myAccepter;
        private final Configurator myConfigurator;

        private ErrorPanelConfigurator(Accepter accepter, Configurator configurator) {
            if (accepter == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(0);
            }
            if (configurator == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(1);
            }
            this.myAccepter = accepter;
            this.myConfigurator = configurator;
        }

        boolean isAcceptable(@NotNull ConsoleDataRequest request, boolean warning) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(2);
            }
            return this.myAccepter.accept(request, warning);
        }

        void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<Decision> listener) {
            if (builder == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(3);
            }
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(4);
            }
            this.myConfigurator.configure(builder, request, listener);
        }

        @NotNull
        static Iterable<ErrorPanelConfigurator> filterFor(@NotNull ConsoleDataRequest request, boolean warning) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(5);
            }
            JBIterable jBIterable = JBIterable.of((Object[])ErrorPanelConfigurator.values()).filter(v -> {
                if (request == null) {
                    ErrorPanelConfigurator.$$$reportNull$$$0(7);
                }
                return v.isAcceptable(request, warning);
            });
            if (jBIterable == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accepter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$ErrorPanelConfigurator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$ErrorPanelConfigurator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFor";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$filterFor$5";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(0);
            }
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequest.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                EscapeHandler.$$$reportNull$$$0(2);
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$EscapeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<Decision> decisionConsumer) {
            if (errorPanel == null) {
                ErrorPanelInfo.$$$reportNull$$$0(0);
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }

    private static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        ProblemSolver errorsSolver = new ProblemSolver();
        WarningsSolver warningsSolver = new WarningsSolver();

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it -> {
                TextRange range = it.range().shiftRight((int)it.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            RangeMarker marker = this.rangeMarkers.get(idx);
            return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL,
        FORCE_EXECUTE,
        FORCE_EXECUTE_ALL;

    }
}

