/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseConsoleAction
extends AlignedIconWithTextAction
implements DumbAware {
    public void update(AnActionEvent e) {
        boolean enabled;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || virtualFile == null || !JdbcConsoleProvider.isItPossibleToAttachConsoleTo(virtualFile) || !this.supportsFile(virtualFile)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isToolbar = e.isFromActionToolbar();
        JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(e.getProject(), virtualFile);
        boolean isSqlFile = DbSqlUtil.isSqlFile(psiFile);
        boolean bl = enabled = !this.getDataSources(psiFile).isEmpty();
        String fullText = isToolbar ? (console != null ? console.getTitle() : "<console>") : StringUtil.notNullize((String)this.getTemplatePresentation().getText(), (String)"Attach Console");
        String text2 = fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        boolean visible = (console == null && isSqlFile || isToolbar) && StringUtil.isNotEmpty((String)text2);
        String tooltipText = enabled ? "Switch attached console" : "Attached console";
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text2, false);
        e.getPresentation().setDescription(fullText);
        DbUIUtil.updateComboboxToolbarAction(e, tooltipText);
    }

    protected boolean supportsFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChooseConsoleAction.$$$reportNull$$$0(0);
        }
        return !DbSrcUtils.isDbSrcFile(virtualFile);
    }

    @NotNull
    protected JBIterable<DbDataSource> getDataSources(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ChooseConsoleAction.$$$reportNull$$$0(1);
        }
        JBIterable<DbDataSource> jBIterable = DbImplUtil.getDataSourcesForExec(psiFile, true, false);
        if (jBIterable == null) {
            ChooseConsoleAction.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(this.getRunners(psiFile, console), null, e);
    }

    @NotNull
    private List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiFile psiFile, @Nullable JdbcConsole current) {
        if (psiFile == null) {
            ChooseConsoleAction.$$$reportNull$$$0(3);
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.notNull((Object)PsiUtilCore.getVirtualFile((PsiElement)psiFile));
        JBIterable<DbDataSource> dataSources2 = this.getDataSources(psiFile);
        List<PersistenceConsoleProvider.Runner> list = ChooseConsoleAction.getRunners(dataSources2, psiFile.getProject(), current, (Consumer<JdbcConsole>)((Consumer)console -> JdbcConsoleProvider.attachConsole(project, console, virtualFile)));
        if (list == null) {
            ChooseConsoleAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull JBIterable<DbDataSource> dataSources2, @NotNull Project project, @Nullable JdbcConsole current, @NotNull Consumer<JdbcConsole> consumer2) {
        if (dataSources2 == null) {
            ChooseConsoleAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ChooseConsoleAction.$$$reportNull$$$0(6);
        }
        if (consumer2 == null) {
            ChooseConsoleAction.$$$reportNull$$$0(7);
        }
        Set allowedIds = dataSources2.map(o -> o.getUniqueId()).toSet();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (current != null) {
            result2.add(JdbcConsoleProvider.newPriorityRunner(PriorityAction.Priority.HIGH, "Detach console", false, false, AllIcons.Actions.Cancel, null, () -> {
                if (consumer2 == null) {
                    ChooseConsoleAction.$$$reportNull$$$0(10);
                }
                consumer2.consume(null);
            }));
        }
        for (JdbcConsole console : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (console == current || !allowedIds.contains(console.getDataSource().getUniqueId())) continue;
            result2.add(JdbcConsoleProvider.newRunner(console, () -> {
                if (consumer2 == null) {
                    ChooseConsoleAction.$$$reportNull$$$0(9);
                }
                consumer2.consume((Object)console);
            }));
        }
        for (DbDataSource dataSource : dataSources2) {
            result2.add(JdbcConsoleProvider.newRunner(dataSource, null, consumer2));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ChooseConsoleAction.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseConsoleAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseConsoleAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRunners$3";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRunners$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

