/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.oracle.OraArgument;
import com.intellij.database.model.oracle.OraRoutine;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingSingleModelTaskBuilder;
import com.intellij.database.scripting.oracle.OracleRoutineArgumentsAnalyzer;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public abstract class ExecuteRoutineActionBase
extends AnAction
implements DumbAware {
    protected ExecuteRoutineActionBase() {
        super("Execute Routine", "Executes routine", AllIcons.Actions.Execute);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        ActionData actionData = this.getActionData(e);
        DatabaseFamilyId familyId = actionData.familyId();
        presentation.setEnabledAndVisible(actionData.routine() != null && familyId != null && KnowledgeProvider.forFamily(familyId) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ActionData data = this.getActionData(e);
        DatabaseFamilyId familyId = data.familyId();
        BasicRoutine routine = data.routine();
        BasicModel model = routine == null ? null : routine.getModel();
        Project project = e.getProject();
        if (familyId == null || model == null || project == null) {
            return;
        }
        KnowledgeProvider provider = KnowledgeProvider.forFamily(familyId);
        if (provider == null) {
            return;
        }
        ExecuteRoutineActionBase.withConsole(e, data, (Consumer<JdbcConsole>)((Consumer)console -> ExecuteRoutineActionBase.perform(routine, model, project, console, console.getSearchPath(), console.getDataSource(), new PreviewDialogRunner((JdbcConsole)console))));
    }

    public static void perform(@NotNull BasicRoutine routine, @NotNull BasicModel model, @NotNull Project project, @NotNull DataRequest.OwnerEx owner, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull RequestRunner executor) {
        KnowledgeProvider provider;
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(3);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(5);
        }
        if ((provider = KnowledgeProvider.forFamily(localDataSource.getFamilyId())) == null) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, localDataSource));
        ScriptingFactory factory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ScriptingService service = factory.getScriptingService(model.getRdbms());
        ScriptingSingleModelTask task = ExecuteRoutineActionBase.makeTask(routine, model, searchPath, localDataSource, dataSource);
        String statements2 = StringUtil.join((String[])service.makeScript(task).getScriptStatements(), (String)";\n");
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(localDataSource);
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObjectForSwitch(dataSource, routine);
        SearchPath path = ObjectPaths.searchPathOf((DasObject)searchPathObject);
        String script = executor.editScript(statements2, path);
        if (script == null || StringUtil.isEmptyOrSpaces((String)script)) {
            return;
        }
        DataRequest request = provider.knowledge.makeRequest(project, localDataSource, owner, script, dialect, routine, path);
        if (request != null) {
            executor.runRequest(request);
        }
    }

    @NotNull
    private static ScriptingSingleModelTask makeTask(@NotNull BasicRoutine routine, @NotNull BasicModel model, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dataSource) {
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(6);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(7);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(9);
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.EXECUTE);
        ObjectPath path = (ObjectPath)ObjectUtils.doIfNotNull((Object)searchPath, p -> p.getCurrent());
        ObjectPath databasePath = path == null ? null : path.findParent(ObjectKind.DATABASE, false);
        ObjectPath schemaPath = path == null ? null : path.findParent(ObjectKind.SCHEMA, false);
        BasicDatabase database = databasePath == null ? null : (BasicDatabase)DbSqlUtil.findObjects(dataSource, databasePath).filter(BasicDatabase.class).first();
        BasicSchema schema = schemaPath == null ? null : (BasicSchema)DbSqlUtil.findObjects(dataSource, schemaPath).filter(BasicSchema.class).first();
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setCurrentDatabase(database);
        taskBuilder.setVersion(localDataSource.getVersion());
        taskBuilder.setElements(ContainerUtil.list((Object[])new BasicElement[]{routine}));
        taskBuilder.setOptions(new CustomScriptingOptions(ContainerUtil.map2Map((Collection)ContainerUtil.list((Object[])new Pair[]{Pair.create(ScriptingOptionStatic.CALL, (Object)true)}))));
        ScriptingSingleModelTask scriptingSingleModelTask = taskBuilder.build();
        if (scriptingSingleModelTask == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(10);
        }
        return scriptingSingleModelTask;
    }

    private static void withConsole(@NotNull AnActionEvent e, @NotNull ActionData data, @NotNull Consumer<JdbcConsole> consumer2) {
        List<PersistenceConsoleProvider.Runner> runners;
        JdbcConsole console;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(11);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(12);
        }
        if (consumer2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(13);
        }
        if ((console = data.console()) != null) {
            consumer2.consume((Object)console);
        }
        if ((runners = data.runners(consumer2)).isEmpty()) {
            return;
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, null, e);
    }

    @NotNull
    protected abstract ActionData getActionData(@NotNull AnActionEvent var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeTask";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class FilledData
    implements ActionData {
        protected final BasicRoutine myRoutine;
        protected final DbDataSource myDataSource;

        protected FilledData(@NotNull DbDataSource dataSource, @NotNull BasicRoutine routine) {
            if (dataSource == null) {
                FilledData.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                FilledData.$$$reportNull$$$0(1);
            }
            this.myRoutine = routine;
            this.myDataSource = dataSource;
        }

        @Override
        @Nullable
        public BasicRoutine routine() {
            return this.myRoutine;
        }

        @Override
        @Nullable
        public DatabaseFamilyId familyId() {
            return this.myDataSource.getFamilyId();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$FilledData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface ActionData {
        @Nullable
        public DatabaseFamilyId familyId();

        @Nullable
        public BasicRoutine routine();

        @Nullable
        public JdbcConsole console();

        @NotNull
        public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<JdbcConsole> var1);

        public static class Disabled
        implements ActionData {
            public static final Disabled INSTANCE = new Disabled();

            private Disabled() {
            }

            @Override
            @Nullable
            public DatabaseFamilyId familyId() {
                return null;
            }

            @Override
            @Nullable
            public BasicRoutine routine() {
                return null;
            }

            @Override
            @Nullable
            public JdbcConsole console() {
                return null;
            }

            @Override
            @NotNull
            public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<JdbcConsole> consumer2) {
                if (consumer2 == null) {
                    Disabled.$$$reportNull$$$0(0);
                }
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Disabled.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData$Disabled";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData$Disabled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "runners";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "runners";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class PreviewDialogRunner
    implements RequestRunner {
        private final JdbcConsole myConsole;

        PreviewDialogRunner(@NotNull JdbcConsole console) {
            if (console == null) {
                PreviewDialogRunner.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        @Override
        @Nullable
        public String editScript(@NotNull String script, @Nullable SearchPath path) {
            Project project;
            DatabasePreviewDialog previewDialog;
            if (script == null) {
                PreviewDialogRunner.$$$reportNull$$$0(1);
            }
            return (previewDialog = new DatabasePreviewDialog(project = this.myConsole.getProject(), (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, this.myConsole.getDataSource())), path, "Execute Routine", "", script, ContainerUtil.emptyList())).showAndGet() ? previewDialog.getStatement() : null;
        }

        @Override
        public void runRequest(@NotNull DataRequest request) {
            if (request == null) {
                PreviewDialogRunner.$$$reportNull$$$0(2);
            }
            this.myConsole.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$PreviewDialogRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editScript";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequestRunner {
        @Nullable
        public String editScript(@NotNull String var1, @Nullable SearchPath var2);

        public void runRequest(@NotNull DataRequest var1);
    }

    private static enum KnowledgeProvider {
        POSTGRES((Condition<DatabaseFamilyId>)((Condition)familyId -> familyId == DatabaseFamilyId.POSTGRES), PureSqlStatementsKnowledge.access$000()),
        SQL_SERVER((Condition<DatabaseFamilyId>)((Condition)DatabaseFamilyId::isMicrosoft), PureSqlStatementsKnowledge.access$000()),
        ORACLE((Condition<DatabaseFamilyId>)((Condition)DatabaseFamilyId::isOracle), OracleKnowledge.access$100());

        final ExecutionKnowledge knowledge;
        private final Condition<DatabaseFamilyId> myFamilyChecker;

        private KnowledgeProvider(Condition<DatabaseFamilyId> familyChecker, ExecutionKnowledge knowledge) {
            if (familyChecker == null) {
                KnowledgeProvider.$$$reportNull$$$0(0);
            }
            if (knowledge == null) {
                KnowledgeProvider.$$$reportNull$$$0(1);
            }
            this.myFamilyChecker = familyChecker;
            this.knowledge = knowledge;
        }

        @Nullable
        static KnowledgeProvider forFamily(@NotNull DatabaseFamilyId familyId) {
            if (familyId == null) {
                KnowledgeProvider.$$$reportNull$$$0(2);
            }
            for (KnowledgeProvider value : KnowledgeProvider.values()) {
                if (!value.myFamilyChecker.value((Object)familyId)) continue;
                return value;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyChecker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "knowledge";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$KnowledgeProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forFamily";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OracleKnowledge
    implements ExecutionKnowledge {
        private static final ExecutionKnowledge INSTANCE = new OracleKnowledge();

        private OracleKnowledge() {
        }

        @Override
        @Nullable
        public DataRequest makeRequest(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx owner, @NotNull String script, @NotNull SqlLanguageDialect dialect, @NotNull BasicRoutine routine, @Nullable SearchPath path) {
            if (project == null) {
                OracleKnowledge.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                OracleKnowledge.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                OracleKnowledge.$$$reportNull$$$0(2);
            }
            if (script == null) {
                OracleKnowledge.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                OracleKnowledge.$$$reportNull$$$0(4);
            }
            if (routine == null) {
                OracleKnowledge.$$$reportNull$$$0(5);
            }
            OracleRoutineArgumentsAnalyzer analyzer = new OracleRoutineArgumentsAnalyzer((OraRoutine)routine);
            Version version = dataSource.getVersion();
            List<OraArgument> arguments = analyzer.getCursorArguments();
            List<OracleRoutineArgumentsAnalyzer.PrimitivesPack> packs = analyzer.getPrimitives(version);
            List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
            List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
            List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
            List<OraArgument> plTables = analyzer.getPlTypeArrayArguments();
            int primitiveCursors = packs.stream().mapToInt(p -> p.getEnabled() ? 1 : 0).sum();
            int plTypesCursors = OracleRoutineArgumentsAnalyzer.supportPlTypesInSql(version) ? plArrays.size() + plTables.size() : 0;
            int[] types = new int[arguments.size() + sqlArrays.size() + sqlTables.size() + plTypesCursors + primitiveCursors];
            Arrays.fill(types, -10);
            TIntArrayList parameterTypes = new TIntArrayList(types);
            DataRequest.CallRequest.Statement statement = new DataRequest.CallRequest.Statement(script, parameterTypes);
            List statements2 = ContainerUtil.list((Object[])new DataRequest.CallRequest.Statement[]{statement});
            return DataRequest.newCallRequest(owner, statements2, path);
        }

        static /* synthetic */ ExecutionKnowledge access$100() {
            return INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "script";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$OracleKnowledge";
            objectArray[2] = "makeRequest";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PureSqlStatementsKnowledge
    implements ExecutionKnowledge {
        private static final ExecutionKnowledge INSTANCE = new PureSqlStatementsKnowledge();

        private PureSqlStatementsKnowledge() {
        }

        @Override
        @Nullable
        public DataRequest makeRequest(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx owner, @NotNull String script, @NotNull SqlLanguageDialect dialect, @NotNull BasicRoutine routine, @Nullable SearchPath path) {
            PsiFile file;
            SqlPsiFacade facade;
            ScriptModel scriptModel;
            List queries;
            if (project == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(2);
            }
            if (script == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(4);
            }
            if (routine == null) {
                PureSqlStatementsKnowledge.$$$reportNull$$$0(5);
            }
            return (queries = (scriptModel = (facade = SqlPsiFacade.getInstance((Project)project)).createScriptModel(file = DbSqlUtil.createTemporaryFile(script, project, (Language)dialect))).statements().transform(ScriptModelUtil.TO_TEXT).toList()).isEmpty() ? null : DataRequest.newCallRequest(owner, ContainerUtil.map((Collection)queries, q -> new DataRequest.CallRequest.Statement((String)q)), path);
        }

        static /* synthetic */ ExecutionKnowledge access$000() {
            return INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "script";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$PureSqlStatementsKnowledge";
            objectArray[2] = "makeRequest";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExecutionKnowledge {
        @Nullable
        public DataRequest makeRequest(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull DataRequest.OwnerEx var3, @NotNull String var4, @NotNull SqlLanguageDialect var5, @NotNull BasicRoutine var6, @Nullable SearchPath var7);
    }
}

