/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static boolean isBooleanCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel<DataConsumer.Row, DataConsumer.Column> model;
        DataConsumer.Column c;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(2);
        }
        if ((c = (model = grid.getDataModel(DataAccessType.DATABASE_DATA)).getColumn(column2)) == null || !ObjectFormatter.isBooleanColumn(c)) {
            return false;
        }
        Object value = model.getValueAt(row, column2);
        return value == null || ObjectFormatter.getBooleanValue(value) != null;
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
            }
        });
        popup.show(component, x, y);
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(3);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(4);
        }
        return GridCellEditorsUtil.canComplete(c = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column2)) ? new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List rows = model.getRows();
                ArrayList objects = ContainerUtil.newArrayListWithCapacity((int)rows.size());
                DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
                for (DataConsumer.Row r : rows) {
                    Object v = c.getValue(r);
                    if (v == null) continue;
                    objects.add(grid.getObjectFormatter().getPlainValue(c, r, (DatabaseDialect)dialect));
                }
                ArrayList arrayList = objects;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$2", "getItems"));
            }
        } : null;
    }

    private static boolean canComplete(@Nullable DataConsumer.Column c) {
        return c != null && !DbImplUtil.canInsertBlob(c) && (JdbcUtil.isNumberType((int)c.type) || !c.clazz.equals("java.lang.Integer") || JdbcUtil.isStringType((int)c.type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBooleanCell";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompletionProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

