/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeObject
implements DasObject {
    @NotNull
    public String name;
    @NotNull
    public DeModel model;
    @Nullable
    public String comment;
    @Nullable
    public DasObject editedObject;
    public boolean lightExported;
    public Set<DeObject> lightChildren;
    public final Map<Key, Object> additional;
    public final transient Map<Key, Object> flags;

    protected DeObject(@NotNull DeModel model) {
        if (model == null) {
            DeObject.$$$reportNull$$$0(0);
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = ContainerUtil.newHashMap();
        this.flags = ContainerUtil.newHashMap();
        this.model = model;
    }

    public DeObject(@NotNull String name, @NotNull DeModel model) {
        if (name == null) {
            DeObject.$$$reportNull$$$0(1);
        }
        if (model == null) {
            DeObject.$$$reportNull$$$0(2);
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = ContainerUtil.newHashMap();
        this.flags = ContainerUtil.newHashMap();
        this.name = name;
        this.model = model;
    }

    @NotNull
    public abstract DeObject emptyClone(@NotNull DeModel var1);

    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeCopier copier) {
        if (obj == null) {
            DeObject.$$$reportNull$$$0(3);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(4);
        }
        this.name = obj.name;
        this.comment = obj.comment;
        this.editedObject = obj.editedObject;
        this.lightExported = true;
        if (withChildren) {
            this.copyChildrenFrom(obj, copier);
        }
        DeObject deObject = this;
        if (deObject == null) {
            DeObject.$$$reportNull$$$0(5);
        }
        return deObject;
    }

    @NotNull
    public static <De extends DeObject> De copy(@NotNull De obj, boolean withChildren, @NotNull DeCopier copier) {
        if (obj == null) {
            DeObject.$$$reportNull$$$0(6);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(7);
        }
        De De = copier.copy(obj, withChildren);
        if (De == null) {
            DeObject.$$$reportNull$$$0(8);
        }
        return De;
    }

    public void copyChildrenFrom(@NotNull DeObject obj, @NotNull DeCopier copier) {
        if (obj == null) {
            DeObject.$$$reportNull$$$0(9);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(10);
        }
        this.lightExported = false;
    }

    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @Nullable
    public abstract DeObject getParent();

    @NotNull
    public JBIterable<DeObject> getLightChildren() {
        JBIterable jBIterable = JBIterable.from(this.lightChildren);
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    public void addLightChild(@NotNull DeObject child) {
        if (child == null) {
            DeObject.$$$reportNull$$$0(13);
        }
        if (this.lightChildren == null) {
            this.lightChildren = ContainerUtil.newLinkedHashSet();
        }
        this.lightChildren.add(child);
    }

    public final boolean isAltered(@NotNull DeObject other) {
        if (other == null) {
            DeObject.$$$reportNull$$$0(14);
        }
        return this.isAlteredIgnoringChild(other, Collections.emptySet(), Collections.emptySet());
    }

    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            DeObject.$$$reportNull$$$0(15);
        }
        if (children2 == null) {
            DeObject.$$$reportNull$$$0(16);
        }
        if (otherChildren == null) {
            DeObject.$$$reportNull$$$0(17);
        }
        return !this.name.equals(other.name) || !Comparing.equal((String)this.comment, (String)other.comment) || !ContainerUtil.diff(this.additional, other.additional).isEmpty();
    }

    public String toString() {
        return this.name + "(" + this.getClass().getSimpleName() + ")";
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DeObject.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public DasObject getDasParent() {
        return this.getParent();
    }

    @NotNull
    public JBIterable<DeObject> getDasChildren(@Nullable ObjectKind kind) {
        if (!this.lightExported) {
            JBIterable jBIterable = this.getChildren().filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                DeObject.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.getLightChildren().filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    public short getPosition() {
        return this.editedObject instanceof DasPositioned ? ((DasPositioned)this.editedObject).getPosition() : (short)0;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = this.editedObject instanceof DasPositioned ? this.editedObject.getDisplayOrder() : DasUtil.NO_NAME;
        if (string == null) {
            DeObject.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightChildren";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyChildrenFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLightChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAltered";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DeCopier {
        public static final DeCopier SHALLOW = new DeCopier(){

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                return object;
            }
        };

        @Contract(value="null, _ -> null; !null, _ -> !null")
        public abstract <De extends DeObject> De copy(De var1, boolean var2);

        public static DeCopier deepSubTree(final @NotNull DeObject root2) {
            if (root2 == null) {
                DeCopier.$$$reportNull$$$0(0);
            }
            return new DeConditionCopier(){

                @Override
                protected boolean condition(@Nullable DeObject obj) {
                    while (obj != null) {
                        if (obj == root2) {
                            return true;
                        }
                        obj = obj.getParent();
                    }
                    return false;
                }
            };
        }

        public static DeCopier exportExisting(final @NotNull DeModel model, final @NotNull DasModel targetModel) {
            if (model == null) {
                DeCopier.$$$reportNull$$$0(1);
            }
            if (targetModel == null) {
                DeCopier.$$$reportNull$$$0(2);
            }
            return new DeCopier(){

                @Override
                public <De extends DeObject> De copy(De object, boolean child) {
                    if (object == null) {
                        return null;
                    }
                    if (object.editedObject == null) {
                        return DeObject.copy(object, child, this);
                    }
                    return model.getExportHelper().exportDeep(targetModel, object.editedObject, true);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetModel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/DeObject$DeCopier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deepSubTree";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportExisting";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static abstract class DeConditionCopier
        extends DeCopier {
            private final Map<DeObject, DeObject> myCache = ContainerUtil.newHashMap();

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                if (object == null) {
                    return null;
                }
                DeObject res = this.myCache.get(object);
                if (res == null) {
                    if (!this.condition(object)) {
                        return object;
                    }
                    res = object.emptyClone(object.model);
                    this.myCache.put(object, res);
                    res.copyFrom(object, child, this);
                }
                return (De)res;
            }

            protected abstract boolean condition(@Nullable DeObject var1);
        }
    }
}

