/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeKeysSet;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.ListSet;
import com.intellij.database.schemaEditor.model.ListSetImpl;
import com.intellij.database.util.DasUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeTable
extends DeObject
implements DasTable {
    public static final DeTable STUB = new DeTable("STUB", null, DeModel.STUB);
    public boolean temporary;
    @Nullable
    public DeObject parent;
    public final List<DeColumn> columns;
    public final ListSet<DeIndex> indices;
    public final ListSet<DeForeignKey> foreignKeys;
    public final ListSet<DeConstraint> constraints;
    public final DeKeysSet keys;

    public DeTable(@NotNull DeModel model) {
        if (model == null) {
            DeTable.$$$reportNull$$$0(0);
        }
        super(model);
        this.columns = ContainerUtil.newArrayList();
        this.indices = ListSetImpl.create();
        this.foreignKeys = ListSetImpl.create();
        this.constraints = ListSetImpl.create();
        this.keys = new DeKeysSet();
    }

    public DeTable(@NotNull String name, @Nullable DeObject parent, @NotNull DeModel model) {
        if (name == null) {
            DeTable.$$$reportNull$$$0(1);
        }
        if (model == null) {
            DeTable.$$$reportNull$$$0(2);
        }
        super(name, model);
        this.columns = ContainerUtil.newArrayList();
        this.indices = ListSetImpl.create();
        this.foreignKeys = ListSetImpl.create();
        this.constraints = ListSetImpl.create();
        this.keys = new DeKeysSet();
        this.parent = parent;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            DeTable.$$$reportNull$$$0(3);
        }
        if (copier == null) {
            DeTable.$$$reportNull$$$0(4);
        }
        super.copyFrom(obj, withChildren, copier);
        DeTable tab = (DeTable)obj;
        this.parent = copier.copy(tab.parent, false);
        this.temporary = tab.temporary;
        DeTable deTable = this;
        if (deTable == null) {
            DeTable.$$$reportNull$$$0(5);
        }
        return deTable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeTable.$$$reportNull$$$0(6);
        }
        DeTable deTable = new DeTable(model);
        if (deTable == null) {
            DeTable.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    @Override
    public void copyChildrenFrom(@NotNull DeObject obj, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            DeTable.$$$reportNull$$$0(8);
        }
        if (copier == null) {
            DeTable.$$$reportNull$$$0(9);
        }
        super.copyChildrenFrom(obj, copier);
        DeTable tab = (DeTable)obj;
        this.columns.clear();
        for (DeColumn column2 : tab.columns) {
            this.columns.add(copier.copy(column2, true));
        }
        this.indices.clear();
        for (DeIndex index2 : tab.indices) {
            this.indices.add(copier.copy(index2, true));
        }
        this.foreignKeys.clear();
        for (DeForeignKey foreignKey : tab.foreignKeys) {
            this.foreignKeys.add(copier.copy(foreignKey, true));
        }
        this.constraints.clear();
        for (DeConstraint constraint : tab.constraints) {
            this.constraints.add(copier.copy(constraint, true));
        }
        List newKeys = ContainerUtil.newSmartList();
        for (DeTableKey key2 : tab.keys) {
            newKeys.add(copier.copy(key2, true));
        }
        this.keys.setKeys(newKeys);
        this.keys.setPrimaryKey(copier.copy(tab.keys.getPrimaryKey(), true));
    }

    @Override
    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.from(this.columns).append(this.indices).append(this.foreignKeys).append(this.constraints).append((Iterable)this.keys);
        if (jBIterable == null) {
            DeTable.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DeObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DasObject> otherChildren) {
        HashSet editedIgnore;
        if (other == null) {
            DeTable.$$$reportNull$$$0(11);
        }
        if (children2 == null) {
            DeTable.$$$reportNull$$$0(12);
        }
        if (otherChildren == null) {
            DeTable.$$$reportNull$$$0(13);
        }
        DeTable table = (DeTable)other;
        if (children2.isEmpty()) {
            editedIgnore = otherChildren;
        } else {
            editedIgnore = ContainerUtil.newHashSet();
            for (DeObject deObject : children2) {
                if (deObject.editedObject == null) continue;
                editedIgnore.add(deObject.editedObject);
            }
            editedIgnore.addAll(otherChildren);
        }
        return super.isAlteredIgnoringChild(other, children2, otherChildren) || DeTable.isAltered(this.columns, table.columns, children2, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.indices, table.indices, children2, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.foreignKeys, table.foreignKeys, children2, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.constraints, table.constraints, children2, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.keys, table.keys, children2, (Collection<DasObject>)editedIgnore);
    }

    private static boolean isAltered(@NotNull Collection<? extends DeObject> a, @NotNull Collection<? extends DeObject> b, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<DasObject> editedIgnore) {
        if (a == null) {
            DeTable.$$$reportNull$$$0(14);
        }
        if (b == null) {
            DeTable.$$$reportNull$$$0(15);
        }
        if (ignore == null) {
            DeTable.$$$reportNull$$$0(16);
        }
        if (editedIgnore == null) {
            DeTable.$$$reportNull$$$0(17);
        }
        HashSet edited = ContainerUtil.newHashSet();
        for (DeObject deObject : a) {
            if (ignore.contains(deObject)) continue;
            DeObject editedObject = (DeObject)deObject.editedObject;
            if (!b.contains(editedObject)) {
                return true;
            }
            edited.add(editedObject);
        }
        for (DeObject deObject : b) {
            if (editedIgnore.contains(deObject) || edited.contains(deObject)) continue;
            return true;
        }
        for (DeObject deObject : a) {
            if (ignore.contains(deObject) || !deObject.isAltered((DeObject)ObjectUtils.assertNotNull((Object)deObject.editedObject))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAltered(@Nullable DeObject a, @Nullable DeObject b) {
        if (a == null || b == null) {
            return a != b;
        }
        return a.editedObject != b || a.isAltered((DeObject)a.editedObject);
    }

    private static boolean isAltered(@NotNull List<? extends DeObject> a, @NotNull List<? extends DeObject> b, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<DasObject> editedIgnore) {
        if (a == null) {
            DeTable.$$$reportNull$$$0(18);
        }
        if (b == null) {
            DeTable.$$$reportNull$$$0(19);
        }
        if (ignore == null) {
            DeTable.$$$reportNull$$$0(20);
        }
        if (editedIgnore == null) {
            DeTable.$$$reportNull$$$0(21);
        }
        int i2 = 0;
        int j = 0;
        while (i2 < a.size() && j < b.size()) {
            boolean skip = false;
            if (ignore.contains(a.get(i2))) {
                ++i2;
                skip = true;
            }
            if (editedIgnore.contains(b.get(j))) {
                ++j;
                skip = true;
            }
            if (skip) continue;
            if (DeTable.isAltered(a.get(i2), b.get(j))) {
                return true;
            }
            ++i2;
            ++j;
        }
        return i2 != a.size() || j != b.size();
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        DasColumn editedColumn;
        DeColumn column2 = (DeColumn)ObjectUtils.tryCast((Object)columnInfo, DeColumn.class);
        if (column2 == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                DeTable.$$$reportNull$$$0(22);
            }
            return set;
        }
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column2.flags.contains((Object)DeColumn.Flag.AUTO_INC)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if (DasUtil.isComputed((DasColumn)(editedColumn = (DasColumn)ObjectUtils.tryCast((Object)column2.editedObject, DasColumn.class)))) {
            set.add(DasColumn.Attribute.COMPUTED);
        }
        if (this.keys.getPrimaryKey() != null && this.keys.getPrimaryKey().columns.contains(column2)) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (DeForeignKey deForeignKey : this.foreignKeys) {
            if (!Iterables.contains(deForeignKey.getColumns(), (Object)column2)) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DeIndex deIndex : this.indices) {
            if (!Iterables.contains(deIndex.getColumns(), (Object)column2)) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            DeTable.$$$reportNull$$$0(23);
        }
        return enumSet;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            DeTable.$$$reportNull$$$0(24);
        }
        return objectKind;
    }

    public void removeChild(@NotNull DeObject child) {
        if (child == null) {
            DeTable.$$$reportNull$$$0(25);
        }
        if (child instanceof DeColumn) {
            this.columns.remove(child);
        }
        if (child instanceof DeIndex) {
            this.indices.remove(child);
        }
        if (child instanceof DeForeignKey) {
            this.foreignKeys.remove(child);
        }
        if (child instanceof DeConstraint) {
            this.constraints.remove(child);
        }
        if (child instanceof DeTableKey) {
            this.keys.remove(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeTable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignore";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedIgnore";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyClone";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyChildrenFrom";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAltered";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

