/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDropRoutineOperation
extends DasDdlOperations.DdlOperationGeneratorSimple<DeRoutine> {
    private static final Key<Pair<String, Boolean>> ROUTINE_SOURCE = Key.create((String)"ROUTINE_SOURCE");

    public CreateDropRoutineOperation() {
        super(DasDdlOperations.ALTER_ROUTINE, DeRoutine.class, ObjectKind.ROUTINE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeRoutine object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(0);
        }
        if (object == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(2);
        }
        assert (data != null);
        DeRoutine to = (DeRoutine)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        if (Comparing.equal((String)to.getName(), (String)object.getName())) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }
        Pair<String, Boolean> sources = CreateDropRoutineOperation.getSources(object, context);
        if (sources.second == null) {
            builder.comment("Retrieving definition in progress\n");
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(4);
            }
            return ddlBuilder;
        }
        if (sources.second == Boolean.FALSE) {
            builder.comment("Failed to retrieve definition\n");
            if (sources.first != null) {
                builder.comment((String)sources.first + "\n");
            }
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(5);
            }
            return ddlBuilder;
        }
        String renamed = CreateDropRoutineOperation.renameRoutine((String)sources.first, object.name, to.name, context.getContext());
        if (renamed == null) {
            builder.comment("Failed to rename routine. Do it yourself.");
            builder.plain((String)sources.first);
        } else {
            builder.plain(renamed);
        }
        DbImplUtil.endStatement(builder);
        context.getContext().getDialect().sqlDropProcedure(builder, object);
        DbImplUtil.endStatement(builder);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Nullable
    private static String renameRoutine(@NotNull String text2, @NotNull String oldName, @NotNull String newName, @NotNull DatabaseEditorContext context) {
        if (text2 == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(7);
        }
        if (oldName == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(9);
        }
        if (context == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(10);
        }
        SqlLanguageDialect dialect = context.getSqlDialect();
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText((Language)dialect, (CharSequence)text2), SqlFile.class);
        if (file == null) {
            return null;
        }
        SqlDefinition first = (SqlDefinition)((JBTreeTraverser)file.traverser().expandAndSkip(Conditions.not((Condition)DasUtil.byKind((ObjectKind)ObjectKind.ROUTINE)))).filter(SqlDefinition.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.ROUTINE)).filter(DasUtil.byName((String)oldName)).first();
        if (first == null) {
            return null;
        }
        Collection refs = ReferencesSearch.search((PsiElement)first, (SearchScope)new LocalSearchScope((PsiElement)file)).findAll();
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), null, null, () -> {
            if (newName == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(27);
            }
            if (context == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(28);
            }
            for (PsiReference ref : refs) {
                SqlReferenceExpression expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getElement(), SqlReferenceExpression.class);
                if (expression == null) continue;
                expression.setName(newName);
            }
            first.setName(newName);
            if (context.getDialect().getFamilyId().isHsqldb()) {
                CreateDropRoutineOperation.removeSpecificClause(first);
            }
        }, (PsiFile[])new PsiFile[]{file});
        return first.getText();
    }

    private static void removeSpecificClause(@NotNull SqlDefinition def2) {
        if (def2 == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(11);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        for (SqlClause clause : api.children((Object)def2).filter(SqlClause.class)) {
            if (!clause.getFirstChild().getText().equalsIgnoreCase("specific")) continue;
            clause.delete();
        }
    }

    @NotNull
    private static Pair<String, Boolean> getSources(@NotNull DeRoutine routine, @NotNull DdlBuildingContext context) {
        if (routine == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(12);
        }
        if (context == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(13);
        }
        DatabaseDialectEx dialect = context.getContext().getDialect();
        Pair src = (Pair)ROUTINE_SOURCE.get(routine.flags);
        if (src != null) {
            Pair pair = src;
            if (pair == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(14);
            }
            return pair;
        }
        if (!dialect.supportsProcedureDefinition()) {
            throw new UnsupportedOperationException("Dialect " + dialect.getDisplayName() + " does not support sources");
        }
        src = Pair.create(null, null);
        ROUTINE_SOURCE.set(routine.flags, (Object)src);
        Ref ref = Ref.create((Object)src);
        context.process(() -> {
            if (routine == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(25);
            }
            if (context == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(26);
            }
            ref.set(CreateDropRoutineOperation.tryLoadProcedure(routine, context));
        }).doWhenDone(() -> {
            if (routine == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(24);
            }
            ROUTINE_SOURCE.set(routine.flags, ref.get());
        }).doWhenRejected(() -> {
            if (routine == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(23);
            }
            ROUTINE_SOURCE.set(routine.flags, null);
        });
        Pair pair = (Pair)ref.get();
        if (pair == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(15);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Pair<String, Boolean> tryLoadProcedure(@NotNull DeRoutine routine, @NotNull DdlBuildingContext context) {
        Pair pair;
        ConnectionProvider provider;
        block19: {
            Pair pair2;
            block18: {
                if (routine == null) {
                    CreateDropRoutineOperation.$$$reportNull$$$0(16);
                }
                if (context == null) {
                    CreateDropRoutineOperation.$$$reportNull$$$0(17);
                }
                DatabaseDialectEx dialect = context.getContext().getDialect();
                SqlElement elem = DbRenamePsiElementProcessor.getSqlElement(routine, context.getContext().getDataSource());
                if (elem instanceof SqlCreateProcedureStatement) {
                    Pair pair3 = Pair.create((Object)elem.getText(), (Object)Boolean.TRUE);
                    if (pair3 == null) {
                        CreateDropRoutineOperation.$$$reportNull$$$0(18);
                    }
                    return pair3;
                }
                DbDataSource source = context.getContext().getDataSource();
                if (source == null) {
                    Pair pair4 = Pair.create((Object)"No database connection", (Object)Boolean.FALSE);
                    if (pair4 == null) {
                        CreateDropRoutineOperation.$$$reportNull$$$0(19);
                    }
                    return pair4;
                }
                provider = ConnectionProvider.forElement((DbElement)source, DGDepartment.REFACTORING);
                try {
                    if (!provider.acquire()) {
                        Pair pair5 = Pair.create((Object)"No database connection", (Object)Boolean.FALSE);
                        pair2 = pair5;
                        break block18;
                    }
                    String def2 = dialect.tryToLoadProcedureDefinition(routine, provider.getConnection());
                    if (StringUtil.isEmpty((String)def2)) {
                        Pair<String, DbImplUtil.ConcatenationProps> query = dialect.sqlProcedureDefinition(routine);
                        def2 = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (DbImplUtil.ConcatenationProps)query.second).toString();
                    }
                    if (StringUtil.isNotEmpty((String)def2)) {
                        def2 = StringUtil.convertLineSeparators((String)def2);
                    }
                    Pair pair6 = Pair.create((Object)def2, (Object)Boolean.TRUE);
                    pair = pair6;
                    break block19;
                }
                catch (Exception e) {
                    Pair pair7 = Pair.create((Object)e.getMessage(), (Object)Boolean.FALSE);
                    Pair pair8 = pair7;
                    if (pair8 == null) {
                        CreateDropRoutineOperation.$$$reportNull$$$0(22);
                    }
                    return pair8;
                }
            }
            if (pair2 == null) {
                CreateDropRoutineOperation.$$$reportNull$$$0(20);
            }
            return pair2;
        }
        if (pair == null) {
            CreateDropRoutineOperation.$$$reportNull$$$0(21);
        }
        return pair;
        finally {
            provider.release();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 17: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadProcedure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renameRoutine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeSpecificClause";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadProcedure";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSources$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSources$2";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSources$1";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$renameRoutine$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

