/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.BasicMetaUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingAlterTaskBuilder;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import com.intellij.database.scripting.SqlModelBuilderUtils;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMigration {
    private static final Logger LOG = Logger.getInstance(DbSrcMigration.class);

    public static boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(0);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return false;
        }
        BasicElement element = DbSrcUtils.findObject(null, file.getPath(), BasicElement.class);
        return DbSrcMigration.isSupported(element);
    }

    public static boolean isSupported(@Nullable BasicElement element) {
        BasicModel model;
        BasicModel basicModel = model = element == null ? null : element.getModel();
        if (model == null) {
            return false;
        }
        ScriptingService service = ((ScriptingFactory)ServiceManager.getService(ScriptingFactory.class)).getScriptingService(model.getRdbms());
        return DbSrcMigration.canRefactor(service, element);
    }

    private static boolean canRefactor(ScriptingService service, BasicElement element) {
        BasicModel model = element.getModel();
        return service.capabilities(element).getAlterAnything().get(model == null ? null : model.getRoot().getServerVersion());
    }

    public static ScriptingResult perform(@NotNull ScriptingTask task) {
        if (task == null) {
            DbSrcMigration.$$$reportNull$$$0(1);
        }
        ScriptingService ss = ((ScriptingFactory)ServiceManager.getService(ScriptingFactory.class)).getScriptingService(ScriptingTaskKt.getRdbms(task));
        return ss.makeScript(task);
    }

    @NotNull
    public static List<Pair<BasicElement, VirtualFile>> getObjects(@NotNull Project project, @NotNull Iterable<VirtualFile> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(2);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(3);
        }
        ScriptingFactory sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ArrayList objects = ContainerUtil.newArrayList();
        BasicModel model = null;
        ScriptingService ss = null;
        for (VirtualFile file : files) {
            BasicElement element;
            if (!DbSrcUtils.isDbSrcFile(file) || (element = DbSrcUtils.findObject(project, file.getPath(), BasicElement.class)) == null) continue;
            if (model == null) {
                model = element.getModel();
            }
            if (model != null) {
                ss = sf.getScriptingService(model.getRdbms());
            }
            if (ss == null || !DbSrcMigration.canRefactor(ss, element)) continue;
            objects.add(Pair.create((Object)element, (Object)file));
        }
        ArrayList arrayList = objects;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static ScriptingResult migrate(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files, @Nullable BasicNamespace currentNamespace) {
        ScriptingAlterTask task;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DbSrcMigration.$$$reportNull$$$0(6);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(7);
        }
        if ((task = DbSrcMigration.buildMigrationTask(project, model, files, currentNamespace)) == null || task.getCorrespondence().isEmpty()) {
            return null;
        }
        return DbSrcMigration.perform(task);
    }

    @Nullable
    public static ScriptingAlterTask buildMigrationTask(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files, @Nullable BasicNamespace currentNamespace) {
        List<Pair<BasicElement, SqlFile>> objects;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(8);
        }
        if (model == null) {
            DbSrcMigration.$$$reportNull$$$0(9);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(10);
        }
        if ((objects = DbSrcMigration.findObjects(project, files)).isEmpty()) {
            return null;
        }
        SqlObjectBuilder builder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage(((SqlFile)objects.get((int)0).second).getLanguage());
        if (builder == null) {
            return null;
        }
        Map<BasicElement, BasicModElement> copied = DbSrcMigration.copy(JBIterable.from(objects).transform(p -> (BasicElement)p.first).toSet());
        Map.Entry p2 = (Map.Entry)ContainerUtil.getFirstItem(copied.entrySet());
        if (p2 == null) {
            return null;
        }
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(model, ((BasicModElement)p2.getValue()).getModel());
        DbSrcMigration.buildFromSql(builder, objects, copied);
        for (Map.Entry<BasicElement, BasicModElement> e : copied.entrySet()) {
            builder.finalize((DasObject)e.getValue());
            task.getCorrespondence().add(ElementDelta.create(e.getKey(), (BasicElement)e.getValue()));
        }
        task.setCurrentNamespace(currentNamespace);
        return task.build();
    }

    private static void buildFromSql(SqlObjectBuilder builder, List<Pair<BasicElement, SqlFile>> objects, Map<BasicElement, BasicModElement> copied) {
        for (Pair<BasicElement, SqlFile> object : objects) {
            BasicModElement target = copied.get(object.first);
            if (target == null) {
                throw new AssertionError((Object)"Should not be null");
            }
            DasObject sqlObject = (DasObject)JBIterable.from((Iterable)((SqlFile)object.second).getDdl()).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)target.getKind())).first();
            if (sqlObject == null) continue;
            SqlFile file = (SqlFile)object.second;
            HashMap comments = ContainerUtil.newHashMap();
            DbSrcMigration.collectComments(file, comments);
            DbSrcMigration.buildHierarchy(builder, target, sqlObject, comments);
            DbSrcMigration.buildAlterStatements(builder, target, file);
        }
    }

    private static void collectComments(SqlFile file, @NotNull Map<DasObject, String> comments) {
        if (comments == null) {
            DbSrcMigration.$$$reportNull$$$0(11);
        }
        SqlCompositeElementType commentToken = SqlTokenRegistry.getCompositeType((String)"SQL_COMMENT_STATEMENT");
        for (SqlAlterStatement stmt : SyntaxTraverser.psiTraverser((PsiElement)file).filter(SqlAlterStatement.class)) {
            IElementType type = PsiUtilCore.getElementType((PsiElement)stmt);
            if (type != commentToken) continue;
            DbSrcMigration.processCommentStmt(stmt, comments);
        }
    }

    private static void buildAlterStatements(@NotNull SqlObjectBuilder builder, @NotNull BasicModElement target, @NotNull SqlFile file) {
        if (builder == null) {
            DbSrcMigration.$$$reportNull$$$0(12);
        }
        if (target == null) {
            DbSrcMigration.$$$reportNull$$$0(13);
        }
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(14);
        }
        SyntaxTraverser traverser2 = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).expandAndSkip(e -> PsiUtilCore.getElementType((PsiElement)e) == GeneratedParserUtilBase.DUMMY_BLOCK);
        for (SqlAlterStatement statement : traverser2.filter(SqlAlterStatement.class)) {
            builder.build((DasObject)target, (SqlElement)statement);
        }
    }

    private static void processCommentStmt(@NotNull SqlAlterStatement stmt, @NotNull Map<DasObject, String> comments) {
        if (stmt == null) {
            DbSrcMigration.$$$reportNull$$$0(15);
        }
        if (comments == null) {
            DbSrcMigration.$$$reportNull$$$0(16);
        }
        SqlReferenceExpression tgt = stmt.getAlterTargetReference();
        for (SqlClause clause : ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)stmt).expandAndSkip(e -> {
            if (stmt == null) {
                DbSrcMigration.$$$reportNull$$$0(30);
            }
            return PsiUtilCore.getElementType((PsiElement)e) == GeneratedParserUtilBase.DUMMY_BLOCK || e == stmt;
        })).filter(SqlClause.class)) {
            String text2;
            SqlExpression comment;
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlReferenceExpression.class);
            SqlExpression sqlExpression = comment = ref == null ? (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlExpression.class) : (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref, SqlExpression.class);
            if (ref == null) {
                ref = tgt;
            }
            if (ref == null || comment == null) continue;
            String string = text2 = comment instanceof SqlStringLiteralExpression ? ((SqlStringLiteralExpression)comment).getValue() : null;
            if (text2 == null) continue;
            for (ResolveResult result2 : ref.multiResolve(false)) {
                DasObject target = (DasObject)ObjectUtils.tryCast((Object)result2.getElement(), DasObject.class);
                if (target == null) continue;
                comments.put(target, text2);
            }
        }
    }

    private static void buildHierarchy(SqlObjectBuilder builder, BasicModElement target, DasObject sqlObject, Map<DasObject, String> comments) {
        DbSrcMigration.buildParents(builder, target, sqlObject);
        DbSrcMigration.buildObjectRec(builder, target, sqlObject, comments);
    }

    private static void buildParents(SqlObjectBuilder builder, BasicModElement target, DasObject sqlObject) {
        BasicModElement t = (BasicModElement)target.getParent();
        for (DasObject s = sqlObject.getDasParent(); s != null && t != null && s.getKind() == t.getKind() && !s.getName().isEmpty(); t = (BasicModElement)t.getParent(), s = s.getDasParent()) {
            builder.build((DasObject)t, s);
        }
    }

    private static void buildObjectRec(SqlObjectBuilder builder, BasicModElement target, DasObject sqlObject, Map<DasObject, String> comments) {
        for (ModFamily<? extends BasicModElement> modFamily : target.getFamilies()) {
            modFamily.markChildrenAsSyncPending();
        }
        for (DasObject dasObject : sqlObject.getDasChildren(null)) {
            BasicModElement childTarget = SqlModelBuilderUtils.createObject(target, dasObject.getName(), DbSqlUtil.isQuoted(dasObject), ObjectPaths.getIdentity(dasObject), dasObject.getKind());
            if (childTarget == null) continue;
            DbSrcMigration.buildObjectRec(builder, childTarget, dasObject, comments);
        }
        for (ModFamily<? extends BasicModElement> modFamily : target.getFamilies()) {
            modFamily.removeSyncPendingChildren();
            modFamily.sort();
        }
        builder.build((DasObject)target, sqlObject);
        String comment = comments.get(sqlObject);
        if (comment != null && target instanceof BasicModNamedElement) {
            ((BasicModNamedElement)target).setComment(comment);
        }
    }

    @NotNull
    private static Map<BasicElement, BasicModElement> copy(@NotNull Set<BasicElement> deepObjects) {
        if (deepObjects == null) {
            DbSrcMigration.$$$reportNull$$$0(17);
        }
        HashMap res = ContainerUtil.newHashMap();
        Set shallowObjects = JBIterable.from(deepObjects).flatMap(o -> JBIterable.generate((Object)o, element1 -> element1.getParent())).filter(o -> {
            if (deepObjects == null) {
                DbSrcMigration.$$$reportNull$$$0(29);
            }
            return !deepObjects.contains(o);
        }).toSet();
        BasicModel baseModel = (BasicModel)ObjectUtils.assertNotNull((Object)deepObjects.iterator().next().getModel());
        BasicModModel targetModel = new ModelFactory(new MemoryTextStorage()).createModel(baseModel.getRdbms());
        targetModel.modify(BasicModRoot.class, r -> {
            if (deepObjects == null) {
                DbSrcMigration.$$$reportNull$$$0(28);
            }
            Queue q = new Queue(10);
            q.addLast((Object)Trinity.create((Object)baseModel.getRoot(), (Object)((BasicModElement)((Object)targetModel.getRoot())), (Object)false));
            while (!q.isEmpty()) {
                Trinity task = (Trinity)q.pullFirst();
                res.put(task.first, task.second);
                BasicMetaUtils.copyProperties((BasicElement)task.first, (BasicModElement)task.second, true);
                for (BasicElement element : ((BasicElement)task.first).getChildren()) {
                    boolean deep;
                    boolean bl = deep = (Boolean)task.third != false || deepObjects.contains(element);
                    if (!deep && !shallowObjects.contains(element)) continue;
                    Object target = ((ModFamily)ObjectUtils.assertNotNull((Object)((BasicModElement)task.second).familyOf(element.getKind()))).createNewOne();
                    q.addLast((Object)Trinity.create((Object)element, target, (Object)deep));
                }
            }
        });
        HashMap hashMap = res;
        if (hashMap == null) {
            DbSrcMigration.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @NotNull
    private static List<Pair<BasicElement, SqlFile>> findObjects(@NotNull Project project, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(19);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(20);
        }
        FileDocumentManager dm = FileDocumentManager.getInstance();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        ArrayList objects = ContainerUtil.newArrayList();
        for (Pair<BasicElement, VirtualFile> file : files) {
            SqlFile psiFile;
            Document doc = dm.getDocument((VirtualFile)file.second);
            SqlFile sqlFile = psiFile = doc == null ? null : (SqlFile)ObjectUtils.tryCast((Object)pdm.getPsiFile(doc), SqlFile.class);
            if (psiFile == null) continue;
            objects.add(Pair.create((Object)file.first, (Object)psiFile));
        }
        ArrayList arrayList = objects;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    public static void showMigrationDialog(@NotNull DbDataSource dataSource, @NotNull Iterable<VirtualFile> files) {
        SearchPath searchPath;
        DatabasePreviewDialog dialog;
        if (dataSource == null) {
            DbSrcMigration.$$$reportNull$$$0(22);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(23);
        }
        Project project = dataSource.getProject();
        List<Pair<BasicElement, VirtualFile>> objects = DbSrcMigration.getObjects(project, files);
        BasicElement any = (BasicElement)JBIterable.from(objects).filterMap(Functions.pairFirst()).first();
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(dataSource, any), BasicNamespace.class);
        ScriptingAlterTask task = null;
        if (!objects.isEmpty()) {
            BasicModel model = (BasicModel)ObjectUtils.assertNotNull((Object)((BasicElement)objects.get((int)0).first).getModel());
            task = DbSrcMigration.buildMigrationTask(project, model, objects, namespace);
        }
        CompositeText text2 = null;
        if (task != null && !task.getCorrespondence().isEmpty()) {
            text2 = DbSrcMigration.perform(task).getScript();
        }
        if (text2 != null) {
            try {
                text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource), text2);
            }
            catch (Throwable th) {
                LOG.warn("Formatting failed", th);
            }
        }
        if ((dialog = new DatabasePreviewDialog(project, dataSource, searchPath = ObjectPaths.searchPathOf(namespace), "Object Migration", "Script", text2 == null ? "" : text2.getText().toString(), text2 == null ? Collections.singletonList("Generation failed") : Collections.emptyList())).showAndGet()) {
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(dataSource, searchPath).setStatement(dialog.getStatement());
            LoaderContext context = handler.getContext();
            for (VirtualFile file : files) {
                DbElement item = DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
                if (item == null) continue;
                context.include(item);
            }
            handler.runStatements(false);
        }
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CompositeText text2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            DbSrcMigration.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            DbSrcMigration.$$$reportNull$$$0(26);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList ranges = ContainerUtil.newArrayList();
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            int start = document.getTextLength();
            document.insertString(start, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            RangeMarker marker = kind.getReformattable() ? document.createRangeMarker(start, end) : document.createGuardedBlock(start, end);
            ranges.add(Pair.create((Object)marker, (Object)fragment));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document);
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (Pair range : ranges) {
            if (!((RangeMarker)range.first).isValid()) {
                LOG.warn("Range marker died during formatting");
                continue;
            }
            builder.add(((CompositeText.Fragment)range.second).getKind(), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset(), ((CompositeText.Fragment)range.second).getError());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcMigration.$$$reportNull$$$0(27);
        }
        return persistentMarkup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scripting/DbSrcMigration";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 17: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepObjects";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scripting/DbSrcMigration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 27: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildMigrationTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectComments";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildAlterStatements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processCommentStmt";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showMigrationDialog";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copy$6";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copy$5";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCommentStmt$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

