/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteTableHelper {
    @NotNull
    public static List<DasTable> getDeletionOrder(@NotNull DasModel model, @NotNull Iterable<DasTable> tables, boolean checkConstraints) {
        if (model == null) {
            DeleteTableHelper.$$$reportNull$$$0(0);
        }
        if (tables == null) {
            DeleteTableHelper.$$$reportNull$$$0(1);
        }
        List<DasTable> insertionOrder = DeleteTableHelper.getInsertionOrder(model, tables);
        Collections.reverse(insertionOrder);
        if (checkConstraints) {
            DeleteTableHelper.checkConstraints(model, insertionOrder);
        }
        List<DasTable> list = insertionOrder;
        if (list == null) {
            DeleteTableHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static void checkConstraints(DasModel model, @NotNull Iterable<DasTable> order) {
        if (order == null) {
            DeleteTableHelper.$$$reportNull$$$0(3);
        }
        ArrayList<DasForeignKey> droppedFk = new ArrayList<DasForeignKey>(0);
        for (DasTable table : order) {
            for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)table)) {
                droppedFk.add(key2);
            }
        }
        for (DasTable table : order) {
            for (DasConstraint exportKey : model.getExportedKeys(table)) {
                if (DeleteTableHelper.isDeleted(table, exportKey, droppedFk)) continue;
                String message = "Can not delete table " + table.getName() + ", because constraint " + StringUtil.notNullize((String)exportKey.getName()) + " exists on table " + StringUtil.notNullize((String)exportKey.getTableName()) + ".";
                throw new UnsupportedOperationException(message);
            }
        }
    }

    private static boolean isDeleted(@NotNull DasTable table, @NotNull DasConstraint exportedKey, @NotNull List<DasForeignKey> fks) {
        DasForeignKey deletedKey;
        if (table == null) {
            DeleteTableHelper.$$$reportNull$$$0(4);
        }
        if (exportedKey == null) {
            DeleteTableHelper.$$$reportNull$$$0(5);
        }
        if (fks == null) {
            DeleteTableHelper.$$$reportNull$$$0(6);
        }
        return (deletedKey = (DasForeignKey)ContainerUtil.find(fks, o -> {
            if (exportedKey == null) {
                DeleteTableHelper.$$$reportNull$$$0(10);
            }
            if (table == null) {
                DeleteTableHelper.$$$reportNull$$$0(11);
            }
            return o == exportedKey || (QNameUtil.isFakeName(exportedKey.getName()) || Comparing.strEqual((String)o.getName(), (String)exportedKey.getName())) && Comparing.strEqual((String)o.getRefTableName(), (String)table.getName(), (boolean)false) && Comparing.strEqual((String)((String)ObjectUtils.chooseNotNull((Object)o.getRefTableSchema(), (Object)DasUtil.getSchema((DasObject)o))), (String)DasUtil.getSchema((DasObject)table), (boolean)false) && Comparing.strEqual((String)((String)ObjectUtils.chooseNotNull((Object)o.getRefTableCatalog(), (Object)DasUtil.getCatalog((DasObject)o))), (String)DasUtil.getCatalog((DasObject)table), (boolean)false) && Comparing.strEqual((String)exportedKey.getTable().getName(), (String)o.getTable().getName(), (boolean)false) && Comparing.strEqual((String)DasUtil.getSchema((DasObject)exportedKey.getTable()), (String)DasUtil.getSchema((DasObject)o.getTable()), (boolean)false) && Comparing.strEqual((String)DasUtil.getCatalog((DasObject)exportedKey.getTable()), (String)DasUtil.getCatalog((DasObject)o.getTable()), (boolean)false);
        })) != null;
    }

    @NotNull
    public static List<DasTable> getInsertionOrder(DasModel model, @NotNull Iterable<DasTable> tables) {
        if (tables == null) {
            DeleteTableHelper.$$$reportNull$$$0(7);
        }
        ArrayList<DasTable> result2 = new ArrayList<DasTable>();
        ArrayList<DasTable> unattached = new ArrayList<DasTable>();
        ArrayList<DasTable> children2 = new ArrayList<DasTable>();
        ArrayList<DasTable> parents = new ArrayList<DasTable>();
        ArrayList<DasTable> sandwiches = new ArrayList<DasTable>();
        for (DasTable table : tables) {
            JBIterable importedKeys = DasUtil.getForeignKeys((DasTable)table);
            JBIterable exportedKeys = model.getExportedKeys(table);
            if (Iterables.isEmpty((Iterable)importedKeys) && Iterables.isEmpty((Iterable)exportedKeys)) {
                unattached.add(table);
                continue;
            }
            if (!Iterables.isEmpty((Iterable)exportedKeys)) {
                if (!Iterables.isEmpty((Iterable)importedKeys)) {
                    sandwiches.add(table);
                    continue;
                }
                parents.add(table);
                continue;
            }
            children2.add(table);
        }
        DeleteTableHelper.reorderTables(sandwiches);
        result2.addAll(unattached);
        result2.addAll(parents);
        result2.addAll(sandwiches);
        result2.addAll(children2);
        ArrayList<DasTable> arrayList = result2;
        if (arrayList == null) {
            DeleteTableHelper.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void reorderTables(@NotNull List<DasTable> sandwiches) {
        if (sandwiches == null) {
            DeleteTableHelper.$$$reportNull$$$0(9);
        }
        Collections.sort(sandwiches, (t1, t2) -> {
            JBIterable t1ImportedKeys = DasUtil.getForeignKeys((DasTable)t1);
            for (DasForeignKey info : t1ImportedKeys) {
                if (!info.getTableName().equals(t2.getName())) continue;
                return 1;
            }
            JBIterable t2ImportedKeys = DasUtil.getForeignKeys((DasTable)t2);
            for (DasForeignKey info : t2ImportedKeys) {
                if (!info.getTableName().equals(t1.getName())) continue;
                return -1;
            }
            if (Iterables.size((Iterable)DasUtil.getForeignKeys((DasTable)t1)) > Iterables.size((Iterable)t2ImportedKeys)) {
                return 1;
            }
            if (Iterables.size((Iterable)DasUtil.getForeignKeys((DasTable)t1)) < Iterables.size((Iterable)t2ImportedKeys)) {
                return -1;
            }
            return 0;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scripting/DeleteTableHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sandwiches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scripting/DeleteTableHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletionOrder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertionOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeletionOrder";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConstraints";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDeleted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionOrder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reorderTables";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDeleted$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

