/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.db2.Db2Model;
import com.intellij.database.model.derby.DerbyModel;
import com.intellij.database.model.exasol.ExasolModel;
import com.intellij.database.model.h2.H2Model;
import com.intellij.database.model.hsql.HsqlModel;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mssql.MsRoot;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.redshift.RedshiftModel;
import com.intellij.database.model.sqlite.SqliteModel;
import com.intellij.database.model.sybase.SybaseDatabase;
import com.intellij.database.model.sybase.SybaseModel;
import com.intellij.database.model.sybase.SybaseRoot;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.NamingServices;
import com.intellij.database.scripting.db2.Db2NamingService;
import com.intellij.database.scripting.derby.DerbyNamingService;
import com.intellij.database.scripting.exasol.ExasolNamingService;
import com.intellij.database.scripting.generic.GenericNamingService;
import com.intellij.database.scripting.h2.H2NamingService;
import com.intellij.database.scripting.hsql.HsqlNamingService;
import com.intellij.database.scripting.mssql.TsqlNamingService;
import com.intellij.database.scripting.mysql.MysqlNamingService;
import com.intellij.database.scripting.oracle.OraNamingService;
import com.intellij.database.scripting.postgres.PostgresNamingService;
import com.intellij.database.scripting.redshift.RedshiftNamingService;
import com.intellij.database.scripting.sqlite.SqliteNamingService;
import com.intellij.database.util.Casing;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002RL\u0010\u0003\u001a@\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006*\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/NamingServices;", "", "()V", "generics", "", "Lcom/intellij/database/util/Casing;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/scripting/generic/GenericNamingService;", "", "tsqlCI", "Lcom/intellij/database/scripting/mssql/TsqlNamingService;", "tsqlCS", "getNamingService", "Lcom/intellij/database/scripting/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getTsqlNamingService", "cs", "", "intellij.database.scripting"})
public final class NamingServices {
    private static final Map<Casing, GenericNamingService> generics;
    private static final TsqlNamingService tsqlCS;
    private static final TsqlNamingService tsqlCI;
    public static final NamingServices INSTANCE;

    @NotNull
    public final NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
        NamingService namingService;
        BasicModel basicModel = model;
        if (basicModel instanceof OraModel) {
            namingService = OraNamingService.INSTANCE;
        } else if (basicModel instanceof PostgresModel) {
            namingService = PostgresNamingService.INSTANCE;
        } else if (basicModel instanceof RedshiftModel) {
            namingService = RedshiftNamingService.INSTANCE;
        } else if (basicModel instanceof MysqlModel) {
            namingService = MysqlNamingService.INSTANCE;
        } else if (basicModel instanceof SqliteModel) {
            namingService = SqliteNamingService.INSTANCE;
        } else if (basicModel instanceof ExasolModel) {
            namingService = ExasolNamingService.INSTANCE;
        } else if (basicModel instanceof Db2Model) {
            namingService = Db2NamingService.INSTANCE;
        } else if (basicModel instanceof DerbyModel) {
            namingService = DerbyNamingService.INSTANCE;
        } else if (basicModel instanceof H2Model) {
            namingService = H2NamingService.INSTANCE;
        } else if (basicModel instanceof HsqlModel) {
            namingService = HsqlNamingService.INSTANCE;
        } else if (basicModel instanceof MsModel) {
            MsDatabase msDatabase;
            BasicDatabase basicDatabase = database;
            if (!(basicDatabase instanceof MsDatabase)) {
                basicDatabase = null;
            }
            if ((msDatabase = (MsDatabase)basicDatabase) == null || (msDatabase = msDatabase.getCasing()) == null) {
                MsRoot msRoot = ((MsModel)model).getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)msRoot, (String)"model.root");
                msDatabase = msRoot.getDefaultCasing();
            }
            namingService = this.getTsqlNamingService(((Casing)msDatabase).plain.sensitive);
        } else if (basicModel instanceof SybaseModel) {
            SybaseDatabase sybaseDatabase;
            BasicDatabase basicDatabase = database;
            if (!(basicDatabase instanceof SybaseDatabase)) {
                basicDatabase = null;
            }
            if ((sybaseDatabase = (SybaseDatabase)basicDatabase) == null || (sybaseDatabase = sybaseDatabase.getCasing()) == null) {
                SybaseRoot sybaseRoot = ((SybaseModel)model).getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)sybaseRoot, (String)"model.root");
                sybaseDatabase = sybaseRoot.getDefaultCasing();
            }
            namingService = this.getTsqlNamingService(((Casing)sybaseDatabase).plain.sensitive);
        } else {
            Object object = model;
            if (object == null || (object = object.getRoot()) == null || (object = object.getDefaultCasing()) == null) {
                object = BasicNamespace.UPPER_CASING;
            }
            GenericNamingService genericNamingService = generics.get(object);
            if (genericNamingService == null) {
                Intrinsics.throwNpe();
            }
            namingService = genericNamingService;
        }
        return namingService;
    }

    private final TsqlNamingService getTsqlNamingService(boolean cs) {
        return cs ? tsqlCS : tsqlCI;
    }

    private NamingServices() {
    }

    static {
        NamingServices namingServices;
        INSTANCE = namingServices = new NamingServices();
        generics = FactoryMap.create((Function)generics.1.INSTANCE);
        tsqlCS = new TsqlNamingService(true);
        tsqlCI = new TsqlNamingService(false);
    }
}

