/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.scripting.Effect;
import com.intellij.database.scripting.EffectCommon;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.RequiredEffect;
import com.intellij.database.scripting.ScriptingGraphUtilsKt;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\b\u0005\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u001a\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014*\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\n\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0017\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019*\b\u0012\u0004\u0012\u00020\u00040\u001a\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00020\u001a\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019*\b\u0012\u0004\u0012\u00020\u00060\u001a\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0019*\b\u0012\u0004\u0012\u00020\b0\u001a\u001a\n\u0010\u001e\u001a\u00020\u0017*\u00020\u0017\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"EFFECT_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/database/scripting/Effect;", "OBJ_COMPARATOR", "Lcom/intellij/database/model/basic/BasicElement;", "OP_COMPARATOR", "Lcom/intellij/database/scripting/Operation;", "REQUIRED_EFFECT_COMPARATOR", "Lcom/intellij/database/scripting/RequiredEffect;", "compareCommon", "", "e1", "Lcom/intellij/database/scripting/EffectCommon;", "e2", "comparePath", "p1", "Lcom/intellij/database/vfs/ObjectPath;", "p2", "indent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "d", "quote", "", "sortedB", "", "", "sortedE", "sortedO", "sortedRE", "xmlEsc", "intellij.database.scripting"})
public final class ScriptingGraphUtilsKt {
    private static final Comparator<Operation> OP_COMPARATOR = OP_COMPARATOR.1.INSTANCE;
    private static final Comparator<Effect> EFFECT_COMPARATOR = EFFECT_COMPARATOR.1.INSTANCE;
    private static final Comparator<RequiredEffect> REQUIRED_EFFECT_COMPARATOR = REQUIRED_EFFECT_COMPARATOR.1.INSTANCE;
    private static final Comparator<BasicElement> OBJ_COMPARATOR = OBJ_COMPARATOR.1.INSTANCE;

    @NotNull
    public static final List<Effect> sortedE(@NotNull Iterable<Effect> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.sortedWith($receiver, EFFECT_COMPARATOR);
    }

    @NotNull
    public static final List<RequiredEffect> sortedRE(@NotNull Iterable<RequiredEffect> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.sortedWith($receiver, REQUIRED_EFFECT_COMPARATOR);
    }

    @NotNull
    public static final List<Operation> sortedO(@NotNull Iterable<Operation> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.sortedWith($receiver, OP_COMPARATOR);
    }

    @NotNull
    public static final List<BasicElement> sortedB(@NotNull Iterable<? extends BasicElement> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.sortedWith($receiver, OBJ_COMPARATOR);
    }

    private static final int compareCommon(EffectCommon e1, EffectCommon e2) {
        return e1.getType() != e2.getType() ? Comparing.compare((int)e1.getType().ordinal(), (int)e2.getType().ordinal()) : ScriptingGraphUtilsKt.comparePath(e1.getTarget(), e2.getTarget());
    }

    private static final int comparePath(ObjectPath p1, ObjectPath p2) {
        int n;
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null || p2 == null) {
            return p1 == null ? -1 : 1;
        }
        int p = ScriptingGraphUtilsKt.comparePath(p1.parent, p2.parent);
        if (p != 0) {
            return p;
        }
        p = p1.kind.compareTo(p2.kind);
        if (p != 0) {
            n = p;
        } else {
            String string = p1.name;
            String string2 = p2.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"p2.name");
            n = string.compareTo(string2);
        }
        return n;
    }

    @NotNull
    public static final String quote(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return '\"' + StringUtil.escapeStringCharacters((String)$receiver) + '\"';
    }

    @NotNull
    public static final String xmlEsc(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = StringUtil.escapeXml((String)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.escapeXml(this)");
        return string;
    }

    @NotNull
    public static final StringBuilder indent(@NotNull StringBuilder $receiver, int d) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringUtil.repeatSymbol((Appendable)$receiver, (char)'\t', (int)d);
        return $receiver;
    }

    public static final /* synthetic */ int access$compareCommon(@NotNull EffectCommon e1, @NotNull EffectCommon e2) {
        return ScriptingGraphUtilsKt.compareCommon(e1, e2);
    }

    public static final /* synthetic */ int access$comparePath(@Nullable ObjectPath p1, @Nullable ObjectPath p2) {
        return ScriptingGraphUtilsKt.comparePath(p1, p2);
    }
}

