/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.Effect;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.ObjectPathTrie;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.RequiredEffect;
import com.intellij.database.scripting.Scenario;
import com.intellij.database.scripting.ScenarioDot;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.scripting.SimpleProducer;
import com.intellij.database.scripting.base.AbstractCodeGenerator$WhenMappings;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u0000 \u0080\u00012\u00020\u0001:\u0006\u0080\u0001\u0081\u0001\u0082\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010/\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\u0016\u00103\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0014J\b\u00104\u001a\u000205H\u0002J\n\u00106\u001a\u0004\u0018\u00010#H\u0004J\n\u00107\u001a\u0004\u0018\u00010#H\u0004J\b\u00108\u001a\u000205H\u0016J,\u00109\u001a\u0002052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010:\u001a\u00020+2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002050<H\u0004J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u0002020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002020@H\u0014J\b\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\n\u0012\u0004\u0012\u000202\u0018\u000101H\u0002J\u0016\u0010D\u001a\u00020E2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\u0006\u0010F\u001a\u000205J\u0010\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020HH\u0002J3\u0010I\u001a\u0002052\u0006\u0010J\u001a\u0002022\u0006\u0010K\u001a\u0002022\u0018\u0010L\u001a\u0014\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002050MH\u0082\bJ\"\u0010N\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002020O2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002020PH\u0002J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020R01H\u0016J\u0006\u0010S\u001a\u00020\u001bJ\n\u0010T\u001a\u0004\u0018\u00010#H\u0004J\b\u0010U\u001a\u00020+H\u0014J\u0012\u0010V\u001a\u0004\u0018\u0001022\u0006\u0010W\u001a\u00020XH\u0016J\b\u0010Y\u001a\u000202H\u0002J%\u0010Z\u001a\u0002052\u001b\u0010;\u001a\u0017\u0012\b\u0012\u00060\u0006R\u00020\u0003\u0012\u0004\u0012\u0002050[\u00a2\u0006\u0002\b\\H\u0004J\b\u0010]\u001a\u00020+H\u0014J\b\u0010^\u001a\u000205H\u0002J\b\u0010_\u001a\u000205H&J(\u0010`\u001a\u0002052\f\u0010?\u001a\b\u0012\u0004\u0012\u0002020P2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002050[J\u0006\u0010b\u001a\u000205J\u0010\u0010b\u001a\u0002052\u0006\u0010c\u001a\u000202H\u0016J\u001c\u0010d\u001a\u0004\u0018\u00010#2\u0006\u0010e\u001a\u00020X2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010#J\b\u0010g\u001a\u000205H\u0016J\n\u0010h\u001a\u0004\u0018\u00010#H\u0004J\u0010\u0010i\u001a\u00020#2\u0006\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u000205H\u0016J\u0012\u0010m\u001a\u00020+2\b\u0010n\u001a\u0004\u0018\u00010#H\u0014J(\u0010o\u001a\u00060\u0006R\u00020\u0003*\u00060\u0006R\u00020\u00032\b\u0010p\u001a\u0004\u0018\u00010q2\b\u0010r\u001a\u0004\u0018\u00010#H\u0004J(\u0010s\u001a\u00060\u0006R\u00020\u0003*\u00060\u0006R\u00020\u00032\b\u0010t\u001a\u0004\u0018\u00010u2\b\u0010r\u001a\u0004\u0018\u00010#H\u0004J/\u0010v\u001a\u000205*\u00020\n2\b\u0010w\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010x\u001a\u00020+2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020#0<H\u0084\bJ\u0018\u0010z\u001a\u00020#*\u00020X2\n\b\u0002\u0010{\u001a\u0004\u0018\u00010#H\u0014J\f\u0010|\u001a\u00020#*\u0004\u0018\u00010uJ)\u0010}\u001a\u000205*\u00020\n2\u0016\u0010}\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010#0~\"\u0004\u0018\u00010#H\u0004\u00a2\u0006\u0002\u0010\u007fR\u0018\u0010\u0005\u001a\u00060\u0006R\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148D@BX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020#*\u00020#8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020#*\u00020#8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u001f\u0010&\u001a\u00020#*\b\u0012\u0004\u0012\u00020#0(8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010)R\u0018\u0010*\u001a\u00020+*\u00020,8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006\u0083\u0001"}, d2={"Lcom/intellij/database/scripting/base/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "(Lcom/intellij/database/scripting/ScriptingContext;)V", "adapter", "Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "getAdapter", "()Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "getCategory", "()Lcom/intellij/database/scripting/ScriptCategory;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "value", "Lcom/intellij/database/scripting/ScriptLocus;", "locus", "getLocus", "()Lcom/intellij/database/scripting/ScriptLocus;", "setLocus", "(Lcom/intellij/database/scripting/ScriptLocus;)V", "scenario", "Lcom/intellij/database/scripting/Scenario;", "getScenario", "()Lcom/intellij/database/scripting/Scenario;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "plain", "", "getPlain", "(Ljava/lang/String;)Ljava/lang/String;", "scr", "getScr", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "useName", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "breakByEdge", "cycle", "", "Lcom/intellij/database/scripting/Operation;", "breakCycle", "breakCycles", "", "cascade", "cascadeConstraints", "clear", "coding", "indent", "block", "Lkotlin/Function0;", "createPreOrderComparator", "Ljava/util/Comparator;", "operations", "", "createRootProducer", "Lcom/intellij/database/scripting/Producer;", "findCycle", "findCycleMin", "", "flush", "statement", "Lcom/intellij/database/scripting/CompositeText;", "forEachEdge", "op1", "op2", "action", "Lkotlin/Function2;", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "", "getEdgeFixers", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator$EdgeFixer;", "getInternalScenario", "ifExists", "isNewCodeGen", "makeOperation", "element", "Lcom/intellij/database/model/basic/BasicElement;", "makeTextSink", "newCoding", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "preferForward", "prepareOutput", "prepareScenario", "processOperations", "processor", "produce", "op", "quote", "e", "name", "resolve", "restrictCascade", "script", "d", "Lcom/intellij/database/model/DataType;", "transform", "useSchemaName", "schemaName", "alterColumn", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "scrName", "alterTable", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "appendOrErr", "text", "eoln", "error", "currentScopeName", "renameScr", "getTableTerm", "words", "", "(Lcom/intellij/database/scripting/CodeTextBuilder;[Ljava/lang/String;)V", "Companion", "EdgeFixer", "PreOrderComparator", "intellij.database.scripting"})
public abstract class AbstractCodeGenerator {
    @NotNull
    private final Scenario scenario;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private static final OperationType ROOT;
    @NotNull
    private static final OperationType TEXT_SINK;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected final ScriptingTask getTask() {
        return this.context.getTask();
    }

    @NotNull
    protected final ScriptCategory getCategory() {
        return this.getTask().getCategory();
    }

    @NotNull
    protected final Scenario getScenario() {
        return this.scenario;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    protected final ScriptLocus getLocus() {
        return this.context.getLocus();
    }

    private final void setLocus(ScriptLocus value) {
        this.context.setLocus(value);
    }

    @NotNull
    protected final ScriptingContext.NewCodingAdapter getAdapter() {
        return this.context.getAdapter();
    }

    @NotNull
    protected Comparator<Operation> createPreOrderComparator(@NotNull Collection<Operation> operations) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        return new PreOrderComparator();
    }

    public abstract void prepareScenario();

    private final Producer createRootProducer() {
        return new SimpleProducer(ROOT, (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }));
    }

    public void clear() {
    }

    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void resolve() {
        Operation it;
        JBIterable operations;
        HashMap effects = new HashMap();
        ObjectPathTrie trie = new ObjectPathTrie();
        JBIterable jBIterable = operations = this.scenario.traverse().bfsTraversal();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"operations");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            Iterable $receiver$iv2 = it.getEffects();
            for (Object element$iv2 : $receiver$iv2) {
                Object object;
                void $receiver$iv3;
                Effect e = (Effect)element$iv2;
                Map map = effects;
                EffectType key$iv = e.getType();
                Object value$iv = $receiver$iv3.get((Object)key$iv);
                if (value$iv == null) {
                    LinkedHashMap answer$iv = new LinkedHashMap();
                    $receiver$iv3.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Map map2 = (Map)object;
                ObjectPath objectPath = e.getTarget();
                Operation operation2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"it");
                Operation prev = map2.put(objectPath, operation2);
                if (prev != null && Intrinsics.areEqual((Object)e.getTarget().kind, (Object)ObjectKind.ARGUMENT) ^ true) {
                    LOG.error("Effect " + e + " provided by " + it + " and " + prev);
                }
                trie.add(e.getTarget());
            }
        }
        $receiver$iv = (Iterable)operations;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            it.unlinkAll();
            JBIterable jBIterable2 = JBIterable.from((Iterable)it.getRequires()).flatten(new Function<E, Iterable<? extends T>>(effects, trie){
                final /* synthetic */ HashMap $effects$inlined;
                final /* synthetic */ ObjectPathTrie $trie$inlined;
                {
                    this.$effects$inlined = hashMap;
                    this.$trie$inlined = objectPathTrie;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Iterable<Operation> fun(RequiredEffect it) {
                    Iterable iterable;
                    Map map = (Map)this.$effects$inlined.get((Object)((Object)it.getType()));
                    if (map != null) {
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Map map2;
                        Map ops = map2 = map;
                        RequiredEffect requiredEffect = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)requiredEffect, (String)"it");
                        Iterable iterable2 = (Iterable)ScenarioOperations.expand(requiredEffect, this.$trie$inlined);
                        Map map3 = ops;
                        void var6_6 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                            Operation operation2;
                            T element$iv$iv = element$iv$iv$iv;
                            ObjectPath p1 = (ObjectPath)element$iv$iv;
                            if ((Operation)map3.get(p1) == null) continue;
                            Operation it$iv$iv = operation2;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        iterable = (List)destination$iv$iv;
                    } else {
                        JBIterable jBIterable = JBIterable.empty();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<Operation?>()");
                        iterable = (Iterable)jBIterable;
                    }
                    return iterable;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.from(it.requi\u2026pty<Operation?>()\n      }");
            it.link((Iterable)jBIterable2);
        }
    }

    public void transform() {
        this.breakCycles();
        this.prepareOutput();
    }

    private final void breakCycles() {
        List<Operation> cycle;
        do {
            if (this.findCycle() != null) continue;
            return;
        } while (this.breakCycle(cycle));
    }

    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkParameterIsNotNull(cycle, (String)"cycle");
        return this.breakByEdge(cycle);
    }

    protected boolean preferForward() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByEdge(List<Operation> cycle) {
        int size;
        int s = this.findCycleMin(cycle);
        int i2 = size = cycle.size();
        Object t = ((Operation)CollectionsKt.first(cycle)).getParent();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Operation root2 = (Operation)t;
        List<EdgeFixer> fixers = this.getEdgeFixers();
        if (fixers.isEmpty()) {
            return false;
        }
        while (i2 >= 0) {
            int p = s + i2 + size;
            Operation cur = cycle.get(p % size);
            Operation next = cycle.get((p + 1) % size);
            boolean fwOnly = i2 == 0;
            boolean bkOnly = i2 == size;
            AbstractCodeGenerator this_$iv = this;
            HashSet targets$iv = (HashSet)ScenarioOperations.traverse(cur).traverse().addAllTo((Collection)new HashSet());
            Iterable $receiver$iv$iv = (Iterable)ScenarioOperations.traverse(next);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Operation so2$iv = (Operation)element$iv$iv;
                Iterable $receiver$iv$iv2 = so2$iv.getPreceders();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    Operation so1$iv = (Operation)element$iv$iv2;
                    if (!targets$iv.contains(so1$iv)) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)so2$iv, (String)"so2");
                    Operation so1 = so1$iv;
                    Iterable $receiver$iv = fixers;
                    for (Object element$iv : $receiver$iv) {
                        void so2;
                        EdgeFixer it = (EdgeFixer)element$iv;
                        if (fwOnly && it.isBackward() || bkOnly && !it.isBackward() || !it.fix(root2, so1, (Operation)so2)) continue;
                        if (it.requiresResolve()) {
                            this.resolve();
                        }
                        return true;
                    }
                }
            }
            --i2;
        }
        return false;
    }

    private final int findCycleMin(List<Operation> cycle) {
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)cycle);
        int mini = 0;
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)cycle.size());
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            if (cmp.compare(cycle.get(mini), cycle.get(it)) <= 0) continue;
            mini = it;
        }
        return mini;
    }

    private final void forEachEdge(Operation op1, Operation op2, Function2<? super Operation, ? super Operation, Unit> action) {
        HashSet targets = (HashSet)ScenarioOperations.traverse(op1).traverse().addAllTo((Collection)new HashSet());
        Iterable $receiver$iv = (Iterable)ScenarioOperations.traverse(op2);
        for (Object element$iv : $receiver$iv) {
            Operation so2 = (Operation)element$iv;
            Iterable $receiver$iv2 = so2.getPreceders();
            for (Object element$iv2 : $receiver$iv2) {
                Operation so1 = (Operation)element$iv2;
                if (!targets.contains(so1)) continue;
                Operation operation2 = so2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"so2");
                action.invoke((Object)so1, (Object)operation2);
            }
        }
    }

    @NotNull
    public List<EdgeFixer> getEdgeFixers() {
        return CollectionsKt.emptyList();
    }

    private final List<Operation> findCycle() {
        HashSet<Operation> visited = new HashSet<Operation>();
        JBTreeTraverser traverser2 = (JBTreeTraverser)ScenarioOperations.traversePreceders().expandAndFilter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal().filter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"scenario.traverse().bfsT\u2026.filter{ it !in visited }");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            Operation root2 = (Operation)element$iv;
            TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser2.withRoot((Object)root2)).biOrderDfsTraversal().typedIterator();
            while (it.advance()) {
                Operation op;
                Operation operation2 = op = (Operation)it.current();
                int n = operation2.getIncidence();
                TreeTraversal.TracingIt tracingIt = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)tracingIt, (String)"it");
                operation2.setIncidence(n + (tracingIt.isDescending() ? 1 : -1));
                if (!it.isDescending()) {
                    visited.add(op);
                }
                if (op.getIncidence() < 2) continue;
                LinkedList<Operation> res = new LinkedList<Operation>();
                boolean add = true;
                JBIterable jBIterable2 = it.backtrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"it.backtrace()");
                Iterable $receiver$iv2 = (Iterable)jBIterable2;
                for (Object element$iv2 : $receiver$iv2) {
                    Operation it2 = (Operation)element$iv2;
                    it2.setIncidence(0);
                    if (add) {
                        boolean bl = add = res.isEmpty() || Intrinsics.areEqual((Object)it2, (Object)op) ^ true;
                    }
                    if (!add) continue;
                    res.add(it2);
                }
                return res;
            }
        }
        return null;
    }

    private final void prepareOutput() {
        Operation sink = this.makeTextSink();
        sink.stealChildrenFrom((Node)this.scenario.getRoot());
        sink.setParent((Node)this.scenario.getRoot());
    }

    public final void processOperations(@NotNull Set<Operation> operations, @NotNull Function1<? super Operation, Unit> processor) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)operations);
        MultiMap<Operation, Operation> successors = this.generateSuccessors(operations);
        TreeSet<Operation> queue = new TreeSet<Operation>(cmp);
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation it = (Operation)element$iv;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!queue.isEmpty()) {
            Operation op = queue.pollFirst();
            Collection rev = successors.remove((Object)op);
            if (rev == null) continue;
            Operation operation2 = op;
            Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"op");
            processor.invoke((Object)operation2);
            Iterable $receiver$iv2 = rev;
            for (Object element$iv : $receiver$iv2) {
                Operation it;
                Operation operation3 = it = (Operation)element$iv;
                operation3.setIncidence(operation3.getIncidence() + -1);
                operation3.getIncidence();
                if (it.getIncidence() != 0) continue;
                queue.add(it);
            }
        }
        if (!successors.isEmpty()) {
            LOG.error("Found cycle", new Attachment[]{new Attachment("script.dot", ScenarioDot.build$default(new ScenarioDot(this.scenario, null, 2, null), null, 1, null).toString())});
        }
    }

    private final MultiMap<Operation, Operation> generateSuccessors(Set<Operation> operations) {
        MultiMap successors = MultiMap.createSet();
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation op = (Operation)element$iv;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors.getModifiable((Object)op);
            int incidence = 0;
            Iterable $receiver$iv2 = flatPreceders;
            for (Object element$iv2 : $receiver$iv2) {
                Operation p = (Operation)element$iv2;
                if (!operations.contains(p)) continue;
                successors.putValue((Object)p, (Object)op);
                ++incidence;
            }
            op.setIncidence(incidence);
        }
        MultiMap multiMap = successors;
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"successors");
        return multiMap;
    }

    public void produce(@NotNull Operation op) {
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        op.getProducer().produce();
    }

    public final void produce() {
        this.produce(this.scenario.getRoot());
    }

    private final Operation makeTextSink() {
        return new Operation(new SimpleProducer(TEXT_SINK, (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        })));
    }

    protected boolean isNewCodeGen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.getLocus();
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = oldContext == ScriptLocus.OUTSIDE ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.setLocus(newContext);
            if (indent) {
                CodeTextBuilder.indent$default(this.builder, null, 1, null);
            }
            block.invoke();
            this.builder.returnToIndentation(savedIndentation);
            this.setLocus(oldContext);
            boolean bl = complete = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.setLocus(oldContext);
            boolean bl = complete2 = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
            if (complete2) {
                this.flush();
            }
            throw throwable;
        }
        if (complete) {
            this.flush();
        }
    }

    public static /* bridge */ /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    protected final void newCoding(@NotNull Function1<? super ScriptingContext.NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, block){
            final /* synthetic */ AbstractCodeGenerator this$0;
            final /* synthetic */ Function1 $block;

            public final void invoke() {
                this.$block.invoke((Object)this.this$0.getAdapter());
                CodeTextBuilder.ensureEoln$default(this.this$0.getBuilder(), null, 1, null);
            }
            {
                this.this$0 = abstractCodeGenerator;
                this.$block = function1;
                super(0);
            }
        }, 3, null);
    }

    public final void flush() {
        if (this.builder.isNotEmpty()) {
            this.flush(new SimpleCompositeText(this.builder));
        }
        this.builder.clearAll();
    }

    private final void flush(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    @Nullable
    public final String quote(@NotNull BasicElement e, @Nullable String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string2 = name;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = this.context.getNaming().nameToScript(it, e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted());
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String quote$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quote");
        }
        if ((n & 2) != 0) {
            string = basicElement.getRealName();
        }
        return abstractCodeGenerator.quote(basicElement, string);
    }

    @NotNull
    public final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getContext().getNaming().nameToScript($receiver, false);
    }

    @NotNull
    public final String getPlain(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getContext().getNaming().nameToScript($receiver, true);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                AbstractCodeGenerator this_$iv = this.this$0;
                return this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }), (int)31, null);
    }

    protected final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    @NotNull
    protected String currentScopeName(@NotNull BasicElement $receiver, @Nullable String renameScr) {
        String string;
        BasicElement q;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string3 = renameScr;
        if (string3 == null) {
            string3 = string2 = AbstractCodeGenerator.quote$default(this, $receiver, null, 2, null);
        }
        if (string3 == null) {
            string2 = "???";
        }
        String name = string2;
        BasicElement basicElement = this.context.getHelper().qualifier($receiver);
        if (basicElement == null) {
            return name;
        }
        BasicElement basicElement2 = q = basicElement;
        if (basicElement2 instanceof BasicSchema) {
            String schemaName = ((BasicSchema)q).getRealName();
            String prefix = schemaName != null && this.useSchemaName(schemaName) ? Intrinsics.stringPlus((String)this.quote(q, schemaName), (Object)".") : "";
            string = prefix + name;
        } else {
            string = AbstractCodeGenerator.currentScopeName$default(this, q, null, 1, null) + "." + name;
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String currentScopeName$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return abstractCodeGenerator.currentScopeName(basicElement, string);
    }

    protected final void words(@NotNull CodeTextBuilder $receiver, String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        CodeTextBuilder.append$default($receiver, ScriptingUtilsKt.phrase(Arrays.copyOf(words, words.length)), null, false, null, 10, null);
    }

    protected final void appendOrErr(@NotNull CodeTextBuilder $receiver, @Nullable String text2, boolean eoln, @NotNull Function0<String> error2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        if (text2 == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text2, null, eoln, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void appendOrErr$default(AbstractCodeGenerator this_, CodeTextBuilder $receiver, String text2, boolean eoln, Function0 error2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendOrErr");
        }
        if ((n & 2) != 0) {
            eoln = true;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)error2, (String)"error");
        if (text2 == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text2, null, eoln, null, 10, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractCodeGenerator$WhenMappings.$EnumSwitchMapping$0[this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)schemaName, (Object)this.context.getCurrentSchemaName()) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    public String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.context.getHelper().script(d, this.context.getOptions());
    }

    @NotNull
    public final Scenario getInternalScenario() {
        return this.scenario;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterTable(@NotNull ScriptingContext.NewCodingAdapter $receiver, @Nullable BasicLikeTable table, @Nullable String scrName) {
        void text$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $receiver;
        BasicLikeTable basicLikeTable = table;
        String string = basicLikeTable != null ? this.currentScopeName(basicLikeTable, scrName) : null;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $receiver.plus($receiver.unaryPlus("alter"), this.getTableTerm(table));
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $receiver;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv, (String)text$iv){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "table is unknown";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterColumn(@NotNull ScriptingContext.NewCodingAdapter $receiver, @Nullable BasicLikeColumn c, @Nullable String scrName) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicLikeColumn basicLikeColumn = c;
        ScriptingContext.NewCodingAdapter newCodingAdapter = $receiver;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $receiver.plus(this.alterTable($receiver, basicLikeColumn != null ? basicLikeColumn.getLikeTable() : null, null), "alter column");
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $receiver;
        void this_$iv$iv = this_$iv;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv$iv, scrName){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    @NotNull
    public final String getTableTerm(@Nullable BasicLikeTable $receiver) {
        return this.context.getHelper().getTableTerm($receiver);
    }

    @Nullable
    protected final String ifExists() {
        return this.context.getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
    }

    @Nullable
    protected final String cascade() {
        return this.context.getOptions().get(ScriptingOptionStatic.DROP_CASCADE) != false ? "cascade" : null;
    }

    @Nullable
    protected final String restrictCascade() {
        return this.cascade();
    }

    @Nullable
    protected final String cascadeConstraints() {
        String string;
        String string2 = this.cascade();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = "cascade constraints";
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final ScriptingContext getContext() {
        return this.context;
    }

    public AbstractCodeGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.scenario = new Scenario(this.createRootProducer());
        this.builder = this.context.getBuilder();
    }

    static {
        Companion = new Companion(null);
        ROOT = new OperationType("root");
        TEXT_SINK = new OperationType("text sink");
        LOG = Logger.getInstance(AbstractCodeGenerator.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/base/AbstractCodeGenerator$PreOrderComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/scripting/Operation;", "()V", "cache", "", "", "getCache", "()Ljava/util/Map;", "compare", "", "o1", "o2", "getPreliminaryOrder", "op", "intellij.database.scripting"})
    protected static class PreOrderComparator
    implements Comparator<Operation> {
        @NotNull
        private final Map<Operation, String> cache;

        @NotNull
        public final Map<Operation, String> getCache() {
            return this.cache;
        }

        @Override
        public int compare(@Nullable Operation o1, @Nullable Operation o2) {
            String string;
            Map<Operation, String> map = this.cache;
            Comparable comparable = (Comparable)((Object)map.get(o1));
            int res = Comparing.compare((Comparable)comparable, (Comparable)((Comparable)((Object)(string = (map = this.cache).get(o2)))));
            if (res != 0) {
                return res;
            }
            return Comparing.compare((int)Comparing.hashcode((Object)o1), (int)Comparing.hashcode((Object)o2));
        }

        @NotNull
        public String getPreliminaryOrder(@NotNull Operation op) {
            Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
            return op.getProducer().getPreliminaryOrder();
        }

        public PreOrderComparator() {
            Map map = FactoryMap.create((Function)new Function<K, V>(this){
                final /* synthetic */ PreOrderComparator this$0;

                @NotNull
                public final String fun(Operation it) {
                    Operation operation2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"it");
                    return this.this$0.getPreliminaryOrder(operation2);
                }
                {
                    this.this$0 = preOrderComparator;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"FactoryMap.create<Operat\u2026getPreliminaryOrder(it) }");
            this.cache = map;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/base/AbstractCodeGenerator$EdgeFixer;", "", "()V", "fix", "", "root", "Lcom/intellij/database/scripting/Operation;", "op1", "op2", "isBackward", "requiresResolve", "intellij.database.scripting"})
    public static abstract class EdgeFixer {
        public abstract boolean fix(@NotNull Operation var1, @NotNull Operation var2, @NotNull Operation var3);

        public boolean isBackward() {
            return false;
        }

        public boolean requiresResolve() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/base/AbstractCodeGenerator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ROOT", "Lcom/intellij/database/scripting/OperationType;", "getROOT", "()Lcom/intellij/database/scripting/OperationType;", "TEXT_SINK", "getTEXT_SINK", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        protected final OperationType getROOT() {
            return ROOT;
        }

        @NotNull
        protected final OperationType getTEXT_SINK() {
            return TEXT_SINK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

