/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingInternalTask;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import com.intellij.database.scripting.base.AbstractCodeGenerator;
import com.intellij.database.scripting.base.AbstractScriptingService;
import com.intellij.database.scripting.base.AbstractScriptingService$WhenMappings;
import com.intellij.database.scripting.base.AbstractTransitionCodeGenerator;
import com.intellij.database.scripting.base.BaseAlterGenerator;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.BaseDropGenerator;
import com.intellij.database.scripting.base.BaseEnableDisableGenerator;
import com.intellij.database.scripting.base.BaseNativeDefinitionsGenerator;
import com.intellij.database.scripting.base.BaseRefreshMatViewGenerator;
import com.intellij.database.scripting.base.OrSupportedImpl;
import com.intellij.database.scripting.base.ScriptingCapabilitiesImpl;
import com.intellij.database.scripting.base.ScriptingHelper;
import com.intellij.database.scripting.base.SupportedSinceImpl;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.base.producers.DropProducer;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0003>?@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0015\u0010-\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u00100\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0019\u00101\u001a\u000602R\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b3J\u0018\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0016H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006A"}, d2={"Lcom/intellij/database/scripting/base/AbstractScriptingService;", "Lcom/intellij/database/scripting/ScriptingService;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "(Lorg/jetbrains/dekaf/Rdbms;)V", "caps", "Lcom/intellij/database/scripting/base/AbstractScriptingService$CapabilitiesCollector;", "createVersion", "Lcom/intellij/database/model/PerObjectVersion;", "getCreateVersion", "()Lcom/intellij/database/model/PerObjectVersion;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "scriptingHelper", "Lcom/intellij/database/scripting/base/ScriptingHelper;", "getScriptingHelper", "()Lcom/intellij/database/scripting/base/ScriptingHelper;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "capabilities", "Lcom/intellij/database/scripting/ScriptingCapabilities;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createAlterGenerator", "Lcom/intellij/database/scripting/base/BaseAlterGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "createCapsKey", "", "createContext", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createCreatingGenerator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "createDropGenerator", "Lcom/intellij/database/scripting/base/BaseDropGenerator;", "createEnableDisableGenerator", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator;", "createExecuteGenerator", "createGenerator", "createGenerator$intellij_database_scripting", "createNativeDefinitionsGenerator", "createRefreshingGenerator", "createResult", "Lcom/intellij/database/scripting/base/AbstractScriptingService$ScriptingResultImpl;", "createResult$intellij_database_scripting", "isEqual", "e1", "e2", "makeScript", "Lcom/intellij/database/scripting/ScriptingResult;", "reviseSource", "Lcom/intellij/database/scripting/CompositeText;", "e", "Lcom/intellij/database/model/basic/BasicSourceAware;", "toString", "CapabilitiesCollector", "ScriptingResultImpl", "StupidGenerator", "intellij.database.scripting"})
public abstract class AbstractScriptingService
implements ScriptingService {
    private final CapabilitiesCollector caps;
    @NotNull
    private final PerObjectVersion createVersion;
    @NotNull
    private final Rdbms rdbms;

    @NotNull
    protected final PerObjectVersion getCreateVersion() {
        return this.createVersion;
    }

    @NotNull
    public abstract ScriptingHelper getScriptingHelper();

    @Override
    @NotNull
    public ScriptingResult makeScript(@NotNull ScriptingTask task) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        boolean bl2 = bl = Intrinsics.areEqual((Object)this.rdbms, (Object)UnknownDatabase.RDBMS) || Intrinsics.areEqual((Object)ScriptingTaskKt.getRdbms(task), (Object)this.rdbms);
        if (_Assertions.ENABLED && !bl) {
            String string = "wrong model";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ScriptingContext context = this.createContext(task);
        AbstractCodeGenerator generator = this.createGenerator$intellij_database_scripting(context);
        if (!(generator instanceof AbstractTransitionCodeGenerator)) {
            generator.prepareScenario();
            generator.resolve();
            generator.transform();
            generator.produce();
        } else {
            ((AbstractTransitionCodeGenerator)generator).generate();
        }
        generator.flush();
        return this.createResult$intellij_database_scripting(context);
    }

    @NotNull
    public final ScriptingResultImpl createResult$intellij_database_scripting(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new ScriptingResultImpl(context.getScript());
    }

    @NotNull
    public final ScriptingContext createContext(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new ScriptingContext(task, this.getScriptingHelper());
    }

    @NotNull
    public AbstractCodeGenerator createGenerator$intellij_database_scripting(@NotNull ScriptingContext context) {
        AbstractCodeGenerator abstractCodeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$0[context.getTask().getCategory().ordinal()]) {
            case 1: 
            case 2: {
                abstractCodeGenerator = this.createCreatingGenerator(context);
                break;
            }
            case 3: {
                abstractCodeGenerator = this.createNativeDefinitionsGenerator(context);
                break;
            }
            case 4: 
            case 5: {
                abstractCodeGenerator = this.createEnableDisableGenerator(context);
                break;
            }
            case 6: {
                abstractCodeGenerator = this.createRefreshingGenerator(context);
                break;
            }
            case 7: {
                abstractCodeGenerator = this.createExecuteGenerator(context);
                break;
            }
            case 8: {
                abstractCodeGenerator = this.createAlterGenerator(context);
                break;
            }
            case 9: {
                abstractCodeGenerator = this.createDropGenerator(context);
                break;
            }
            default: {
                abstractCodeGenerator = new StupidGenerator(context);
            }
        }
        return abstractCodeGenerator;
    }

    @NotNull
    protected BaseCreatingGenerator createCreatingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseCreatingGenerator(context);
    }

    @NotNull
    protected AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseNativeDefinitionsGenerator(context);
    }

    @NotNull
    protected AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseEnableDisableGenerator(context);
    }

    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseRefreshMatViewGenerator(context);
    }

    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new StupidGenerator(context);
    }

    @NotNull
    protected BaseDropGenerator createDropGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseDropGenerator(context);
    }

    @NotNull
    protected BaseAlterGenerator createAlterGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BaseAlterGenerator(context, this.createCreatingGenerator(context), this.createDropGenerator(context));
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    @NotNull
    public String toString() {
        return "ScriptingService for " + this.rdbms + '.';
    }

    @Override
    @NotNull
    public ScriptingCapabilities capabilities(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.caps.get(element);
    }

    @Override
    public boolean isEqual(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        return this.getScriptingHelper().createAlterProducer(this.caps.getContext$intellij_database_scripting(), new ElementAlteration<BasicElement>(e1, e2)).isEmpty();
    }

    @Override
    @Nullable
    public CompositeText reviseSource(@NotNull BasicSourceAware e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return this.getScriptingHelper().createProducer(this.caps.getContext$intellij_database_scripting(), e).revisedSource();
    }

    @NotNull
    protected Object createCapsKey(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element.getParent();
        return new Pair(basicElement != null ? basicElement.getClass() : null, element.getClass());
    }

    @NotNull
    public final Rdbms getRdbms() {
        return this.rdbms;
    }

    public AbstractScriptingService(@NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        this.rdbms = rdbms;
        this.caps = new CapabilitiesCollector();
        this.createVersion = new PerObjectVersion();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/base/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/base/AbstractTransitionCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "(Lcom/intellij/database/scripting/base/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingContext;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "prepareScenario", "intellij.database.scripting"})
    protected final class StupidGenerator
    extends AbstractTransitionCodeGenerator {
        @Override
        public void prepareScenario() {
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, null, 14, null);
                }
                {
                    this.this$0 = stupidGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        public StupidGenerator(ScriptingContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getCategory().name() + " :(", null, false, null, 14, null);
                }
            }, 3, null);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/base/AbstractScriptingService$ScriptingResultImpl;", "Lcom/intellij/database/scripting/ScriptingResult;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "(Lcom/intellij/database/scripting/base/AbstractScriptingService;Ljava/util/List;)V", "getScript", "getScriptStatements", "", "", "()[Ljava/lang/String;", "getScriptText", "isComment", "", "text", "intellij.database.scripting"})
    public final class ScriptingResultImpl
    implements ScriptingResult {
        private final List<CompositeText> script;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String[] getScriptStatements() {
            void var2_2;
            int size$iv = this.script.size();
            String[] result$iv = new String[size$iv];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void i2;
                String string;
                void i$iv;
                void var5_5 = i$iv;
                void var9_7 = i$iv++;
                String[] stringArray = result$iv;
                stringArray[var9_7] = string = ((Object)this.script.get((int)i2).getText()).toString();
            }
            return var2_2;
        }

        @Override
        @NotNull
        public String getScriptText() {
            return ((Object)this.getScript().getText()).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public CompositeText getScript() {
            void $receiver$iv;
            int initial$iv;
            Iterable iterable = this.script;
            int accumulator$iv = initial$iv = 0;
            for (Object element$iv : $receiver$iv) {
                void t;
                CompositeText compositeText = (CompositeText)element$iv;
                int x = accumulator$iv;
                accumulator$iv = x + t.getText().length();
            }
            int capacity = accumulator$iv + 8 * this.script.size();
            CodeTextBuilder b = new CodeTextBuilder(capacity);
            for (CompositeText stmt : this.script) {
                boolean separate;
                for (CompositeText.Fragment f : stmt.getFragments()) {
                    b.append(f);
                }
                boolean bl = separate = !this.isComment(stmt) && !b.endsWithIgnoreSpace(AbstractScriptingService.this.getStatementDelimiterStr());
                if (separate) {
                    if (AbstractScriptingService.this.getStatementDelimiterOwnsLine()) {
                        b.ensureEoln(CompositeText.Kind.SQL_DELIMITER);
                    }
                    CodeTextBuilder.append$default(b, AbstractScriptingService.this.getStatementDelimiterStr(), CompositeText.Kind.SQL_DELIMITER, false, null, 12, null);
                }
                b.ensureBlankLine(CompositeText.Kind.SQL_DELIMITER);
            }
            return b;
        }

        private final boolean isComment(CompositeText text2) {
            boolean bl;
            block3: {
                Iterable<CompositeText.Fragment> $receiver$iv = text2.getFragments();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (CompositeText.Fragment element$iv : $receiver$iv) {
                        CompositeText.Fragment it = element$iv;
                        if (!(it.getKind() != CompositeText.Kind.COMMENT && !StringsKt.isBlank((CharSequence)it.getText()))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public ScriptingResultImpl(List<? extends CompositeText> script) {
            Intrinsics.checkParameterIsNotNull(script, (String)"script");
            this.script = script;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\"\u0006\u0012\u0002\b\u00030\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u001e\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000f\"\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u0018R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/base/AbstractScriptingService$CapabilitiesCollector;", "", "(Lcom/intellij/database/scripting/base/AbstractScriptingService;)V", "caps", "Ljava/util/HashMap;", "Lcom/intellij/database/scripting/ScriptingCapabilities;", "Lkotlin/collections/HashMap;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "getContext$intellij_database_scripting", "()Lcom/intellij/database/scripting/ScriptingContext;", "extractVersions", "", "Lorg/jetbrains/dekaf/util/Version;", "vs", "", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "([Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;)Ljava/lang/Iterable;", "get", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getCaps", "Lcom/intellij/database/scripting/base/ScriptingCapabilitiesImpl;", "merge", "([Ljava/lang/Iterable;)Ljava/lang/Iterable;", "intellij.database.scripting"})
    private final class CapabilitiesCollector {
        private final HashMap<Object, ScriptingCapabilities> caps = new HashMap();
        @NotNull
        private final ScriptingContext context;

        @NotNull
        public final ScriptingContext getContext$intellij_database_scripting() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ScriptingCapabilities get(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Object key2 = AbstractScriptingService.this.createCapsKey(element);
            ScriptingCapabilities scriptingCapabilities = this.caps.get(key2);
            if (scriptingCapabilities != null) {
                ScriptingCapabilities scriptingCapabilities2;
                ScriptingCapabilities it;
                ScriptingCapabilities scriptingCapabilities3 = it = (scriptingCapabilities2 = scriptingCapabilities);
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptingCapabilities3, (String)"it");
                return scriptingCapabilities3;
            }
            ScriptingCapabilitiesImpl cap = this.getCaps(element);
            HashMap<Object, ScriptingCapabilities> hashMap = this.caps;
            synchronized (hashMap) {
                Map map = this.caps;
                Object object = key2;
                ScriptingCapabilitiesImpl scriptingCapabilitiesImpl = cap;
                map.put(object, scriptingCapabilitiesImpl);
                object = Unit.INSTANCE;
            }
            return cap;
        }

        private final ScriptingCapabilitiesImpl getCaps(BasicElement element) {
            CreateProducer<?> c = AbstractScriptingService.this.getScriptingHelper().createProducer(this.context, element);
            DropProducer<?> d = AbstractScriptingService.this.getScriptingHelper().createDropProducer(this.context, element);
            AlterProducer<?> a = AbstractScriptingService.this.getScriptingHelper().createAlterProducer(this.context, new ElementAlteration<BasicElement>(element, element));
            ScriptingCapabilities.VersionedCapability<Boolean> create = c.canCreate();
            ScriptingCapabilities.VersionedCapability<Boolean> drop = d.canDrop();
            ScriptingCapabilities.VersionedCapability<Boolean> rename2 = a.canRename();
            ScriptingCapabilities.VersionedCapability<Boolean> comment = c.canComment();
            ScriptingCapabilities.VersionedCapability<Boolean> alterComment = a.canAlterComment();
            ScriptingCapabilities.VersionedCapability<Boolean> alterAnything = a.canAlterAnything();
            return new ScriptingCapabilitiesImpl(create, c.createVersion(), drop, rename2, comment, alterComment, alterAnything, this.merge(c.edgeVersions(), d.edgeVersions(), a.edgeVersions(), this.extractVersions(create, drop, rename2, comment, alterComment)));
        }

        private final Iterable<Version> extractVersions(ScriptingCapabilities.VersionedCapability<?> ... vs) {
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(vs, vs.length)).flatMap(new Function<E, Iterable<? extends T>>(this){
                final /* synthetic */ CapabilitiesCollector this$0;

                @NotNull
                public final JBIterable<Version> fun(ScriptingCapabilities.VersionedCapability<?> it) {
                    ScriptingCapabilities.VersionedCapability<?> versionedCapability = it;
                    return versionedCapability instanceof SupportedSinceImpl ? JBIterable.of((Object)((SupportedSinceImpl)it).getSince()) : (versionedCapability instanceof OrSupportedImpl ? JBIterable.from((Iterable)((OrSupportedImpl)it).getTerms()).flatMap((Function)new Function<E, Iterable<? extends T>>(this){
                        final /* synthetic */ extractVersions.1 this$0;

                        @NotNull
                        public final Iterable<Version> fun(ScriptingCapabilities.VersionedCapability<Boolean> it) {
                            CapabilitiesCollector capabilitiesCollector = this.this$0.this$0;
                            ScriptingCapabilities.VersionedCapability[] versionedCapabilityArray = new ScriptingCapabilities.VersionedCapability[1];
                            ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability = it;
                            Intrinsics.checkExpressionValueIsNotNull(versionedCapability, (String)"it");
                            versionedCapabilityArray[0] = versionedCapability;
                            return CapabilitiesCollector.access$extractVersions(capabilitiesCollector, versionedCapabilityArray);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }) : JBIterable.empty());
                }
                {
                    this.this$0 = capabilitiesCollector;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.of(*vs).flatM\u2026terable.empty()\n      } }");
            return (Iterable)jBIterable;
        }

        private final Iterable<Version> merge(Iterable<Version> ... vs) {
            TreeSet res = new TreeSet();
            Iterable<Version>[] $receiver$iv = vs;
            int n = $receiver$iv.length;
            for (int j = 0; j < n; ++j) {
                Iterable<Version> element$iv;
                Iterable<Version> it = element$iv = $receiver$iv[j];
                CollectionsKt.toCollection(it, (Collection)res);
            }
            return CollectionsKt.toList((Iterable)res);
        }

        public CapabilitiesCollector() {
            ScriptingInternalTask task = new ScriptingInternalTask(AbstractScriptingService.this.getRdbms(), ScriptCategory.CREATE_COMPLETE, null, 4, null);
            this.context = AbstractScriptingService.this.createContext(task);
        }

        @NotNull
        public static final /* synthetic */ Iterable access$extractVersions(CapabilitiesCollector $this, ScriptingCapabilities.VersionedCapability ... vs) {
            return $this.extractVersions(vs);
        }
    }
}

