/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.delta.ElementCreation;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.model.delta.ElementRemotion;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.base.AbstractCodeGenerator;
import com.intellij.database.scripting.base.BaseAlterGenerator;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.BaseDropGenerator;
import com.intellij.database.scripting.base.producers.AlterProducer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\n\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0013J\u0018\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0013J\u001e\u0010%\u001a\u0004\u0018\u00010\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010!\u001a\u00020\u0013H\u0002J(\u0010'\u001a\u0004\u0018\u00010\u00132\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010!\u001a\u00020\u00132\b\b\u0002\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0018H\u0016J#\u0010+\u001a\u0004\u0018\u0001H,\"\b\b\u0000\u0010,*\u00020\u0012*\b\u0012\u0004\u0012\u0002H,0\u001bH\u0002\u00a2\u0006\u0002\u0010-R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lcom/intellij/database/scripting/base/BaseAlterGenerator;", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "creator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "dropper", "Lcom/intellij/database/scripting/base/BaseDropGenerator;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/base/BaseCreatingGenerator;Lcom/intellij/database/scripting/base/BaseDropGenerator;)V", "CYCLIC_RENAME_FIXER", "com/intellij/database/scripting/base/BaseAlterGenerator$CYCLIC_RENAME_FIXER$1", "Lcom/intellij/database/scripting/base/BaseAlterGenerator$CYCLIC_RENAME_FIXER$1;", "getCreator", "()Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "getDropper", "()Lcom/intellij/database/scripting/base/BaseDropGenerator;", "prepared", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "Lkotlin/collections/HashMap;", "getPrepared", "()Ljava/util/HashMap;", "clear", "", "correspondence", "", "Lcom/intellij/database/model/delta/ElementDelta;", "getEdgeFixers", "", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator$EdgeFixer;", "makeAlterOperation", "delta", "root", "makeCreateOperation", "element", "makeDropOperation", "prepareAlter", "Lcom/intellij/database/model/delta/ElementAlteration;", "prepareElement", "forceRoot", "", "prepareScenario", "anyElement", "T", "(Lcom/intellij/database/model/delta/ElementDelta;)Lcom/intellij/database/model/basic/BasicElement;", "Companion", "intellij.database.scripting"})
public class BaseAlterGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final HashMap<BasicElement, Operation> prepared;
    private final CYCLIC_RENAME_FIXER.1 CYCLIC_RENAME_FIXER;
    @NotNull
    private final BaseCreatingGenerator creator;
    @NotNull
    private final BaseDropGenerator dropper;
    @NotNull
    private static final OperationType ALTER;
    public static final Companion Companion;

    @NotNull
    public final HashMap<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    public void clear() {
        this.prepared.clear();
    }

    private final Collection<ElementDelta<?>> correspondence() {
        Object object;
        ScriptingTask scriptingTask = this.getTask();
        if (!(scriptingTask instanceof ScriptingAlterTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingAlterTask)scriptingTask) == null || (object = ((ScriptingAlterTask)object).getCorrespondence()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public void prepareScenario() {
        Iterable $receiver$iv = this.correspondence();
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(this){
            final /* synthetic */ BaseAlterGenerator this$0;
            {
                this.this$0 = baseAlterGenerator;
            }

            public final int compare(T a, T b) {
                ElementDelta it = (ElementDelta)a;
                Comparable comparable = Integer.valueOf(ScenarioOperations.depth(BaseAlterGenerator.access$anyElement(this.this$0, it)));
                it = (ElementDelta)b;
                Comparable comparable2 = comparable;
                Integer n = ScenarioOperations.depth(BaseAlterGenerator.access$anyElement(this.this$0, it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List downwards = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        $receiver$iv = downwards;
        for (Object element$iv : $receiver$iv) {
            ElementDelta it = (ElementDelta)element$iv;
            BaseAlterGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
        this.dropper.fillDependencies();
    }

    private final <T extends BasicElement> T anyElement(@NotNull ElementDelta<? extends T> $receiver) {
        T t = $receiver.getSourceElement();
        if (t == null) {
            t = $receiver.getTargetElement();
        }
        return t;
    }

    @Nullable
    public Operation prepareElement(@NotNull ElementDelta<?> element, @NotNull Operation root2, boolean forceRoot) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        return this.makeAlterOperation(element, root2);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Operation prepareElement$default(BaseAlterGenerator baseAlterGenerator, ElementDelta elementDelta, Operation operation2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseAlterGenerator.prepareElement(elementDelta, operation2, bl);
    }

    @Nullable
    public Operation makeAlterOperation(@NotNull ElementDelta<?> delta, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull(delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (delta instanceof ElementCreation) {
            return this.makeCreateOperation((BasicElement)((ElementCreation)delta).getTargetElement(), root2);
        }
        if (delta instanceof ElementRemotion) {
            return this.makeDropOperation((BasicElement)((ElementRemotion)delta).getSourceElement(), root2);
        }
        if (delta instanceof ElementAlteration) {
            return this.prepareAlter((ElementAlteration)delta, root2);
        }
        return null;
    }

    private final Operation prepareAlter(ElementAlteration<?> delta, Operation root2) {
        Operation operation2 = this.prepared.get(delta.getSourceElement());
        if (operation2 == null) {
            operation2 = this.getContext().getHelper().createAlterProducer(this.getContext(), delta).register(this, root2);
        }
        return operation2;
    }

    @Nullable
    public final Operation makeDropOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        return BaseDropGenerator.prepareElement$default(this.dropper, element, root2, false, 4, null);
    }

    @Nullable
    public final Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Operation operation2;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Operation operation3 = BaseCreatingGenerator.prepareElement$default(this.creator, element, root2, false, 4, null);
        if (operation3 != null) {
            Operation operation4;
            Operation $receiver = operation4 = operation3;
            ScenarioOperations.requires($receiver, ScenarioOperations.parents(EffectType.Modified, element));
            operation2 = operation4;
        } else {
            operation2 = null;
        }
        return operation2;
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.dropper.getEdgeFixers(), (Iterable)this.creator.getEdgeFixers()), (Object)this.CYCLIC_RENAME_FIXER);
    }

    @NotNull
    public final BaseCreatingGenerator getCreator() {
        return this.creator;
    }

    @NotNull
    protected final BaseDropGenerator getDropper() {
        return this.dropper;
    }

    public BaseAlterGenerator(@NotNull ScriptingContext context, @NotNull BaseCreatingGenerator creator, @NotNull BaseDropGenerator dropper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        Intrinsics.checkParameterIsNotNull((Object)dropper, (String)"dropper");
        super(context);
        this.creator = creator;
        this.dropper = dropper;
        this.prepared = new HashMap();
        this.CYCLIC_RENAME_FIXER = new AbstractCodeGenerator.EdgeFixer(this, context){
            final /* synthetic */ BaseAlterGenerator this$0;
            final /* synthetic */ ScriptingContext $context;

            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                block6: {
                    AlterProducer<?> alterProducer;
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                    Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                    Producer producer = op1.getProducer();
                    if (!(producer instanceof AlterProducer)) {
                        producer = null;
                    }
                    AlterProducer<?> alterProducer2 = (AlterProducer<?>)producer;
                    if (alterProducer2 == null) {
                        return false;
                    }
                    AlterProducer<?> r1 = alterProducer2;
                    Producer producer2 = op2.getProducer();
                    if (!(producer2 instanceof AlterProducer)) {
                        producer2 = null;
                    }
                    AlterProducer alterProducer3 = (AlterProducer)producer2;
                    if (alterProducer3 == null) {
                        return false;
                    }
                    AlterProducer r2 = alterProducer3;
                    if (!r1.isRename().getV() || r1.getTmpName() != null || !r2.isRename().getV()) {
                        return false;
                    }
                    String tmp = r1.getElement().getName() + "_dg_tmp";
                    T t = op1.getParent();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    Operation p = (Operation)t;
                    op1.setParent(null);
                    AlterProducer<?> $receiver = alterProducer = r1;
                    $receiver.setTmpName((Pair<String, Boolean>)new Pair((Object)tmp, (Object)false));
                    $receiver.register(this.this$0, p);
                    $receiver = alterProducer = this.$context.getHelper().createAlterProducer(this.$context, new ElementAlteration<T>(r1.getTo(), r1.getTo()));
                    $receiver.setTmpName((Pair<String, Boolean>)new Pair((Object)tmp, (Object)true));
                    Operation operation2 = $receiver.register(this.this$0, p);
                    if (operation2 == null) break block6;
                    ScenarioOperations.requires(operation2, ScenarioOperations.matches$default(EffectType.RenamedTo, ScenarioOperations.renamed(r1.getElement(), null, tmp), null, 2, null));
                }
                return true;
            }

            public boolean isBackward() {
                return true;
            }

            public boolean requiresResolve() {
                return true;
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    static {
        Companion = new Companion(null);
        ALTER = new OperationType("alter");
    }

    @Nullable
    public static final /* synthetic */ BasicElement access$anyElement(BaseAlterGenerator $this, @NotNull ElementDelta $receiver) {
        return $this.anyElement($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/scripting/base/BaseAlterGenerator$Companion;", "", "()V", "ALTER", "Lcom/intellij/database/scripting/OperationType;", "getALTER", "()Lcom/intellij/database/scripting/OperationType;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getALTER() {
            return ALTER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

