/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.base.AbstractCodeGenerator;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.BaseCreatingGenerator$WhenMappings;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0004J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0014J\u001a\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J$\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010)\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020\u0018H\u0016J\b\u0010+\u001a\u00020\u0006H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "(Lcom/intellij/database/scripting/ScriptingContext;)V", "isExact", "", "()Z", "prepared", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "()Ljava/util/HashMap;", "canCreateInColumn", "element", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "clear", "", "elements", "", "getEdgeFixers", "", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator$EdgeFixer;", "getSingleColumnElements", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "isIndexExplicitFor", "key", "Lcom/intellij/database/model/basic/BasicKey;", "makeCreateOperation", "root", "makeOperation", "prepareElement", "forceRoot", "prepareScenario", "shouldCollectColumnElements", "Companion", "intellij.database.scripting"})
public class BaseCreatingGenerator
extends AbstractCodeGenerator {
    private final boolean isExact;
    @NotNull
    private final HashMap<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType CREATE;
    private static final Companion.CREATE_FK_FIXER.1 CREATE_FK_FIXER;
    @NotNull
    private static final List<AbstractCodeGenerator.EdgeFixer> CREATE_FIXERS;
    public static final Companion Companion;

    protected final boolean isExact() {
        return this.isExact;
    }

    @NotNull
    public final HashMap<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @NotNull
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.makeCreateOperation(element, this.getScenario().getRoot());
    }

    @Override
    public void clear() {
        this.prepared.clear();
    }

    @Override
    public void prepareScenario() {
        Iterable $receiver$iv = this.elements();
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                BasicElement it = (BasicElement)a;
                Comparable comparable = Integer.valueOf(ScenarioOperations.depth(it));
                it = (BasicElement)b;
                Comparable comparable2 = comparable;
                Integer n = ScenarioOperations.depth(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List downwards = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        $receiver$iv = downwards;
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            if (it instanceof BasicTable && ((BasicTable)it).isSystem() || it.isAutoCreated()) continue;
            BaseCreatingGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
    }

    private final Collection<BasicElement> elements() {
        Object object;
        ScriptingTask scriptingTask = this.getTask();
        if (!(scriptingTask instanceof ScriptingSingleModelTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingSingleModelTask)scriptingTask) == null || (object = ((ScriptingSingleModelTask)object).getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
        Operation operation2;
        block5: {
            block4: {
                Operation operation3;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                operation2 = this.prepared.get(element);
                if (operation2 == null) break block4;
                Operation $receiver = operation3 = operation2;
                if (forceRoot) {
                    $receiver.setParent((Node)root2);
                }
                if ((operation2 = operation3) != null) break block5;
            }
            operation2 = this.makeCreateOperation(element, root2);
        }
        return operation2;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Operation prepareElement$default(BaseCreatingGenerator baseCreatingGenerator, BasicElement basicElement, Operation operation2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseCreatingGenerator.prepareElement(basicElement, operation2, bl);
    }

    private final Operation makeCreateOperation(BasicElement element, Operation root2) {
        return this.getContext().getHelper().createProducer(this.getContext(), element).register(this, root2);
    }

    public boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1: {
                if (!(element instanceof BasicConstraint) || this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (element instanceof BasicTableOrViewColumn || element instanceof BasicConstraint && this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (element instanceof BasicConstraint && this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    protected final boolean canCreateInColumn(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.canGenerateHere(ScriptLocus.IN_COLUMN, element);
    }

    @NotNull
    public Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column2) {
        BasicLikeTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicLikeTable basicLikeTable = column2.getLikeTable();
        if (basicLikeTable == null) {
            return SetsKt.emptySet();
        }
        BasicLikeTable basicLikeTable2 = table = basicLikeTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"table");
        JBIterable jBIterable = basicLikeTable2.getChildren().filter(BasicConstraint.class).filter((Condition)new Condition<BasicConstraint>(this, column2){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicLikeColumn $column;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(BasicConstraint it) {
                BasicConstraint basicConstraint = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                if (!this.this$0.canCreateInColumn(basicConstraint)) return false;
                if (it.getColNames().size() != 1) return false;
                List<String> list = it.getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.colNames");
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first(list)), (Object)this.$column.getName())) return false;
                return true;
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$column = basicLikeColumn;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n      .fi\u2026.first() == column.name }");
        return (Iterable)jBIterable;
    }

    protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        return this.getLocus() == ScriptLocus.IN_STATEMENT || this.getLocus() == ScriptLocus.OUTSIDE;
    }

    protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof BasicMinorObject && this.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
            return ((BasicMinorObject)element).getMajorObject() == null;
        }
        return true;
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return CREATE_FIXERS;
    }

    protected boolean shouldCollectColumnElements() {
        return this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN && this.getLocus() == ScriptLocus.IN_TABLE;
    }

    public boolean isIndexExplicitFor(@Nullable BasicIndex index2, @NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return index2 != null && this.getUseName(index2) && Intrinsics.areEqual((Object)index2.getName(), (Object)key2.getName()) ^ true;
    }

    public BaseCreatingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.isExact = this.getCategory() == ScriptCategory.CREATE_DEFINITION;
        this.prepared = new HashMap();
    }

    static {
        Companion = new Companion(null);
        CREATE = new OperationType("create");
        CREATE_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                BasicForeignKey basicForeignKey;
                void $receiver$iv;
                BasicLikeTable basicLikeTable;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op2.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation2 = op1;
                Object t$iv = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
                    if (!(basicElement instanceof BasicLikeTable)) {
                        basicElement = null;
                    }
                    basicLikeTable = (BasicLikeTable)basicElement;
                } else {
                    basicLikeTable = null;
                }
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op2;
                OperationType t$iv2 = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
                    if (!(basicElement instanceof BasicForeignKey)) {
                        basicElement = null;
                    }
                    basicForeignKey = (BasicForeignKey)basicElement;
                } else {
                    basicForeignKey = null;
                }
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                op2.setParent((Node)root2);
                return true;
            }
        };
        CREATE_FIXERS = CollectionsKt.listOf((Object)CREATE_FK_FIXER);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/base/BaseCreatingGenerator$Companion;", "", "()V", "CREATE", "Lcom/intellij/database/scripting/OperationType;", "getCREATE", "()Lcom/intellij/database/scripting/OperationType;", "CREATE_FIXERS", "", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator$EdgeFixer;", "getCREATE_FIXERS$intellij_database_scripting", "()Ljava/util/List;", "CREATE_FK_FIXER", "com/intellij/database/scripting/base/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getCREATE() {
            return CREATE;
        }

        @NotNull
        public final List<AbstractCodeGenerator.EdgeFixer> getCREATE_FIXERS$intellij_database_scripting() {
            return CREATE_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

