/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.scripting.base.ElementProducer$WhenMappings;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.vfs.ObjectPath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B@\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012!\b\u0002\u0010\t\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ(\u00100\u001a\b\u0012\u0004\u0012\u0002H10\u0000\"\n\b\u0001\u00101\u0018\u0001*\u00020\u00022\u0006\u00102\u001a\u0002H1H\u0086\b\u00a2\u0006\u0002\u00103J*\u00104\u001a\u00020\u000b2\n\b\u0002\u00105\u001a\u0004\u0018\u0001062\b\b\u0002\u00107\u001a\u00020,2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b09J\u0010\u0010:\u001a\u00020$2\b\u0010;\u001a\u0004\u0018\u00010$J\u0006\u0010<\u001a\u00020\u000bJ\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020$H\u0016J#\u0010@\u001a\u00020\u000b2\u001b\u00108\u001a\u0017\u0012\b\u0012\u00060AR\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fJ\b\u0010B\u001a\u00020\u000bH\u0016J\u001c\u0010C\u001a\u0004\u0018\u00010$2\u0006\u00102\u001a\u00020\u00022\n\b\u0002\u0010D\u001a\u0004\u0018\u00010$J\u0010\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020$H\u0016J'\u0010I\u001a\u00060AR\u00020\u00052\u001b\u00108\u001a\u0017\u0012\b\u0012\u00060AR\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fJ\b\u0010J\u001a\u00020$H\u0016J\u0012\u0010K\u001a\u00020,2\b\u0010L\u001a\u0004\u0018\u00010$H\u0014J(\u0010M\u001a\u00060AR\u00020\u0005*\u00060AR\u00020\u00052\b\u0010N\u001a\u0004\u0018\u00010O2\b\u0010P\u001a\u0004\u0018\u00010$H\u0004J&\u0010Q\u001a\u00060AR\u00020\u0005*\u00060AR\u00020\u00052\b\u0010R\u001a\u0004\u0018\u00010S2\b\u0010P\u001a\u0004\u0018\u00010$J/\u0010T\u001a\u00020\u000b*\u00020\u000f2\b\u0010U\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010V\u001a\u00020,2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020$09H\u0084\bJ\u0018\u0010X\u001a\u00020$*\u00020\u00022\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010Z\u001a\u00020$*\u0004\u0018\u00010SH\u0016J)\u0010[\u001a\u00020\u000b*\u00020\u000f2\u0016\u0010[\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0\\\"\u0004\u0018\u00010$H\u0004\u00a2\u0006\u0002\u0010]R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R*\u0010\t\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020$*\u00020$8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020$*\u00020$8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u001f\u0010'\u001a\u00020$*\b\u0012\u0004\u0012\u00020$0)8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0015\u0010+\u001a\u00020,*\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006^"}, d2={"Lcom/intellij/database/scripting/base/ElementProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Producer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "type", "Lcom/intellij/database/scripting/OperationType;", "element", "delegate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/OperationType;Lcom/intellij/database/model/basic/BasicElement;Lkotlin/jvm/functions/Function1;)V", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "getDelegate", "()Lkotlin/jvm/functions/Function1;", "getElement", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "plain", "", "getPlain", "(Ljava/lang/String;)Ljava/lang/String;", "scr", "getScr", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "useName", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "cast", "U", "e", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/scripting/base/ElementProducer;", "coding", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "indent", "block", "Lkotlin/Function0;", "commentStr", "comment", "flush", "statement", "Lcom/intellij/database/scripting/CompositeText;", "getPreliminaryOrder", "newCoding", "Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "produce", "quote", "name", "script", "d", "Lcom/intellij/database/model/DataType;", "shortText", "sqlClause", "toString", "useSchemaName", "schemaName", "alterColumn", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "scrName", "alterTable", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "appendOrErr", "text", "eoln", "error", "currentScopeName", "renameScr", "getTableTerm", "words", "", "(Lcom/intellij/database/scripting/CodeTextBuilder;[Ljava/lang/String;)V", "intellij.database.scripting"})
public class ElementProducer<T extends BasicElement>
extends Producer {
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private final T element;
    @Nullable
    private final Function1<ElementProducer<T>, Unit> delegate;

    @NotNull
    public final ScriptingTask getTask() {
        return this.context.getTask();
    }

    @NotNull
    public final CodeTextBuilder getBuilder() {
        return this.context.getBuilder();
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    private final <U extends BasicElement> ElementProducer<U> cast(U e) {
        boolean bl = Intrinsics.areEqual(e, this.getElement());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ElementProducer elementProducer = this;
        if (elementProducer == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.base.ElementProducer<U>");
        }
        return elementProducer;
    }

    @Override
    public void produce() {
        block0: {
            Function1<ElementProducer<T>, Unit> function1;
            Function1<ElementProducer<T>, Unit> function12 = this.delegate;
            if (function12 == null) break block0;
            Function1<ElementProducer<T>, Unit> it = function1 = function12;
            it.invoke((Object)this);
        }
    }

    @Override
    @NotNull
    public String getPreliminaryOrder() {
        return this.context.getHelper().getObjectPreliminaryOrder((BasicElement)this.element);
    }

    @Override
    @NotNull
    public String shortText() {
        return this.getType().getDebugName() + ' ' + this.element.getKind().code();
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.shortText()).append(' ');
        ObjectPath objectPath = BasicPaths.of(this.element);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(element)");
        return stringBuilder.append(objectPath.getDisplayName()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (ElementProducer$WhenMappings.$EnumSwitchMapping$0[this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)schemaName, (Object)this.context.getCurrentSchemaName()) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    public String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.context.getHelper().script(d, this.context.getOptions());
    }

    @Nullable
    public final String quote(@NotNull BasicElement e, @Nullable String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string2 = name;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = this.context.getNaming().nameToScript(it, e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted());
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String quote$default(ElementProducer elementProducer, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quote");
        }
        if ((n & 2) != 0) {
            string = basicElement.getRealName();
        }
        return elementProducer.quote(basicElement, string);
    }

    @NotNull
    public final String commentStr(@Nullable String comment) {
        return this.context.getHelper().commentStr(comment);
    }

    @NotNull
    public final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getContext().getNaming().nameToScript($receiver, false);
    }

    @NotNull
    public final String getPlain(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getContext().getNaming().nameToScript($receiver, true);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ ElementProducer this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                ElementProducer this_$iv = this.this$0;
                return this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
            }
            {
                this.this$0 = elementProducer;
                super(1);
            }
        }), (int)31, null);
    }

    public final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    @NotNull
    public String currentScopeName(@NotNull BasicElement $receiver, @Nullable String renameScr) {
        String string;
        BasicElement q;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string3 = renameScr;
        if (string3 == null) {
            string3 = string2 = ElementProducer.quote$default(this, $receiver, null, 2, null);
        }
        if (string3 == null) {
            string2 = "???";
        }
        String name = string2;
        BasicElement basicElement = this.context.getHelper().qualifier($receiver);
        if (basicElement == null) {
            return name;
        }
        BasicElement basicElement2 = q = basicElement;
        if (basicElement2 instanceof BasicSchema) {
            String schemaName = ((BasicSchema)q).getRealName();
            String prefix = schemaName != null && this.useSchemaName(schemaName) ? Intrinsics.stringPlus((String)this.quote(q, schemaName), (Object)".") : "";
            string = prefix + name;
        } else {
            string = ElementProducer.currentScopeName$default(this, q, null, 1, null) + "." + name;
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String currentScopeName$default(ElementProducer elementProducer, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return elementProducer.currentScopeName(basicElement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.context.getLocus();
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = oldContext == ScriptLocus.OUTSIDE ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.context.getBuilder().getCurrentIndentationState();
        try {
            this.context.setLocus(newContext);
            if (indent) {
                CodeTextBuilder.indent$default(this.context.getBuilder(), null, 1, null);
            }
            block.invoke();
            this.context.getBuilder().returnToIndentation(savedIndentation);
            this.context.setLocus(oldContext);
            boolean bl = complete = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.context.getBuilder().isNotEmpty();
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.context.getBuilder().returnToIndentation(savedIndentation);
            this.context.setLocus(oldContext);
            boolean bl = complete2 = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.context.getBuilder().isNotEmpty();
            if (complete2) {
                this.flush();
            }
            throw throwable;
        }
        if (complete) {
            this.flush();
        }
    }

    public static /* bridge */ /* synthetic */ void coding$default(ElementProducer elementProducer, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        elementProducer.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    public final void newCoding(@NotNull Function1<? super ScriptingContext.NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, block){
            final /* synthetic */ ElementProducer this$0;
            final /* synthetic */ Function1 $block;

            public final void invoke() {
                this.$block.invoke((Object)this.this$0.getContext().getAdapter());
                CodeTextBuilder.ensureEoln$default(this.this$0.getContext().getBuilder(), null, 1, null);
            }
            {
                this.this$0 = elementProducer;
                this.$block = function1;
                super(0);
            }
        }, 3, null);
    }

    @NotNull
    public final ScriptingContext.NewCodingAdapter sqlClause(@NotNull Function1<? super ScriptingContext.NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke((Object)this.context.getAdapter());
        return this.context.getAdapter();
    }

    public final void flush() {
        if (this.context.getBuilder().isNotEmpty()) {
            this.flush(new SimpleCompositeText(this.context.getBuilder()));
        }
        this.context.getBuilder().clearAll();
    }

    private final void flush(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScriptingContext.NewCodingAdapter alterTable(@NotNull ScriptingContext.NewCodingAdapter $receiver, @Nullable BasicLikeTable table, @Nullable String scrName) {
        void text$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $receiver;
        BasicLikeTable basicLikeTable = table;
        String string = basicLikeTable != null ? this.currentScopeName(basicLikeTable, scrName) : null;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $receiver.plus($receiver.unaryPlus("alter"), this.getTableTerm(table));
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $receiver;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv, (String)text$iv){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "table is unknown";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterColumn(@NotNull ScriptingContext.NewCodingAdapter $receiver, @Nullable BasicLikeColumn c, @Nullable String scrName) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicLikeColumn basicLikeColumn = c;
        ScriptingContext.NewCodingAdapter newCodingAdapter = $receiver;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $receiver.plus(this.alterTable($receiver, basicLikeColumn != null ? basicLikeColumn.getLikeTable() : null, null), "alter column");
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $receiver;
        void this_$iv$iv = this_$iv;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv$iv, scrName){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable $receiver) {
        return this.context.getHelper().getTableTerm($receiver);
    }

    protected final void words(@NotNull CodeTextBuilder $receiver, String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        CodeTextBuilder.append$default($receiver, ScriptingUtilsKt.phrase(Arrays.copyOf(words, words.length)), null, false, null, 10, null);
    }

    protected final void appendOrErr(@NotNull CodeTextBuilder $receiver, @Nullable String text2, boolean eoln, @NotNull Function0<String> error2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        if (text2 == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text2, null, eoln, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void appendOrErr$default(ElementProducer this_, CodeTextBuilder $receiver, String text2, boolean eoln, Function0 error2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendOrErr");
        }
        if ((n & 2) != 0) {
            eoln = true;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)error2, (String)"error");
        if (text2 == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text2, null, eoln, null, 10, null);
        }
    }

    @NotNull
    public final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    public final T getElement() {
        return this.element;
    }

    @Nullable
    public final Function1<ElementProducer<T>, Unit> getDelegate() {
        return this.delegate;
    }

    public ElementProducer(@NotNull ScriptingContext context, @NotNull OperationType type, @NotNull T element, @Nullable Function1<? super ElementProducer<T>, Unit> delegate) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        super(type);
        this.context = context;
        this.element = element;
        this.delegate = delegate;
        this.options = this.context.getOptions();
    }

    public /* synthetic */ ElementProducer(ScriptingContext scriptingContext, OperationType operationType, BasicElement basicElement, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(scriptingContext, operationType, basicElement, function1);
    }
}

