/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.ScriptingHelperKt;
import com.intellij.database.scripting.base.SizeAndScale;
import com.intellij.database.scripting.base.producers.AlterCheck;
import com.intellij.database.scripting.base.producers.AlterDatabase;
import com.intellij.database.scripting.base.producers.AlterForeignKey;
import com.intellij.database.scripting.base.producers.AlterIndex;
import com.intellij.database.scripting.base.producers.AlterKey;
import com.intellij.database.scripting.base.producers.AlterLikeColumn;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.AlterSchema;
import com.intellij.database.scripting.base.producers.AlterSynonym;
import com.intellij.database.scripting.base.producers.AlterTable;
import com.intellij.database.scripting.base.producers.AlterTableColumn;
import com.intellij.database.scripting.base.producers.AlterTrigger;
import com.intellij.database.scripting.base.producers.AlterUnknown;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateCheck;
import com.intellij.database.scripting.base.producers.CreateForeignKey;
import com.intellij.database.scripting.base.producers.CreateIndex;
import com.intellij.database.scripting.base.producers.CreateKey;
import com.intellij.database.scripting.base.producers.CreateLikeColumn;
import com.intellij.database.scripting.base.producers.CreateOther;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.base.producers.CreateSequence;
import com.intellij.database.scripting.base.producers.CreateSourceAware;
import com.intellij.database.scripting.base.producers.CreateSynonym;
import com.intellij.database.scripting.base.producers.CreateTable;
import com.intellij.database.scripting.base.producers.DropProducer;
import com.intellij.database.scripting.base.producers.DropUnknown;
import com.intellij.database.scripting.postgres.producers.CreateTrigger;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.sql.dialects.DatabaseFamilyBean;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016J \u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\u001c\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000102H&J\u000e\u00103\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*J\u000e\u00104\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*J\u0012\u00105\u001a\u00020\u00072\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0014J\u0012\u0010<\u001a\u0002092\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J \u0010?\u001a\u00020@\"\b\b\u0000\u0010A*\u00020*2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA0\"H\u0016J \u0010C\u001a\u00020@\"\b\b\u0000\u0010A*\u00020*2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA0,H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010*2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010E\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;2\u0006\u0010F\u001a\u00020GH\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006H"}, d2={"Lcom/intellij/database/scripting/base/ScriptingHelper;", "", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "(Lorg/jetbrains/dekaf/Rdbms;)V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/base/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "sqlDef", "Lcom/intellij/lang/ParserDefinition;", "getSqlDef", "()Lcom/intellij/lang/ParserDefinition;", "sqlDef$delegate", "Lkotlin/Lazy;", "sqlLang", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSqlLang", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "sqlLang$delegate", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "supportsCreateOrReplace", "getSupportsCreateOrReplace", "commentStr", "comment", "createAlterProducer", "Lcom/intellij/database/scripting/base/producers/AlterProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "createDropProducer", "Lcom/intellij/database/scripting/base/producers/DropProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducer", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "getNamingService", "Lcom/intellij/database/scripting/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getObjectPreliminaryOrder", "getObjectPreliminaryOrderPart", "getTableTerm", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "isDefaultSize", "", "d", "Lcom/intellij/database/model/DataType;", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "produceAlter", "", "T", "producer", "produceCreate", "qualifier", "script", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "intellij.database.scripting"})
public abstract class ScriptingHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private final Lazy sqlLang$delegate;
    @Nullable
    private final Lazy sqlDef$delegate;
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private final Set<ObjectKind> supportsCreateIfNotExists;
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;
    @NotNull
    private final Rdbms rdbms;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScriptingHelper.class), "sqlLang", "getSqlLang()Lcom/intellij/sql/dialects/SqlLanguageDialect;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScriptingHelper.class), "sqlDef", "getSqlDef()Lcom/intellij/lang/ParserDefinition;"))};
    }

    @Nullable
    public final SqlLanguageDialect getSqlLang() {
        Lazy lazy = this.sqlLang$delegate;
        ScriptingHelper scriptingHelper = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (SqlLanguageDialect)lazy.getValue();
    }

    @Nullable
    public final ParserDefinition getSqlDef() {
        Lazy lazy = this.sqlDef$delegate;
        ScriptingHelper scriptingHelper = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (ParserDefinition)lazy.getValue();
    }

    @NotNull
    public Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @NotNull
    public Set<ObjectKind> getSupportsCreateIfNotExists() {
        return this.supportsCreateIfNotExists;
    }

    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    public boolean isNullExplicit(@Nullable BasicLikeColumn column2) {
        return false;
    }

    @NotNull
    public String script(@NotNull DataType d, @NotNull ScriptingOptions options) {
        String string;
        boolean defaultSize;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String specification = null;
        if (!d.custom && !d.sizeUnitExplicit && d.size != -1 && (defaultSize = this.isDefaultSize(d))) {
            specification = d.typeName;
            if (d.suffix != null) {
                specification = specification + " " + d.suffix;
            }
        }
        if ((string = specification) == null) {
            String string2 = d.getSpecification();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.specification");
        }
        return string;
    }

    @NotNull
    public abstract NamingService getNamingService(@Nullable BasicModel var1, @Nullable BasicDatabase var2);

    protected boolean isDefaultSize(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(d.typeName);
        return defaults != null && d.size == defaults.getSize() && d.scale == defaults.getScale();
    }

    @NotNull
    public final String getObjectPreliminaryOrder(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        StringBuilder b = new StringBuilder(60);
        for (BasicElement e = element; e != null; e = e.getParent()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getObjectPreliminaryOrderPart(e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public final String getObjectPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        String kindOrder = ScriptingUtilsKt.orderString(objectKind);
        BasicElement basicElement = element;
        if (basicElement instanceof BasicArrangedElement) {
            string = "#" + ScriptingUtilsKt.toFixedOrderString(ScriptingUtilsKt.positionSafe((BasicArrangedElement)element)) + "#" + element.identity();
        } else if (basicElement instanceof BasicIdentifiedElement) {
            string = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element).getObjectId()) + "#" + element.identity();
        } else if (basicElement instanceof BasicOverloadable) {
            string = "?_" + element.identity();
        } else if (basicElement instanceof BasicNamedElement) {
            StringBuilder stringBuilder = new StringBuilder().append("?_");
            String string2 = ((BasicNamedElement)element).getRealName();
            if (string2 == null) {
                string2 = "???";
            }
            string = stringBuilder.append((Object)string2).append("#").append(element.identity()).toString();
        } else {
            string = "?????";
        }
        String elementOrder = string;
        return kindOrder + (element instanceof BasicKey && ((BasicKey)element).isPrimary() ? "^" : "_") + elementOrder;
    }

    @Nullable
    public BasicElement qualifier(@NotNull BasicElement element) {
        BasicElement basicElement;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement2 = element;
        if (basicElement2 instanceof BasicSchemaObject) {
            basicElement = ((BasicSchemaObject)element).getSchema();
        } else if (basicElement2 instanceof BasicLikeColumn) {
            basicElement = ((BasicLikeColumn)element).getLikeTable();
        } else if (basicElement2 instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)element).getMajorObject();
            basicElement = basicMajorObject != null ? basicMajorObject.getSchema() : null;
        } else {
            basicElement = null;
        }
        return basicElement;
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable table) {
        return "table";
    }

    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null) {
            string = "";
        }
        return ScriptingHelperKt.getSqlString(string);
    }

    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof BasicSequence ? (CreateProducer)new CreateSequence<BasicSequence>(context, (BasicSequence)element) : (basicElement instanceof BasicTable ? (CreateProducer)new CreateTable<BasicTable>(context, (BasicTable)element) : (basicElement instanceof BasicLikeColumn ? (CreateProducer)new CreateLikeColumn<BasicLikeColumn>(context, (BasicLikeColumn)element) : (basicElement instanceof BasicIndex ? (CreateProducer)new CreateIndex<BasicIndex>(context, (BasicIndex)element) : (basicElement instanceof BasicKey ? (CreateProducer)new CreateKey<BasicKey>(context, (BasicKey)element) : (basicElement instanceof BasicForeignKey ? (CreateProducer)new CreateForeignKey<BasicForeignKey>(context, (BasicForeignKey)element) : (basicElement instanceof BasicCheck ? (CreateProducer)new CreateCheck<BasicCheck>(context, (BasicCheck)element) : (basicElement instanceof BasicTrigger ? (CreateProducer)new CreateTrigger<BasicTrigger>(context, (BasicTrigger)element) : (basicElement instanceof BasicSourceAware ? (CreateProducer)new CreateSourceAware<BasicSourceAware>(context, (BasicSourceAware)element) : (basicElement instanceof BasicSynonym ? (CreateProducer)new CreateSynonym<BasicSynonym>(context, (BasicSynonym)element) : (CreateProducer)new CreateOther(context, element))))))))));
    }

    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return new DropUnknown(context, element);
    }

    @NotNull
    public AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Object obj;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Object obj2 = it = (obj = elements.getSourceElement());
        return obj2 instanceof BasicDatabase ? (AlterProducer)new AlterDatabase(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicSchema ? (AlterProducer)new AlterSchema(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicTable ? (AlterProducer)new AlterTable(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicTableColumn ? (AlterProducer)new AlterTableColumn(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicKey ? (AlterProducer)new AlterKey(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicIndex ? (AlterProducer)new AlterIndex(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicForeignKey ? (AlterProducer)new AlterForeignKey(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicCheck ? (AlterProducer)new AlterCheck(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicSynonym ? (AlterProducer)new AlterSynonym(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicTrigger ? (AlterProducer)new AlterTrigger(context, BaseProducersKt.cast(elements, it)) : (obj2 instanceof BasicLikeColumn ? (AlterProducer)new AlterLikeColumn(context, BaseProducersKt.cast(elements, it)) : (AlterProducer)new AlterUnknown(context, elements)))))))))));
    }

    public <T extends BasicElement> void produceAlter(@NotNull AlterProducer<T> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        producer.produceAlter();
    }

    public <T extends BasicElement> void produceCreate(@NotNull CreateProducer<T> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        producer.produceCreate();
        if (producer.getContext().getLocus() == ScriptLocus.OUTSIDE && !producer.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS).booleanValue()) {
            producer.produceComments();
        }
    }

    @NotNull
    public final Rdbms getRdbms() {
        return this.rdbms;
    }

    public ScriptingHelper(@NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        this.rdbms = rdbms;
        this.sqlLang$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SqlLanguageDialect>(this){
            final /* synthetic */ ScriptingHelper this$0;

            @Nullable
            public final SqlLanguageDialect invoke() {
                DatabaseFamilyBean databaseFamilyBean = DatabaseFamilyBean.findByRdbms((String)this.this$0.getRdbms().code);
                return databaseFamilyBean != null && (databaseFamilyBean = databaseFamilyBean.language) != null ? (SqlLanguageDialect)databaseFamilyBean.getValue() : null;
            }
            {
                this.this$0 = scriptingHelper;
                super(0);
            }
        }));
        this.sqlDef$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ParserDefinition>(this){
            final /* synthetic */ ScriptingHelper this$0;

            @Nullable
            public final ParserDefinition invoke() {
                ParserDefinition parserDefinition;
                SqlLanguageDialect sqlLanguageDialect = this.this$0.getSqlLang();
                if (sqlLanguageDialect != null) {
                    SqlLanguageDialect sqlLanguageDialect2;
                    SqlLanguageDialect it = sqlLanguageDialect2 = sqlLanguageDialect;
                    parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)it);
                } else {
                    parserDefinition = null;
                }
                return parserDefinition;
            }
            {
                this.this$0 = scriptingHelper;
                super(0);
            }
        }));
        this.supportsCreateOrReplace = SetsKt.emptySet();
        this.supportsCreateIfNotExists = SetsKt.emptySet();
        this.defaultPrimitiveSizes = MapsKt.emptyMap();
    }
}

