/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base.producers;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a+\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u0003*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000b\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u000f\u001a$\u0010\u0010\u001a\u00020\u0011*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u001a\u000e\u0010\u0016\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0017\u001a\u0016\u0010\u0016\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0014*\u0006\u0012\u0002\b\u00030\u0017\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u0014*\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\"\u0010\u001b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0014*\u0006\u0012\u0002\b\u00030\u0017\u00a8\u0006\u001f"}, d2={"checkRenameImpl", "", "o1", "Lcom/intellij/database/model/basic/BasicElement;", "o2", "equalOrNull", "a", "", "b", "getCase", "Lcom/intellij/database/util/Case;", "e", "cast", "Lcom/intellij/database/model/delta/ElementAlteration;", "T", "(Lcom/intellij/database/model/delta/ElementAlteration;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/delta/ElementAlteration;", "commentStatement", "", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "type", "", "comment", "createOrReplace", "Lcom/intellij/database/scripting/base/ElementProducer;", "kind", "Lcom/intellij/database/model/ObjectKind;", "ifNotExists", "isAlteredTo", "e1", "e2", "orReplace", "intellij.database.scripting"})
public final class BaseProducersKt {
    public static final boolean checkRenameImpl(@Nullable BasicElement o1, @Nullable BasicElement o2) {
        if (o1 == null || o2 == null) {
            return o1 != o2;
        }
        Case c1 = BaseProducersKt.getCase(o1);
        Case c2 = BaseProducersKt.getCase(o2);
        if (c1 == Case.MIXED || c2 == Case.MIXED) {
            return !StringsKt.equals((String)o1.getName(), (String)o2.getName(), (boolean)true);
        }
        return Intrinsics.areEqual((Object)c1.apply(o1.getName()), (Object)c2.apply(o2.getName())) ^ true;
    }

    private static final Case getCase(BasicElement e) {
        BasicModel basicModel = e.getModel();
        if (basicModel == null || (basicModel = basicModel.getCasing(e.getKind(), e)) == null) {
            basicModel = Casing.EXACT;
        }
        BasicElement basicElement = e;
        return basicModel.choose(basicElement instanceof BasicNamedElement ? ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted() : false);
    }

    @NotNull
    public static final <T extends BasicElement> ElementAlteration<T> cast(@NotNull ElementAlteration<?> $receiver, @NotNull T e) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        return $receiver;
    }

    @NotNull
    public static final String createOrReplace(@NotNull ElementProducer<?> $receiver, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return $receiver.getContext().getHelper().getSupportsCreateOrReplace().contains(kind) ? BaseProducersKt.createOrReplace($receiver) : "create";
    }

    @NotNull
    public static final String createOrReplace(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver.getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "create or replace" : "create";
    }

    @Nullable
    public static final String orReplace(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver.getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "or replace" : null;
    }

    @Nullable
    public static final String ifNotExists(@NotNull ElementProducer<?> $receiver, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return $receiver.getContext().getHelper().getSupportsCreateIfNotExists().contains(kind) ? BaseProducersKt.ifNotExists($receiver) : null;
    }

    @Nullable
    public static final String ifNotExists(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver.getContext().getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false ? "if not exists" : null;
    }

    public static final void commentStatement(@NotNull CreateProducer<? extends BasicElement> $receiver, @NotNull String type, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        $receiver.newCoding((Function1<ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>($receiver, type, comment){
            final /* synthetic */ CreateProducer receiver$0;
            final /* synthetic */ String $type;
            final /* synthetic */ String $comment;

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.plus($receiver.plus($receiver.plus($receiver.plus($receiver.unaryPlus("comment on"), this.$type), this.receiver$0.fqName()), "is"), this.receiver$0.commentStr(this.$comment));
            }
            {
                this.receiver$0 = createProducer;
                this.$type = string;
                this.$comment = string2;
                super(1);
            }
        }));
    }

    public static final boolean isAlteredTo(@NotNull ElementProducer<?> $receiver, @Nullable BasicElement e1, @Nullable BasicElement e2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (e1 == null || e2 == null) {
            return e1 == e2;
        }
        ElementDelta<?> elementDelta = $receiver.getContext().getBySource().get(e1);
        if (elementDelta != null) {
            ElementDelta<?> elementDelta2;
            ElementDelta<?> it = elementDelta2 = elementDelta;
            return Intrinsics.areEqual(it.getTargetElement(), (Object)e2);
        }
        ElementDelta<?> elementDelta3 = $receiver.getContext().getByTarget().get(e2);
        if (elementDelta3 != null) {
            ElementDelta<?> elementDelta4;
            ElementDelta<?> it = elementDelta4 = elementDelta3;
            return Intrinsics.areEqual(it.getSourceElement(), (Object)e1);
        }
        return Intrinsics.areEqual((Object)e1.getRealName(), (Object)e2.getRealName()) && BaseProducersKt.isAlteredTo($receiver, e1.getParent(), e2.getParent());
    }

    public static final boolean equalOrNull(@Nullable Object a, @Nullable Object b) {
        return a == null || b == null || Intrinsics.areEqual((Object)a, (Object)b);
    }
}

