/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.base.producers;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.base.producers.CreateTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\b\u0010\u001e\u001a\u00020\u001bH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u000bH\u0016J \u0010$\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000bH\u0014J\b\u0010'\u001a\u00020\u0016H\u0014R,\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/intellij/database/scripting/base/producers/CreateTable;", "T", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/basic/BasicTable;)V", "subProcessor", "Lkotlin/Function1;", "", "Lcom/intellij/database/scripting/Operation;", "", "getSubProcessor", "()Lkotlin/jvm/functions/Function1;", "setSubProcessor", "(Lkotlin/jvm/functions/Function1;)V", "tableElementsApplicableInExactTask", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "canCreateInTable", "", "generator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "Lcom/intellij/database/model/basic/BasicElement;", "elementKindNameForCreate", "", "generateAdditionalTableItems", "table", "makeCreateOrReplace", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produceCreate", "register", "root", "registerColumn", "column", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "shouldProduceChildren", "intellij.database.scripting"})
public class CreateTable<T extends BasicTable>
extends CreateProducer<T> {
    @NotNull
    private Function1<? super Set<Operation>, Unit> subProcessor;
    @NotNull
    private final Set<ObjectKind> tableElementsApplicableInExactTask;

    @NotNull
    public final Function1<Set<Operation>, Unit> getSubProcessor() {
        return this.subProcessor;
    }

    public final void setSubProcessor(@NotNull Function1<? super Set<Operation>, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.subProcessor = function1;
    }

    @Override
    @NotNull
    public Operation register(@NotNull BaseCreatingGenerator generator, @NotNull Operation root2) {
        BasicNamedElement it;
        Operation operation2;
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Operation $receiver = operation2 = super.register(generator, root2);
        this.subProcessor = (Function1)new Function1<Set<? extends Operation>, Unit>(this, generator, root2){
            final /* synthetic */ CreateTable this$0;
            final /* synthetic */ BaseCreatingGenerator $generator$inlined;
            final /* synthetic */ Operation $root$inlined;
            {
                this.this$0 = createTable;
                this.$generator$inlined = baseCreatingGenerator;
                this.$root$inlined = operation2;
                super(1);
            }

            public final void invoke(@NotNull Set<Operation> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$generator$inlined.processOperations(it, (Function1<? super Operation, Unit>)((Function1)register.1.1.INSTANCE));
            }
        };
        Family family = ((BasicTable)this.getElement()).getKeys();
        Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"element.keys");
        Iterable iterable = family;
        for (Object element$iv : iterable) {
            BasicKey basicKey = it = (BasicKey)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"it");
            if (!generator.isIndexExplicitFor(basicKey.getUnderlyingIndex(), (BasicKey)it)) continue;
            BaseCreatingGenerator.prepareElement$default(generator, it, root2, false, 4, null);
        }
        PositioningNamingFamily positioningNamingFamily = ((BasicTable)this.getElement()).getColumns();
        Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"element.columns");
        Iterable iterable2 = positioningNamingFamily;
        for (Object element$iv : iterable2) {
            BasicNamedElement basicNamedElement = it = (BasicTableOrViewColumn)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
            this.registerColumn(generator, (BasicTableOrViewColumn)basicNamedElement, $receiver);
        }
        Family family2 = ((BasicTable)this.getElement()).getKeys();
        Intrinsics.checkExpressionValueIsNotNull((Object)family2, (String)"element.keys");
        Iterable iterable3 = family2;
        for (Object element$iv : iterable3) {
            BasicNamedElement basicNamedElement = it = (BasicKey)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
            BaseCreatingGenerator.prepareElement$default(generator, basicNamedElement, $receiver, false, 4, null);
        }
        Family family3 = ((BasicTable)this.getElement()).getForeignKeys();
        Intrinsics.checkExpressionValueIsNotNull((Object)family3, (String)"element.foreignKeys");
        Iterable iterable4 = family3;
        for (Object element$iv : iterable4) {
            BasicNamedElement basicNamedElement = it = (BasicForeignKey)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
            BaseCreatingGenerator.prepareElement$default(generator, basicNamedElement, $receiver, false, 4, null);
        }
        Family family4 = ((BasicTable)this.getElement()).getIndices();
        Intrinsics.checkExpressionValueIsNotNull((Object)family4, (String)"element.indices");
        Iterable iterable5 = family4;
        for (Object element$iv : iterable5) {
            BasicIndex index2;
            BasicIndex basicIndex = index2 = (BasicIndex)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicIndex, (String)"index");
            BaseCreatingGenerator.prepareElement$default(generator, basicIndex, root2, false, 4, null);
        }
        block5: for (Family family5 : ((BasicTable)this.getElement()).getFamilies()) {
            if (family5 == ((BasicTable)this.getElement()).getColumns()) continue;
            Iterator iterator2 = family5.iterator();
            while (iterator2.hasNext()) {
                BasicElement child;
                BasicElement basicElement = child = (BasicElement)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                if (!this.tableElementsApplicableInExactTask.contains(basicElement.getKind()) && this.getTask().getCategory() == ScriptCategory.CREATE_DEFINITION) continue block5;
                if (this.canCreateInTable(generator, child)) {
                    BaseCreatingGenerator.prepareElement$default(generator, child, $receiver, false, 4, null);
                    continue;
                }
                BaseCreatingGenerator.prepareElement$default(generator, child, root2, false, 4, null);
            }
        }
        return operation2;
    }

    protected void registerColumn(@NotNull BaseCreatingGenerator generator, @NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Operation operation2 = BaseCreatingGenerator.prepareElement$default(generator, column2, root2, false, 4, null);
        if (operation2 != null) {
            Operation operation3;
            Operation $receiver = operation3 = operation2;
            Iterable<BasicElement> $receiver$iv = generator.getSingleColumnElements(column2);
            Iterator<BasicElement> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                BasicElement element$iv;
                BasicElement it = element$iv = iterator2.next();
                BaseCreatingGenerator.prepareElement$default(generator, it, $receiver, false, 4, null);
            }
        }
    }

    @Override
    public void produceCreate() {
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ CreateTable this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void header;
                HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter();
                String string = headerFooter.component1();
                String footer = headerFooter.component2();
                CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)header, null, false, null, 14, null);
                if (this.this$0.shouldProduceChildren()) {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, null, 14, null);
                    this.this$0.coding(ScriptLocus.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ produceCreate.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            Iterable $receiver$iv = this.this$0.this$0.getNestedOperations();
                            for (T element$iv : $receiver$iv) {
                                Operation it = (Operation)element$iv;
                                BasicElement basicElement = ScenarioOperations.element(it);
                                if (!Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)ObjectKind.COLUMN)) continue;
                                it.getProducer().produce();
                            }
                            $receiver$iv = this.this$0.this$0.getNestedOperations();
                            Collection collection = new LinkedHashSet<E>();
                            Function1<Set<Operation>, Unit> function1 = this.this$0.this$0.getSubProcessor();
                            for (T element$iv : $receiver$iv) {
                                void destination$iv;
                                Operation it = (Operation)element$iv;
                                BasicElement basicElement = ScenarioOperations.element(it);
                                if (!(Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)ObjectKind.COLUMN) ^ true)) continue;
                                destination$iv.add(element$iv);
                            }
                            Collection collection2 = collection;
                            function1.invoke((Object)collection2);
                            this.this$0.this$0.generateAdditionalTableItems((BasicTable)this.this$0.this$0.getElement());
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, null, 14, null);
                }
                CodeTextBuilder.append$default(this.this$0.getBuilder(), footer, null, false, null, 14, null);
            }
            {
                this.this$0 = createTable;
                super(0);
            }
        }, 3, null);
    }

    protected void generateAdditionalTableItems(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        String name = this.fqName();
        String temporary = ((BasicTable)this.getElement()).isTemporary() ? "temporary" : null;
        String[] stringArray = new String[5];
        stringArray[0] = this.makeCreateOrReplace();
        stringArray[1] = temporary;
        String string = this.elementKindNameForCreate((BasicElement)this.getElement());
        if (string == null) {
            string = "table";
        }
        stringArray[2] = string;
        ObjectKind objectKind = ((BasicTable)this.getElement()).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        stringArray[3] = BaseProducersKt.ifNotExists(this, objectKind);
        stringArray[4] = name;
        String h = ScriptingUtilsKt.phrase(stringArray);
        return new HeaderFooter(h, null);
    }

    @NotNull
    protected String makeCreateOrReplace() {
        ObjectKind objectKind = ((BasicTable)this.getElement()).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        return BaseProducersKt.createOrReplace(this, objectKind);
    }

    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "table" : null;
    }

    @NotNull
    protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
        return this.tableElementsApplicableInExactTask;
    }

    protected boolean canCreateInTable(@NotNull BaseCreatingGenerator generator, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return generator.canGenerateHere(ScriptLocus.IN_TABLE, element);
    }

    protected boolean shouldProduceChildren() {
        Collection collection = this.getNestedOperations();
        return !collection.isEmpty();
    }

    public CreateTable(@NotNull ScriptingContext context, @NotNull T element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        super(context, (BasicElement)element);
        this.subProcessor = subProcessor.1.INSTANCE;
        this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});
    }
}

