/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.exasol.producers;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.exasol.ExasolSourceAware;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.ElementProducerKt;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.SourceAwareProducersKt;
import com.intellij.database.scripting.exasol.producers.ExasolScriptProducersKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00060\bH\u0000\u001a\u001c\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u0006*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\u00060\bH\u0000\u00a8\u0006\f"}, d2={"trimScriptBody", "", "file", "Lcom/intellij/sql/psi/SqlFile;", "equalOrMissingScriptBody", "", "T", "Lcom/intellij/database/model/basic/BasicSourceAware;", "Lcom/intellij/database/scripting/base/producers/AlterProducer;", "exaCreateOrReplace", "", "Lcom/intellij/database/model/exasol/ExasolSourceAware;", "intellij.database.scripting"})
public final class ExasolScriptProducersKt {
    public static final <T extends ExasolSourceAware> void exaCreateOrReplace(@NotNull AlterProducer<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        SourceAwareProducersKt.orReplaceScript($receiver);
        if (((ExasolSourceAware)$receiver.getTo()).getComment() != null) {
            $receiver.getContext().getHelper().createProducer($receiver.getContext(), (BasicElement)$receiver.getTo()).produceCommentIfSupported(false, ((ExasolSourceAware)$receiver.getTo()).getComment());
        }
    }

    public static final <T extends BasicSourceAware> boolean equalOrMissingScriptBody(@NotNull AlterProducer<T> $receiver) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver.getContext().getSqlLang() == null || SourceAwareProducersKt.equalOrMissingProcessed((ElementProducer)$receiver, (object2 = ((BasicSourceAware)$receiver.getElement()).getSourceText()) != null && (object2 = object2.getContent()) != null ? object2.getText() : null, (object = ((BasicSourceAware)$receiver.getTo()).getSourceText()) != null && (object = object.getContent()) != null ? object.getText() : null, (Function1<? super SqlFile, ? extends CharSequence>)((Function1)equalOrMissingScriptBody.1.INSTANCE));
    }

    @NotNull
    public static final String trimScriptBody(@NotNull SqlFile file) {
        PsiElement body2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SqlCreateStatement sqlCreateStatement = ElementProducerKt.getCreateStmt(file);
        Object object = body2 = sqlCreateStatement != null ? sqlCreateStatement.getFirstChild() : null;
        while (body2 != null) {
            if (body2 instanceof PsiLanguageInjectionHost && body2 instanceof SqlElement) {
                String string = body2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(body as PsiElement).text");
                return StringsKt.removeSuffix((String)string, (CharSequence)"\n");
            }
            body2 = body2.getNextSibling();
        }
        String string = file.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        return string;
    }
}

