/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.h2;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.h2.H2Check;
import com.intellij.database.model.h2.H2Database;
import com.intellij.database.model.h2.H2ForeignKey;
import com.intellij.database.model.h2.H2Index;
import com.intellij.database.model.h2.H2Key;
import com.intellij.database.model.h2.H2LikeColumn;
import com.intellij.database.model.h2.H2Routine;
import com.intellij.database.model.h2.H2Schema;
import com.intellij.database.model.h2.H2Sequence;
import com.intellij.database.model.h2.H2Table;
import com.intellij.database.model.h2.H2TableColumn;
import com.intellij.database.model.h2.H2Trigger;
import com.intellij.database.model.h2.H2View;
import com.intellij.database.model.h2.H2ViewColumn;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ScriptingHelper;
import com.intellij.database.scripting.base.ScriptingHelperKt;
import com.intellij.database.scripting.base.SizeAndScale;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.base.producers.DropProducer;
import com.intellij.database.scripting.h2.H2NamingService;
import com.intellij.database.scripting.h2.producers.H2AlterCheck;
import com.intellij.database.scripting.h2.producers.H2AlterDatabase;
import com.intellij.database.scripting.h2.producers.H2AlterForeignKey;
import com.intellij.database.scripting.h2.producers.H2AlterIndex;
import com.intellij.database.scripting.h2.producers.H2AlterKey;
import com.intellij.database.scripting.h2.producers.H2AlterRoutine;
import com.intellij.database.scripting.h2.producers.H2AlterSchema;
import com.intellij.database.scripting.h2.producers.H2AlterSequence;
import com.intellij.database.scripting.h2.producers.H2AlterTable;
import com.intellij.database.scripting.h2.producers.H2AlterTableColumn;
import com.intellij.database.scripting.h2.producers.H2AlterTrigger;
import com.intellij.database.scripting.h2.producers.H2AlterView;
import com.intellij.database.scripting.h2.producers.H2AlterViewColumn;
import com.intellij.database.scripting.h2.producers.H2CreateCheck;
import com.intellij.database.scripting.h2.producers.H2CreateForeignKey;
import com.intellij.database.scripting.h2.producers.H2CreateIndex;
import com.intellij.database.scripting.h2.producers.H2CreateKey;
import com.intellij.database.scripting.h2.producers.H2CreateLikeColumn;
import com.intellij.database.scripting.h2.producers.H2CreateRoutine;
import com.intellij.database.scripting.h2.producers.H2CreateSchema;
import com.intellij.database.scripting.h2.producers.H2CreateSequence;
import com.intellij.database.scripting.h2.producers.H2CreateTable;
import com.intellij.database.scripting.h2.producers.H2CreateTrigger;
import com.intellij.database.scripting.h2.producers.H2CreateView;
import com.intellij.database.scripting.h2.producers.H2DropForeignKey;
import com.intellij.database.scripting.h2.producers.H2DropIndex;
import com.intellij.database.scripting.h2.producers.H2DropKey;
import com.intellij.database.scripting.h2.producers.H2DropRoutine;
import com.intellij.database.scripting.h2.producers.H2DropSchema;
import com.intellij.database.scripting.h2.producers.H2DropSequence;
import com.intellij.database.scripting.h2.producers.H2DropTable;
import com.intellij.database.scripting.h2.producers.H2DropTableColumn;
import com.intellij.database.scripting.h2.producers.H2DropTrigger;
import com.intellij.database.scripting.h2.producers.H2DropView;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001c\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/scripting/h2/H2ScriptingHelper;", "Lcom/intellij/database/scripting/base/ScriptingHelper;", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/base/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "commentStr", "comment", "createAlterProducer", "Lcom/intellij/database/scripting/base/producers/AlterProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "createDropProducer", "Lcom/intellij/database/scripting/base/producers/DropProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducer", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "getNamingService", "Lcom/intellij/database/scripting/h2/H2NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.scripting"})
public final class H2ScriptingHelper
extends ScriptingHelper {
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes;
    public static final H2ScriptingHelper INSTANCE;

    @Override
    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return defaultPrimitiveSizes;
    }

    @Override
    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null || (string = ScriptingHelperKt.getSqlString(string)) == null) {
            string = "null";
        }
        return string;
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof H2Schema ? (CreateProducer)new H2CreateSchema(context, (H2Schema)element) : (basicElement instanceof H2Sequence ? (CreateProducer)new H2CreateSequence(context, (H2Sequence)element) : (basicElement instanceof H2Table ? (CreateProducer)new H2CreateTable(context, (H2Table)element) : (basicElement instanceof H2Index ? (CreateProducer)new H2CreateIndex(context, (H2Index)element) : (basicElement instanceof H2Trigger ? (CreateProducer)new H2CreateTrigger(context, (H2Trigger)element) : (basicElement instanceof H2Key ? (CreateProducer)new H2CreateKey(context, (H2Key)element) : (basicElement instanceof H2ForeignKey ? (CreateProducer)new H2CreateForeignKey(context, (H2ForeignKey)element) : (basicElement instanceof H2Check ? (CreateProducer)new H2CreateCheck(context, (H2Check)element) : (basicElement instanceof H2View ? (CreateProducer)new H2CreateView(context, (H2View)element) : (basicElement instanceof H2LikeColumn ? (CreateProducer)new H2CreateLikeColumn(context, (H2LikeColumn)element) : (basicElement instanceof H2Routine ? (CreateProducer)new H2CreateRoutine(context, (H2Routine)element) : super.createProducer(context, element)))))))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof H2Schema ? (DropProducer)new H2DropSchema(context, (H2Schema)element) : (basicElement instanceof H2Table ? (DropProducer)new H2DropTable(context, (H2Table)element) : (basicElement instanceof H2TableColumn ? (DropProducer)new H2DropTableColumn(context, (H2TableColumn)element) : (basicElement instanceof H2Key ? (DropProducer)new H2DropKey(context, (H2Key)element) : (basicElement instanceof H2ForeignKey ? (DropProducer)new H2DropForeignKey(context, (H2ForeignKey)element) : (basicElement instanceof H2Index ? (DropProducer)new H2DropIndex(context, (H2Index)element) : (basicElement instanceof H2Sequence ? (DropProducer)new H2DropSequence(context, (H2Sequence)element) : (basicElement instanceof H2Trigger ? (DropProducer)new H2DropTrigger(context, (H2Trigger)element) : (basicElement instanceof H2View ? (DropProducer)new H2DropView(context, (H2View)element) : (basicElement instanceof H2Routine ? (DropProducer)new H2DropRoutine(context, (H2Routine)element) : super.createDropProducer(context, element))))))))));
    }

    @Override
    @NotNull
    public AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Object obj;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Object obj2 = it = (obj = elements.getSourceElement());
        return obj2 instanceof H2Database ? (AlterProducer)new H2AlterDatabase(context, (ElementAlteration<? extends H2Database>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Schema ? (AlterProducer)new H2AlterSchema(context, (ElementAlteration<? extends H2Schema>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2View ? (AlterProducer)new H2AlterView(context, (ElementAlteration<? extends H2View>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Table ? (AlterProducer)new H2AlterTable(context, (ElementAlteration<? extends H2Table>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Index ? (AlterProducer)new H2AlterIndex(context, (ElementAlteration<? extends H2Index>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2ForeignKey ? (AlterProducer)new H2AlterForeignKey(context, (ElementAlteration<? extends H2ForeignKey>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Key ? (AlterProducer)new H2AlterKey(context, (ElementAlteration<? extends H2Key>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Check ? (AlterProducer)new H2AlterCheck(context, (ElementAlteration<? extends H2Check>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2TableColumn ? (AlterProducer)new H2AlterTableColumn(context, (ElementAlteration<? extends H2TableColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2ViewColumn ? (AlterProducer)new H2AlterViewColumn(context, (ElementAlteration<? extends H2ViewColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Routine ? (AlterProducer)new H2AlterRoutine(context, (ElementAlteration<? extends H2Routine>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Sequence ? (AlterProducer)new H2AlterSequence(context, (ElementAlteration<? extends H2Sequence>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Trigger ? (AlterProducer)new H2AlterTrigger(context, (ElementAlteration<? extends H2Trigger>)BaseProducersKt.cast(elements, it)) : super.createAlterProducer(context, elements)))))))))))));
    }

    @Override
    @NotNull
    public H2NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
        return H2NamingService.INSTANCE;
    }

    private H2ScriptingHelper() {
        Rdbms rdbms = H2db.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"H2db.RDBMS");
        super(rdbms);
    }

    static {
        H2ScriptingHelper h2ScriptingHelper;
        INSTANCE = h2ScriptingHelper = new H2ScriptingHelper();
        defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"BOOLEAN", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"TINYINT", (Object)new SizeAndScale(3, 0, 2, null)), TuplesKt.to((Object)"SMALLINT", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"INTEGER", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"BIGINT", (Object)new SizeAndScale(19, 0, 2, null)), TuplesKt.to((Object)"REAL", (Object)new SizeAndScale(7, 0, 2, null)), TuplesKt.to((Object)"DOUBLE", (Object)new SizeAndScale(17, 0, 2, null)), TuplesKt.to((Object)"DATE", (Object)new SizeAndScale(8, 0, 2, null)), TuplesKt.to((Object)"TIME", (Object)new SizeAndScale(6, 0, 2, null)), TuplesKt.to((Object)"TIMESTAMP", (Object)new SizeAndScale(23, 10)), TuplesKt.to((Object)"TIMESTAMP WITH TIMEZONE", (Object)new SizeAndScale(30, 10)), TuplesKt.to((Object)"BLOB", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null)), TuplesKt.to((Object)"CLOB", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null))});
    }
}

