/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql.producers;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.mssql.MsDefaultConstraint;
import com.intellij.database.model.mssql.MsLikeColumn;
import com.intellij.database.model.mssql.MsStoredColumn;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.base.producers.CreateLikeColumn;
import com.intellij.database.scripting.mssql.MsScriptingHelperKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0014\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/mssql/producers/MsCreateLikeColumn;", "Lcom/intellij/database/scripting/base/producers/CreateLikeColumn;", "Lcom/intellij/database/model/mssql/MsLikeColumn;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/mssql/MsLikeColumn;)V", "makeColumnSpecification", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeDefault", "makeIdentity", "q", "Lcom/intellij/database/model/SequenceIdentity;", "produceComment", "", "exists", "", "comment", "intellij.database.scripting"})
public final class MsCreateLikeColumn
extends CreateLikeColumn<MsLikeColumn> {
    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptingHelperKt.msAlterComment(this, exists, comment);
    }

    @Override
    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Ref.ObjectRef s;
        block2: {
            String string;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
                s = new Ref.ObjectRef();
                if (!Intrinsics.areEqual((Object)column2.getName(), (Object)"timestamp") || !Intrinsics.areEqual((Object)column2.getDataType().typeName, (Object)"timestamp") || column2.getDataType().custom) break block1;
                s.element = column2.isNotNull() ? "not null" : "null";
                break block2;
            }
            s.element = super.makeColumnSpecification(column2);
            BasicLikeColumn basicLikeColumn = column2;
            if (!(basicLikeColumn instanceof BasicTableColumn)) {
                basicLikeColumn = null;
            }
            BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
            SequenceIdentity q = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
            String string2 = this.makeIdentity(q);
            if (string2 == null) break block2;
            String it = string = string2;
            s.element = Intrinsics.stringPlus((String)((String)s.element), (Object)it);
        }
        return (String)s.element;
    }

    @Override
    @NotNull
    protected String makeDefault(@NotNull BasicLikeColumn column2) {
        String constraintName;
        String string;
        MsDefaultConstraint dc;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = "default " + column2.getDefaultExpression();
        BasicLikeColumn basicLikeColumn = column2;
        if (!(basicLikeColumn instanceof MsStoredColumn)) {
            basicLikeColumn = null;
        }
        MsStoredColumn msStoredColumn = (MsStoredColumn)basicLikeColumn;
        MsDefaultConstraint msDefaultConstraint = dc = msStoredColumn != null ? ModelFun.getDefaultConstraint(msStoredColumn) : null;
        if (msDefaultConstraint != null) {
            MsDefaultConstraint msDefaultConstraint2;
            MsDefaultConstraint it = msDefaultConstraint2 = msDefaultConstraint;
            string = this.quote(it, ModelFun.name(it, this.getTask().getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES)));
        } else {
            string = constraintName = null;
        }
        if (constraintName != null) {
            s = "constraint " + constraintName + ' ' + s;
        }
        return s;
    }

    private final String makeIdentity(SequenceIdentity q) {
        return q == null ? null : (Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ')');
    }

    public MsCreateLikeColumn(@NotNull ScriptingContext context, @NotNull MsLikeColumn element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicLikeColumn)element);
    }
}

