/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql.producers;

import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mssql.MsTableOrView;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.SourceAwareProducersKt;
import com.intellij.database.scripting.mssql.MsScriptingHelperKt;
import com.intellij.database.scripting.postgres.producers.CreateTrigger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/mssql/producers/MsCreateTrigger;", "Lcom/intellij/database/scripting/postgres/producers/CreateTrigger;", "Lcom/intellij/database/model/mssql/MsTrigger;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/mssql/MsTrigger;)V", "generateDisableTrigger", "", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateEncryptedTrigger", "produceComment", "exists", "", "comment", "", "produceCreate", "intellij.database.scripting"})
public final class MsCreateTrigger
extends CreateTrigger<MsTrigger> {
    @Override
    public void produceCreate() {
        if (((MsTrigger)this.getElement()).isEncrypted()) {
            this.generateEncryptedTrigger();
        } else {
            SourceAwareProducersKt.generateSourceAwareUsingSources(this, (BasicSourceAware)this.getElement());
        }
        if (((MsTrigger)this.getElement()).isDisabled()) {
            this.generateDisableTrigger((BasicTrigger)this.getElement());
        }
    }

    private final void generateEncryptedTrigger() {
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ MsCreateTrigger this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.this$0.fqName(), null, false, null, 14, null);
                CodeTextBuilder this_$iv = this.this$0.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    StringBuilder stringBuilder = new StringBuilder().append("on ");
                    Object object = ((MsTrigger)this.this$0.getElement()).getTable();
                    if (object == null || (object = ElementProducer.currentScopeName$default(this.this$0, (BasicElement)object, null, 1, null)) == null) {
                        object = ((MsTrigger)this.this$0.getElement()).getTableName();
                    }
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append((String)object).toString(), null, false, null, 14, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "with encryption", null, false, null, 14, null);
                    CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder().append("for ");
                    Set<TrigEvent> set = ((MsTrigger)this.this$0.getElement()).getEvents();
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"element.events");
                    CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString(), null, false, null, 14, null);
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "as", null, false, null, 14, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "select null -- the original source text was encrypted", null, false, "the original source text was encrypted", 6, null);
            }
            {
                this.this$0 = msCreateTrigger;
                super(0);
            }
        }, 3, null);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptingHelperKt.msAlterComment(this, exists, comment);
    }

    @Override
    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String triggerName = ElementProducer.currentScopeName$default(this, trigger, null, 1, null);
        BasicLikeTable basicLikeTable = trigger.getLikeTable();
        if (basicLikeTable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsTableOrView");
        }
        String tableName = ElementProducer.currentScopeName$default(this, (MsTableOrView)basicLikeTable, null, 1, null);
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName){
            final /* synthetic */ MsCreateTrigger this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ String $tableName;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "disable trigger " + this.$triggerName + " on " + this.$tableName, null, false, null, 14, null);
            }
            {
                this.this$0 = msCreateTrigger;
                this.$triggerName = string;
                this.$tableName = string2;
                super(0);
            }
        }, 3, null);
    }

    public MsCreateTrigger(@NotNull ScriptingContext context, @NotNull MsTrigger element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicTrigger)element);
    }
}

