/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mysql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.mysql.MysqlArgument;
import com.intellij.database.model.mysql.MysqlEvent;
import com.intellij.database.model.mysql.MysqlForeignKey;
import com.intellij.database.model.mysql.MysqlIndex;
import com.intellij.database.model.mysql.MysqlKey;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.mysql.MysqlViewColumn;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ScriptingHelper;
import com.intellij.database.scripting.base.SizeAndScale;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.base.producers.DropProducer;
import com.intellij.database.scripting.mysql.MysqlNamingService;
import com.intellij.database.scripting.mysql.producers.MysqlAlterArgument;
import com.intellij.database.scripting.mysql.producers.MysqlAlterEvent;
import com.intellij.database.scripting.mysql.producers.MysqlAlterForeignKey;
import com.intellij.database.scripting.mysql.producers.MysqlAlterIndex;
import com.intellij.database.scripting.mysql.producers.MysqlAlterKey;
import com.intellij.database.scripting.mysql.producers.MysqlAlterRoutine;
import com.intellij.database.scripting.mysql.producers.MysqlAlterSchema;
import com.intellij.database.scripting.mysql.producers.MysqlAlterTable;
import com.intellij.database.scripting.mysql.producers.MysqlAlterTableColumn;
import com.intellij.database.scripting.mysql.producers.MysqlAlterTrigger;
import com.intellij.database.scripting.mysql.producers.MysqlAlterView;
import com.intellij.database.scripting.mysql.producers.MysqlAlterViewColumn;
import com.intellij.database.scripting.mysql.producers.MysqlCreateEvent;
import com.intellij.database.scripting.mysql.producers.MysqlCreateForeignKey;
import com.intellij.database.scripting.mysql.producers.MysqlCreateIndex;
import com.intellij.database.scripting.mysql.producers.MysqlCreateKey;
import com.intellij.database.scripting.mysql.producers.MysqlCreateRoutine;
import com.intellij.database.scripting.mysql.producers.MysqlCreateTable;
import com.intellij.database.scripting.mysql.producers.MysqlCreateTableColumn;
import com.intellij.database.scripting.mysql.producers.MysqlCreateTrigger;
import com.intellij.database.scripting.mysql.producers.MysqlCreateView;
import com.intellij.database.scripting.mysql.producers.MysqlCreateViewColumn;
import com.intellij.database.scripting.mysql.producers.MysqlDropEvent;
import com.intellij.database.scripting.mysql.producers.MysqlDropForeignKey;
import com.intellij.database.scripting.mysql.producers.MysqlDropIndex;
import com.intellij.database.scripting.mysql.producers.MysqlDropKey;
import com.intellij.database.scripting.mysql.producers.MysqlDropRoutine;
import com.intellij.database.scripting.mysql.producers.MysqlDropSchema;
import com.intellij.database.scripting.mysql.producers.MysqlDropTable;
import com.intellij.database.scripting.mysql.producers.MysqlDropTableColumn;
import com.intellij.database.scripting.mysql.producers.MysqlDropTrigger;
import com.intellij.database.scripting.mysql.producers.MysqlDropView;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u001c\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0012\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlScriptingHelper;", "Lcom/intellij/database/scripting/base/ScriptingHelper;", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/base/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "influencedByUnsigned", "", "supportsCreateIfNotExists", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "supportsCreateOrReplace", "getSupportsCreateOrReplace", "createAlterProducer", "Lcom/intellij/database/scripting/base/producers/AlterProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "createDropProducer", "Lcom/intellij/database/scripting/base/producers/DropProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducer", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "getNamingService", "Lcom/intellij/database/scripting/mysql/MysqlNamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "isDefaultSize", "", "d", "Lcom/intellij/database/model/DataType;", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "intellij.database.scripting"})
public final class MysqlScriptingHelper
extends ScriptingHelper {
    private static final Set<String> influencedByUnsigned;
    @NotNull
    private static final Set<ObjectKind> supportsCreateIfNotExists;
    @NotNull
    private static final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes;
    public static final MysqlScriptingHelper INSTANCE;

    @Override
    @NotNull
    public Set<ObjectKind> getSupportsCreateIfNotExists() {
        return supportsCreateIfNotExists;
    }

    @Override
    @NotNull
    public Set<ObjectKind> getSupportsCreateOrReplace() {
        return supportsCreateOrReplace;
    }

    @Override
    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return defaultPrimitiveSizes;
    }

    @Override
    public boolean isNullExplicit(@Nullable BasicLikeColumn column2) {
        return true;
    }

    @Override
    protected boolean isDefaultSize(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        String suffix = d.suffix;
        if (suffix != null && StringsKt.contains$default((CharSequence)suffix, (CharSequence)"unsigned", (boolean)false, (int)2, null) && influencedByUnsigned.contains(d.typeName)) {
            SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(d.typeName);
            return defaults != null && d.size + 1 == defaults.getSize() && d.scale == defaults.getScale();
        }
        return super.isDefaultSize(d);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof MysqlView ? (CreateProducer)new MysqlCreateView(context, (MysqlView)element) : (basicElement instanceof MysqlRoutine ? (CreateProducer)new MysqlCreateRoutine(context, (MysqlRoutine)element) : (basicElement instanceof MysqlEvent ? (CreateProducer)new MysqlCreateEvent(context, (MysqlEvent)element) : (basicElement instanceof MysqlTrigger ? (CreateProducer)new MysqlCreateTrigger(context, (MysqlTrigger)element) : (basicElement instanceof MysqlIndex ? (CreateProducer)new MysqlCreateIndex(context, (MysqlIndex)element) : (basicElement instanceof MysqlKey ? (CreateProducer)new MysqlCreateKey(context, (MysqlKey)element) : (basicElement instanceof MysqlForeignKey ? (CreateProducer)new MysqlCreateForeignKey(context, (MysqlForeignKey)element) : (basicElement instanceof MysqlTable ? (CreateProducer)new MysqlCreateTable(context, (MysqlTable)element) : (basicElement instanceof MysqlTableColumn ? (CreateProducer)new MysqlCreateTableColumn(context, (MysqlTableColumn)element) : (basicElement instanceof MysqlViewColumn ? (CreateProducer)new MysqlCreateViewColumn(context, (MysqlViewColumn)element) : super.createProducer(context, element))))))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof MysqlEvent ? (DropProducer)new MysqlDropEvent(context, (MysqlEvent)element) : (basicElement instanceof MysqlForeignKey ? (DropProducer)new MysqlDropForeignKey(context, (MysqlForeignKey)element) : (basicElement instanceof MysqlTableColumn ? (DropProducer)new MysqlDropTableColumn(context, (MysqlTableColumn)element) : (basicElement instanceof MysqlKey ? (DropProducer)new MysqlDropKey(context, (MysqlKey)element) : (basicElement instanceof MysqlIndex ? (DropProducer)new MysqlDropIndex(context, (MysqlIndex)element) : (basicElement instanceof MysqlTable ? (DropProducer)new MysqlDropTable(context, (MysqlTable)element) : (basicElement instanceof MysqlView ? (DropProducer)new MysqlDropView(context, (MysqlView)element) : (basicElement instanceof MysqlRoutine ? (DropProducer)new MysqlDropRoutine(context, (MysqlRoutine)element) : (basicElement instanceof MysqlSchema ? (DropProducer)new MysqlDropSchema(context, (MysqlSchema)element) : (basicElement instanceof MysqlTrigger ? (DropProducer)new MysqlDropTrigger(context, (MysqlTrigger)element) : super.createDropProducer(context, element))))))))));
    }

    @Override
    @NotNull
    public AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Object obj;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Object obj2 = it = (obj = elements.getSourceElement());
        return obj2 instanceof MysqlSchema ? (AlterProducer)new MysqlAlterSchema(context, (ElementAlteration<? extends MysqlSchema>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlEvent ? (AlterProducer)new MysqlAlterEvent(context, (ElementAlteration<? extends MysqlEvent>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlView ? (AlterProducer)new MysqlAlterView(context, (ElementAlteration<? extends MysqlView>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlViewColumn ? (AlterProducer)new MysqlAlterViewColumn(context, (ElementAlteration<? extends MysqlViewColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlTable ? (AlterProducer)new MysqlAlterTable(context, (ElementAlteration<? extends MysqlTable>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlTableColumn ? (AlterProducer)new MysqlAlterTableColumn(context, (ElementAlteration<? extends MysqlTableColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlForeignKey ? (AlterProducer)new MysqlAlterForeignKey(context, (ElementAlteration<? extends MysqlForeignKey>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlKey ? (AlterProducer)new MysqlAlterKey(context, (ElementAlteration<? extends MysqlKey>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlIndex ? (AlterProducer)new MysqlAlterIndex(context, (ElementAlteration<? extends MysqlIndex>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlTrigger ? (AlterProducer)new MysqlAlterTrigger(context, (ElementAlteration<? extends MysqlTrigger>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlRoutine ? (AlterProducer)new MysqlAlterRoutine(context, (ElementAlteration<? extends MysqlRoutine>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof MysqlArgument ? (AlterProducer)new MysqlAlterArgument(context, (ElementAlteration<? extends MysqlArgument>)BaseProducersKt.cast(elements, it)) : super.createAlterProducer(context, elements))))))))))));
    }

    @Override
    @NotNull
    public MysqlNamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
        return MysqlNamingService.INSTANCE;
    }

    private MysqlScriptingHelper() {
        Rdbms rdbms = Mysql.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Mysql.RDBMS");
        super(rdbms);
    }

    static {
        MysqlScriptingHelper mysqlScriptingHelper;
        INSTANCE = mysqlScriptingHelper = new MysqlScriptingHelper();
        influencedByUnsigned = SetsKt.setOf((Object[])new String[]{"tinyint", "smallint", "mediumint", "int"});
        supportsCreateIfNotExists = SetsKt.setOf((Object)ObjectKind.TABLE);
        supportsCreateOrReplace = SetsKt.setOf((Object)ObjectKind.VIEW);
        defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"boolean", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"bit", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"tinyint", (Object)new SizeAndScale(4, 0, 2, null)), TuplesKt.to((Object)"smallint", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"mediumint", (Object)new SizeAndScale(9, 0, 2, null)), TuplesKt.to((Object)"int", (Object)new SizeAndScale(11, 0, 2, null)), TuplesKt.to((Object)"bigint", (Object)new SizeAndScale(20, 0, 2, null)), TuplesKt.to((Object)"decimal", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"year", (Object)new SizeAndScale(4, 0, 2, null))});
    }
}

