/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mysql.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ScriptingHelperKt;
import com.intellij.database.scripting.base.producers.CreateLikeColumn;
import com.intellij.database.scripting.mysql.MysqlScriptingHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/mysql/producers/MysqlCreateTableColumn;", "Lcom/intellij/database/scripting/base/producers/CreateLikeColumn;", "Lcom/intellij/database/model/mysql/MysqlTableColumn;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/mysql/MysqlTableColumn;)V", "generalColumnSpecification", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeColumnSpecification", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeNormalColumnSpecification", "produceComment", "", "exists", "", "comment", "intellij.database.scripting"})
public final class MysqlCreateTableColumn
extends CreateLikeColumn<MysqlTableColumn> {
    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = super.generalColumnSpecification(column2);
        if (column2 instanceof MysqlTableColumn) {
            String collation = ((MysqlTableColumn)column2).getCollation();
            String charSet = MysqlScriptingHelperKt.defaultCollationForCharset(this.getContext().getModel(), collation);
            if (charSet != null) {
                void $receiver$iv;
                void this_$iv;
                String string = charSet;
                MysqlCreateTableColumn mysqlCreateTableColumn = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" charset ");
                String string2 = this_$iv.getContext().getNaming().nameToScript((String)$receiver$iv, false);
                s = stringBuilder.append(string2).toString();
            } else if (collation != null) {
                String $receiver$iv = collation;
                MysqlCreateTableColumn this_$iv = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" collate ");
                String string = this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
                s = stringBuilder.append(string).toString();
            }
        }
        return s;
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String string = super.makeNormalColumnSpecification(column2);
        if (string == null) {
            return null;
        }
        String s = string;
        if (column2 instanceof MysqlTableColumn) {
            if (((MysqlTableColumn)column2).isAutoInc()) {
                s = s + " auto_increment";
            }
            if (((MysqlTableColumn)column2).getOnUpdate() != null) {
                s = s + " on update " + ((MysqlTableColumn)column2).getOnUpdate();
            }
        }
        return s;
    }

    @Override
    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(column2 instanceof MysqlTableColumn)) {
            return super.makeComputedColumnSpecification(column2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        DataType dataType = ((MysqlTableColumn)column2).getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String res = stringBuilder.append(this.script(dataType)).append(" as (").append(((MysqlTableColumn)column2).getDefault()).append(')').toString();
        if (((MysqlTableColumn)column2).getColumnKind() == MysqlColumnKind.GENERATED_STORED) {
            res = res + " stored";
        }
        return res;
    }

    @Override
    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        block5: {
            String spec;
            block4: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
                spec = super.makeColumnSpecification(column2);
                string = column2.getComment();
                if (string == null) break block4;
                String it = string2 = string;
                StringBuilder stringBuilder = new StringBuilder().append(spec).append(" comment ");
                String string3 = column2.getComment();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"column.comment!!");
                string = stringBuilder.append(ScriptingHelperKt.getSqlString(string3)).toString();
                if (string != null) break block5;
            }
            string = spec;
        }
        return string;
    }

    public MysqlCreateTableColumn(@NotNull ScriptingContext context, @NotNull MysqlTableColumn element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicLikeColumn)element);
    }
}

