/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.oracle.OraArgument;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraPackageRoutine;
import com.intellij.database.model.oracle.OraRoutine;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.base.AbstractCodeGenerator;
import com.intellij.database.scripting.base.BaseExecuteGenerator;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.oracle.OraExecuteGenerator$WhenMappings;
import com.intellij.database.scripting.oracle.OraScriptingHelper;
import com.intellij.database.scripting.oracle.OracleRoutineArgumentsAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003 !\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0015\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u001b\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;", "Lcom/intellij/database/scripting/base/BaseExecuteGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "(Lcom/intellij/database/scripting/ScriptingContext;)V", "argumentName", "", "argument", "Lcom/intellij/database/model/oracle/OraArgument;", "dataType", "generateRoutine", "", "producer", "Lcom/intellij/database/scripting/base/ElementProducer;", "Lcom/intellij/database/model/basic/BasicRoutine;", "guessDefaultValue", "dt", "Lcom/intellij/database/model/DataType;", "makeExecuteOperation", "Lcom/intellij/database/scripting/Operation;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "root", "makeExecutePackage", "Lcom/intellij/database/model/oracle/OraPackage;", "mustSpecifyPrecision", "", "type", "Lorg/jetbrains/annotations/NotNull;", "precision", "", "typeName", "AsResultSets", "DataProducingWay", "DbmsOutput", "intellij.database.scripting"})
public final class OraExecuteGenerator
extends BaseExecuteGenerator {
    @Override
    @Nullable
    public Operation makeExecuteOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        BasicElement basicElement = element;
        return basicElement instanceof OraPackage ? this.makeExecutePackage((OraPackage)element, root2) : super.makeExecuteOperation(element, root2);
    }

    private final Operation makeExecutePackage(OraPackage element, Operation root2) {
        NamingFamily<? extends OraPackageRoutine> namingFamily = element.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull(namingFamily, (String)"element.routines");
        Iterable $receiver$iv = namingFamily;
        for (Object element$iv : $receiver$iv) {
            OraPackageRoutine it;
            OraPackageRoutine oraPackageRoutine = it = (OraPackageRoutine)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraPackageRoutine, (String)"it");
            BaseExecuteGenerator.prepareElement$default(this, oraPackageRoutine, root2, false, 4, null);
        }
        return null;
    }

    @Override
    protected void generateRoutine(@NotNull ElementProducer<BasicRoutine> producer) {
        String string;
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicRoutine basicRoutine = producer.getElement();
        if (basicRoutine == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraRoutine");
        }
        OraRoutine routine = (OraRoutine)basicRoutine;
        OraRoutine oraRoutine = routine;
        if (oraRoutine instanceof OraSingleRoutine) {
            string = AbstractCodeGenerator.currentScopeName$default(this, routine, null, 1, null);
        } else if (oraRoutine instanceof OraPackageRoutine) {
            StringBuilder stringBuilder = new StringBuilder();
            OraPackage oraPackage = ((OraPackageRoutine)routine).getPackage();
            if (oraPackage == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)oraPackage, (String)"routine.`package`!!");
            string = stringBuilder.append(AbstractCodeGenerator.currentScopeName$default(this, oraPackage, null, 1, null)).append('.').append(AbstractCodeGenerator.quote$default(this, routine, null, 2, null)).toString();
        } else {
            return;
        }
        String callName = string;
        Iterable iterable = routine.getArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"routine.arguments");
        List arguments = CollectionsKt.toList((Iterable)iterable);
        int n = arguments.size();
        OracleRoutineArgumentsAnalyzer analyzer = new OracleRoutineArgumentsAnalyzer(routine);
        OraArgument ret = analyzer.getReturnArgument();
        List<OraArgument> cursors = analyzer.getCursorArguments();
        List<OraArgument> associative = analyzer.getAssociativeArrayArguments();
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeNestedTableArguments();
        List<OracleRoutineArgumentsAnalyzer.PrimitivesPack> primitives = analyzer.getPrimitives(this.getContext().getTask().getVersion());
        DataProducingWay way = this.getContext().getOptions().get(ScriptingOptionStatic.CALL) != false ? (DataProducingWay)new AsResultSets(this) : (DataProducingWay)new DbmsOutput(this);
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this, arguments, n, ret, callName, way, plArrays, plTables, associative, cursors, sqlArrays, sqlTables, primitives){
            final /* synthetic */ OraExecuteGenerator this$0;
            final /* synthetic */ List $arguments;
            final /* synthetic */ int $n;
            final /* synthetic */ OraArgument $ret;
            final /* synthetic */ String $callName;
            final /* synthetic */ DataProducingWay $way;
            final /* synthetic */ List $plArrays;
            final /* synthetic */ List $plTables;
            final /* synthetic */ List $associative;
            final /* synthetic */ List $cursors;
            final /* synthetic */ List $sqlArrays;
            final /* synthetic */ List $sqlTables;
            final /* synthetic */ List $primitives;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                ScriptingContext.NewCodingAdapter this_$iv = $receiver;
                boolean nl$iv = true;
                boolean prev$iv = this_$iv.getStartWithNewLine();
                this_$iv.setStartWithNewLine(nl$iv);
                Collection collection = this.$arguments;
                if (!collection.isEmpty()) {
                    $receiver.unaryPlus("declare");
                    ScriptingContext.NewCodingAdapter this_$iv2 = $receiver;
                    this_$iv2.newLine();
                    this_$iv2.indent();
                    Iterator<E> iterator2 = this.$arguments.iterator();
                    while (iterator2.hasNext()) {
                        String string;
                        OraArgument a;
                        OraArgument oraArgument = a = (OraArgument)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraArgument, (String)"a");
                        DasArgument.Direction dir = oraArgument.getArgumentDirection();
                        DataType dt = a.getDataType();
                        String specification = OraExecuteGenerator.access$dataType(this.this$0, a);
                        switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
                            case 1: 
                            case 2: {
                                DataType dataType = dt;
                                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"dt");
                                String defaultValue = OraExecuteGenerator.access$guessDefaultValue(this.this$0, dataType);
                                string = OraExecuteGenerator.access$argumentName(this.this$0, a) + ' ' + specification + " := " + defaultValue + ';';
                                break;
                            }
                            case 3: 
                            case 4: {
                                string = OraExecuteGenerator.access$argumentName(this.this$0, a) + ' ' + specification + ';';
                                break;
                            }
                            default: {
                                string = null;
                            }
                        }
                        String line = string;
                        $receiver.unaryPlus(line);
                    }
                    this_$iv2.unindent();
                }
                $receiver.unaryPlus("begin");
                this_$iv.setStartWithNewLine(prev$iv);
                ArrayList<String> passing = new ArrayList<String>(this.$n);
                Iterator<E> $i$f$withNewLines = this.$arguments.iterator();
                while ($i$f$withNewLines.hasNext()) {
                    OraArgument a;
                    OraArgument oraArgument = a = (OraArgument)$i$f$withNewLines.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraArgument, (String)"a");
                    switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$1[oraArgument.getArgumentDirection().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            passing.add(OraExecuteGenerator.access$argumentName(this.this$0, a) + " => " + OraExecuteGenerator.access$argumentName(this.this$0, a));
                        }
                    }
                }
                String retClause = this.$ret != null ? "result :=" : null;
                ScriptingContext.NewCodingAdapter this_$iv3 = $receiver;
                this_$iv3.newLine();
                this_$iv3.indent();
                $receiver.unaryPlus(retClause);
                if (passing.size() == 0) {
                    $receiver.unaryPlus(this.$callName + ';');
                } else if (passing.size() == 1) {
                    String passingText = (String)CollectionsKt.first((List)passing);
                    $receiver.unaryPlus(this.$callName + '(' + passingText + ");");
                } else {
                    $receiver.unaryPlus(this.$callName + '(');
                    ScriptingContext.NewCodingAdapter this_$iv4 = $receiver;
                    boolean nl$iv2 = true;
                    boolean prev$iv2 = this_$iv4.getStartWithNewLine();
                    this_$iv4.setStartWithNewLine(nl$iv2);
                    ScriptingContext.NewCodingAdapter this_$iv5 = $receiver;
                    this_$iv5.newLine();
                    this_$iv5.indent();
                    boolean dir = false;
                    for (String p : (Iterable)passing) {
                        void i2;
                        $receiver.unaryPlus(i2 + true < passing.size() ? p + ',' : p);
                        ++i2;
                    }
                    this_$iv5.unindent();
                    $receiver.unaryPlus(");");
                    this_$iv4.setStartWithNewLine(prev$iv2);
                }
                ScriptingContext.NewCodingAdapter this_$iv6 = $receiver;
                boolean nl$iv3 = true;
                boolean prev$iv3 = this_$iv6.getStartWithNewLine();
                this_$iv6.setStartWithNewLine(nl$iv3);
                this.$way.producePlArrays($receiver, this.$plArrays);
                this.$way.producePlTables($receiver, this.$plTables);
                this.$way.produceAssociativeArrays($receiver, this.$associative);
                this.$way.produceCursors($receiver, this.$cursors);
                this.$way.produceSqlArrays($receiver, this.$sqlArrays);
                this.$way.produceSqlTables($receiver, this.$sqlTables);
                this.$way.producePrimitives($receiver, this.$primitives);
                this_$iv6.setStartWithNewLine(prev$iv3);
                this_$iv3.unindent();
                this_$iv3 = $receiver;
                boolean nl$iv4 = true;
                prev$iv3 = this_$iv3.getStartWithNewLine();
                this_$iv3.setStartWithNewLine(nl$iv4);
                $receiver.unaryPlus("end;");
                this_$iv3.setStartWithNewLine(prev$iv3);
            }
            {
                this.this$0 = oraExecuteGenerator;
                this.$arguments = list;
                this.$n = n;
                this.$ret = oraArgument;
                this.$callName = string;
                this.$way = dataProducingWay;
                this.$plArrays = list2;
                this.$plTables = list3;
                this.$associative = list4;
                this.$cursors = list5;
                this.$sqlArrays = list6;
                this.$sqlTables = list7;
                this.$primitives = list8;
                super(1);
            }
        }));
    }

    private final String argumentName(OraArgument argument) {
        return argument.getArgumentDirection() == DasArgument.Direction.RETURN ? "result" : AbstractCodeGenerator.quote$default(this, argument, null, 2, null);
    }

    private final String dataType(OraArgument argument) {
        String string;
        DataType type = argument.getDataType();
        if (StringsKt.equals((String)type.typeName, (String)"ref cursor", (boolean)true)) {
            string = "sys_refcursor";
        } else {
            DataType dataType = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"type");
            if (this.mustSpecifyPrecision(dataType)) {
                ScriptingOptions scriptingOptions = this.getContext().getOptions();
                StringBuilder stringBuilder = new StringBuilder().append(type.typeName).append('(');
                String string2 = type.typeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.typeName");
                string = OraScriptingHelper.INSTANCE.optionsDependentSpecification(type, scriptingOptions, stringBuilder.append(this.precision(string2)).append(')').toString());
            } else {
                string = this.script(type);
            }
        }
        return string;
    }

    private final int precision(String typeName) {
        boolean bl;
        block1: {
            for (String element$iv : new String[]{"char", "nchar"}) {
                String it = element$iv;
                if (!StringsKt.equals((String)it, (String)typeName, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl ? 50 : 4000;
    }

    private final boolean mustSpecifyPrecision(DataType type) {
        boolean bl;
        block1: {
            for (String element$iv : new String[]{"varchar", "char", "varchar2", "nchar", "nvarchar2"}) {
                String it = element$iv;
                if (!StringsKt.equals((String)it, (String)type.typeName, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl && !type.custom && type.schemaName == null && type.packageName == null && type.size < 0 && type.enumValues == null && type.vagueArg == null && type.suffix == null;
    }

    private final String guessDefaultValue(DataType dt) {
        String typeName;
        String string = typeName = dt.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeName");
        return StringsKt.startsWith((String)string, (String)"binary_integer", (boolean)true) ? "0" : (StringsKt.startsWith((String)typeName, (String)"number", (boolean)true) ? (dt.scale > 0 ? "0.0" : "0") : (StringsKt.startsWith((String)typeName, (String)"float", (boolean)true) ? "0.0" : (StringsKt.startsWith((String)typeName, (String)"char", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"varchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nvarchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"date", (boolean)true) ? "sysdate" : "null")))))));
    }

    public OraExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public static final /* synthetic */ String access$dataType(OraExecuteGenerator $this, @NotNull OraArgument argument) {
        return $this.dataType(argument);
    }

    @NotNull
    public static final /* synthetic */ String access$guessDefaultValue(OraExecuteGenerator $this, @NotNull DataType dt) {
        return $this.guessDefaultValue(dt);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000e\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH&J\"\u0010\u0012\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u0013\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/oracle/OraExecuteGenerator$DataProducingWay;", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/scripting/ScriptingContext;", "associative", "", "Lcom/intellij/database/model/oracle/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/scripting/oracle/OracleRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.scripting"})
    private static interface DataProducingWay {
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<OracleRoutineArgumentsAnalyzer.PrimitivesPack> var2);

        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0011\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0013\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0016J\"\u0010\u0017\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0018\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/oracle/OraExecuteGenerator$AsResultSets;", "Lcom/intellij/database/scripting/oracle/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;", "(Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;)V", "commentMaybe", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/scripting/ScriptingContext;", "associative", "", "Lcom/intellij/database/model/oracle/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/scripting/oracle/OracleRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.scripting"})
    private static final class AsResultSets
    implements DataProducingWay {
        private final OraExecuteGenerator generator;

        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OracleRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(primitives, (String)"primitives");
            if (primitives.isEmpty()) {
                return;
            }
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OracleRoutineArgumentsAnalyzer.PrimitivesPack pack2 : primitives) {
                $receiver.plus($receiver.plus($receiver.unaryPlus((pack2.getEnabled() ? "" : "-- ") + "open ? for select "), CollectionsKt.joinToString$default((Iterable)pack2.getArguments(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<OraArgument, String>(this, primitives){
                    final /* synthetic */ AsResultSets this$0;
                    final /* synthetic */ List $primitives$inlined;
                    {
                        this.this$0 = asResultSets;
                        this.$primitives$inlined = list;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull OraArgument it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String argumentName = OraExecuteGenerator.access$argumentName(AsResultSets.access$getGenerator$p(this.this$0), it);
                        return argumentName + " as " + argumentName;
                    }
                }), (int)31, null)), "from dual;");
            }
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(cursors, (String)"cursors");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : cursors) {
                $receiver.unaryPlus("? := " + this.generator.argumentName(oraArgument) + ';');
            }
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : arrays) {
                $receiver.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : arrays) {
                $receiver.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : arrays) {
                $receiver.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : arrays) {
                $receiver.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(associative, (String)"associative");
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : associative) {
                $receiver.unaryPlus("-- open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        private final String commentMaybe() {
            return OracleRoutineArgumentsAnalyzer.Companion.supportPlTypesInSql(this.generator.getContext().getTask().getVersion()) ? "" : "-- ";
        }

        public AsResultSets(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            this.generator = generator;
        }

        @NotNull
        public static final /* synthetic */ OraExecuteGenerator access$getGenerator$p(AsResultSets $this) {
            return $this.generator;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u000f\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0010\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0012\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0016\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0017\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rH\u0016J\"\u0010\u001a\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u001b\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/scripting/oracle/OraExecuteGenerator$DbmsOutput;", "Lcom/intellij/database/scripting/oracle/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;", "(Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;)V", "print", "", "adapter", "Lcom/intellij/database/scripting/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/scripting/ScriptingContext;", "prefix", "", "arguments", "", "Lcom/intellij/database/model/oracle/OraArgument;", "printCommented", "produceAssociativeArrays", "associative", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/scripting/oracle/OracleRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.scripting"})
    private static final class DbmsOutput
    implements DataProducingWay {
        private final OraExecuteGenerator generator;

        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OracleRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            Object it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(primitives, (String)"primitives");
            Iterable iterable = $receiver$iv = (Iterable)primitives;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (OracleRoutineArgumentsAnalyzer.PrimitivesPack)element$iv$iv;
                Iterable list$iv$iv = ((OracleRoutineArgumentsAnalyzer.PrimitivesPack)it).getArguments();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List arguments = (List)destination$iv$iv;
            $receiver$iv = arguments;
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            DbmsOutput dbmsOutput = this;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (OraArgument)element$iv$iv;
                if (!it.getDataType().custom) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dbmsOutput.printCommented(newCodingAdapter, list);
            $receiver$iv = arguments;
            newCodingAdapter = adapter;
            dbmsOutput = this;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (OraArgument)element$iv$iv;
                if (!(!it.getDataType().custom)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            dbmsOutput.print(newCodingAdapter, list);
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(cursors, (String)"cursors");
            this.printCommented(adapter, cursors);
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            Intrinsics.checkParameterIsNotNull(associative, (String)"associative");
            this.printCommented(adapter, associative);
        }

        private final void printCommented(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "-- ", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, String prefix, List<? extends OraArgument> arguments) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            ScriptingContext.NewCodingAdapter $receiver = newCodingAdapter = adapter;
            for (OraArgument oraArgument : arguments) {
                String argumentName = this.generator.argumentName(oraArgument);
                $receiver.unaryPlus(prefix + "dbms_output.put_line('" + argumentName + " = ' || " + argumentName + ");");
            }
        }

        public DbmsOutput(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            this.generator = generator;
        }
    }
}

