/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.AbstractCodeGenerator;
import com.intellij.database.scripting.base.AbstractScriptingService;
import com.intellij.database.scripting.oracle.OraExecuteGenerator;
import com.intellij.database.scripting.oracle.OraNativeDefinitionsGenerator;
import com.intellij.database.scripting.oracle.OraRefreshMatViewGenerator;
import com.intellij.database.scripting.oracle.OraScriptingHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/oracle/OraScriptingService;", "Lcom/intellij/database/scripting/base/AbstractScriptingService;", "()V", "scriptingHelper", "Lcom/intellij/database/scripting/oracle/OraScriptingHelper;", "getScriptingHelper", "()Lcom/intellij/database/scripting/oracle/OraScriptingHelper;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createExecuteGenerator", "Lcom/intellij/database/scripting/base/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "createNativeDefinitionsGenerator", "createRefreshingGenerator", "intellij.database.scripting"})
public final class OraScriptingService
extends AbstractScriptingService {
    @NotNull
    private static final String statementDelimiterStr = "/";
    private static final boolean statementDelimiterOwnsLine = true;
    public static final OraScriptingService INSTANCE;

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    public OraScriptingHelper getScriptingHelper() {
        return OraScriptingHelper.INSTANCE;
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new OraNativeDefinitionsGenerator(context);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new OraRefreshMatViewGenerator(context);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new OraExecuteGenerator(context);
    }

    private OraScriptingService() {
        Rdbms rdbms = Oracle.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Oracle.RDBMS");
        super(rdbms);
    }

    static {
        OraScriptingService oraScriptingService;
        INSTANCE = oraScriptingService = new OraScriptingService();
        statementDelimiterStr = statementDelimiterStr;
        statementDelimiterOwnsLine = true;
    }
}

