/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.AbstractScriptingServiceKt;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.oracle.producers.OraCreateCluster;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/oracle/producers/OraCreateCluster;", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "Lcom/intellij/database/model/oracle/OraCluster;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/oracle/OraCluster;)V", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "produceCreate", "", "register", "Lcom/intellij/database/scripting/Operation;", "generator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "root", "intellij.database.scripting"})
public final class OraCreateCluster
extends CreateProducer<OraCluster> {
    @Override
    @NotNull
    public Operation register(@NotNull BaseCreatingGenerator generator, @NotNull Operation root2) {
        Operation operation2;
        block0: {
            OraClusterIndex oraClusterIndex;
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation2 = super.register(generator, root2);
            OraClusterIndex oraClusterIndex2 = ((OraCluster)this.getElement()).getIndices().get();
            if (oraClusterIndex2 == null) break block0;
            OraClusterIndex it = oraClusterIndex = oraClusterIndex2;
            BaseCreatingGenerator.prepareElement$default(generator, it, root2, false, 4, null);
        }
        return operation2;
    }

    @Override
    public void produceCreate() {
        String name = this.fqName();
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name){
            final /* synthetic */ OraCreateCluster this$0;
            final /* synthetic */ String $name;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "create cluster " + this.$name, null, false, null, 14, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, null, 14, null);
                ElementProducer.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ produceCreate.1 this$0;

                    public final void invoke() {
                        for (OraClusterColumn oraClusterColumn : ((OraCluster)this.this$0.this$0.getElement()).getColumns()) {
                            OraCreateCluster oraCreateCluster = this.this$0.this$0;
                            OraClusterColumn oraClusterColumn2 = oraClusterColumn;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraClusterColumn2, (String)"column");
                            String name1 = ElementProducer.quote$default(oraCreateCluster, oraClusterColumn2, null, 2, null);
                            DataType dataType = oraClusterColumn.getDataType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
                            String type1 = dataType.getSpecification();
                            String suffix = oraClusterColumn.isSorted() ? " sort" : "";
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), name1 + ' ' + type1 + suffix + ',', null, false, null, 14, null);
                        }
                        PositioningNamingFamily<? extends OraClusterColumn> positioningNamingFamily = ((OraCluster)this.this$0.this$0.getElement()).getColumns();
                        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
                        if (positioningNamingFamily.isEmpty()) {
                            this.this$0.this$0.getBuilder().appendErrorComment("looks like columns were not retrieved because the user had no SELECT_CATALOG_ROLE :(");
                        }
                        this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 1, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, null, 14, null);
                CodeTextBuilder this_$iv = this.this$0.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (((OraCluster)this.this$0.getElement()).getBlockSize() > 0) {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "size " + ((OraCluster)this.this$0.getElement()).getBlockSize(), null, false, null, 14, null);
                    }
                    String singleTableClause = ((OraCluster)this.this$0.getElement()).isSingleTable() ? "single table" : null;
                    String cardinalityClause = ((OraCluster)this.this$0.getElement()).getHashCardinality() != 0 ? "hashkeys " + ((OraCluster)this.this$0.getElement()).getHashCardinality() : null;
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, null, 14, null);
                    if (((OraCluster)this.this$0.getElement()).getHashExpression() != null) {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "hash is " + ((OraCluster)this.this$0.getElement()).getHashExpression(), null, false, null, 14, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = oraCreateCluster;
                this.$name = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return AbstractScriptingServiceKt.getUNSUPPORTED();
    }

    public OraCreateCluster(@NotNull ScriptingContext context, @NotNull OraCluster element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicElement)element);
    }
}

