/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.properties.OraCollectionTypeKind;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.AbstractScriptingServiceKt;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateProducer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/oracle/producers/OraCreateCollectionType;", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "Lcom/intellij/database/model/oracle/OraCollectionType;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/oracle/OraCollectionType;)V", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "produceCreate", "", "intellij.database.scripting"})
public final class OraCreateCollectionType
extends CreateProducer<OraCollectionType> {
    @Override
    public void produceCreate() {
        String string;
        OraCollectionType col = (OraCollectionType)this.getElement();
        String name = this.fqName();
        int n = col.getUpperBound();
        DataType dataType = col.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
        String d = this.script(dataType);
        if (col.getTypeKind() == OraCollectionTypeKind.VARIABLE_SIZE_ARRAY && n > 0) {
            String[] stringArray = new String[4];
            ObjectKind objectKind = col.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
            stringArray[0] = BaseProducersKt.createOrReplace(this, objectKind);
            stringArray[1] = "type";
            stringArray[2] = name;
            stringArray[3] = "is varray(" + n + ") of " + d;
            string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            String[] stringArray = new String[5];
            ObjectKind objectKind = col.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
            stringArray[0] = BaseProducersKt.createOrReplace(this, objectKind);
            stringArray[1] = "type";
            stringArray[2] = name;
            stringArray[3] = "as table of";
            stringArray[4] = d;
            string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String s1 = string;
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
            final /* synthetic */ OraCreateCollectionType this$0;
            final /* synthetic */ String $s1;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s1, null, false, null, 14, null);
            }
            {
                this.this$0 = oraCreateCollectionType;
                this.$s1 = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return AbstractScriptingServiceKt.getUNSUPPORTED();
    }

    public OraCreateCollectionType(@NotNull ScriptingContext context, @NotNull OraCollectionType element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicElement)element);
    }
}

