/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle.producers;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateTable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/oracle/producers/OraCreateTable;", "Lcom/intellij/database/scripting/base/producers/CreateTable;", "Lcom/intellij/database/model/oracle/OraTable;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/oracle/OraTable;)V", "generateObjectTable", "", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produceComment", "exists", "", "comment", "", "produceCreate", "intellij.database.scripting"})
public final class OraCreateTable
extends CreateTable<OraTable> {
    @Override
    public void produceCreate() {
        if (((OraTable)this.getElement()).getRowTypeObjectName() != null) {
            this.generateObjectTable();
        } else {
            super.produceCreate();
        }
    }

    private final void generateObjectTable() {
        String string;
        String $receiver$iv;
        OraCreateTable this_$iv;
        String objectSchemaName = ((OraTable)this.getElement()).getRowTypeSchemaName();
        if (Intrinsics.areEqual((Object)objectSchemaName, (Object)((OraTable)this.getElement()).getSchemaName())) {
            objectSchemaName = null;
        }
        String string2 = ((OraTable)this.getElement()).getRowTypeObjectName();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String objectName = string2;
        if (objectSchemaName == null) {
            String string3 = objectName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectName");
            String string4 = string3;
            this_$iv = this;
            string = this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
        } else {
            $receiver$iv = objectSchemaName;
            this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
            StringBuilder stringBuilder2 = stringBuilder.append(string5).append('.');
            String string6 = objectName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"objectName");
            $receiver$iv = string6;
            this_$iv = this;
            stringBuilder = stringBuilder2;
            string5 = this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
            string = stringBuilder.append(string5).toString();
        }
        String n = string;
        String[] stringArray = new String[5];
        stringArray[0] = "create table";
        ObjectKind objectKind = ObjectKind.TABLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.TABLE");
        stringArray[1] = BaseProducersKt.ifNotExists(this, objectKind);
        stringArray[2] = this.fqName();
        stringArray[3] = "of";
        stringArray[4] = n;
        String s = ScriptingUtilsKt.phrase(stringArray);
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ OraCreateTable this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, null, 14, null);
            }
            {
                this.this$0 = oraCreateTable;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        OraTable tab = (OraTable)this.getElement();
        String name = this.fqName();
        String[] stringArray = new String[3];
        stringArray[0] = "create table";
        ObjectKind objectKind = tab.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"tab.kind");
        stringArray[1] = BaseProducersKt.ifNotExists(this, objectKind);
        stringArray[2] = name;
        String string = ScriptingUtilsKt.phrase(stringArray);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String h = string;
        String f = null;
        if (tab.getClusterName() != null) {
            void $receiver$iv;
            void $receiver$iv2;
            String string2 = tab.getClusterName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tab.clusterName!!");
            String string3 = string2;
            OraCreateTable this_$iv = this;
            String cn = this_$iv.getContext().getNaming().nameToScript((String)$receiver$iv2, false);
            List<String> list = tab.getClusterColNames();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"tab.clusterColNames");
            Iterable $i$f$getScr = list;
            OraCreateTable this_$iv2 = this;
            String cols = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((ElementProducer)this_$iv2){
                final /* synthetic */ ElementProducer this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String $receiver$iv = it;
                    ElementProducer this_$iv = this.this$0;
                    return this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
                }
                {
                    this.this$0 = elementProducer;
                    super(1);
                }
            }), (int)31, null);
            f = "\tcluster " + cn + " (" + cols + ')';
        } else if (tab.getOrganization() == TableOrganization.INDEX) {
            f = "\torganization index";
        } else if (tab.isTemporary()) {
            String string4;
            String[] stringArray2 = new String[3];
            stringArray2[0] = "create global temporary table";
            ObjectKind objectKind2 = tab.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"tab.kind");
            stringArray2[1] = BaseProducersKt.ifNotExists(this, objectKind2);
            stringArray2[2] = name;
            String string5 = ScriptingUtilsKt.phrase(stringArray2);
            if (string5 == null) {
                Intrinsics.throwNpe();
            }
            h = string5;
            boolean bl = tab.isTemporaryPreserve();
            if (!bl) {
                string4 = "\ton commit delete rows";
            } else if (bl) {
                string4 = "\ton commit preserve rows";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            f = string4;
        }
        return new HeaderFooter(h, f);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, "table", comment);
    }

    public OraCreateTable(@NotNull ScriptingContext context, @NotNull OraTable element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }
}

