/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgresbase.PostgresBaseObjectWithOwner;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateProducer;
import com.intellij.database.scripting.postgres.producers.PgCreateDefType;
import com.intellij.database.scripting.postgres.producers.PgCreateDefType$WhenMappings;
import com.intellij.database.scripting.postgres.producers.PostgresDefTypeProducersKt;
import com.intellij.database.scripting.postgres_base.producers.PostgresBaseOwnerAwareProducer;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/scripting/postgres/producers/PgCreateDefType;", "Lcom/intellij/database/scripting/base/producers/CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresDefType;", "Lcom/intellij/database/scripting/postgres_base/producers/PostgresBaseOwnerAwareProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/postgres/PostgresDefType;)V", "objectType", "", "getObjectType", "()Ljava/lang/String;", "generateComposite", "", "generateDomain", "generateEnum", "produceComment", "exists", "", "comment", "produceCreate", "register", "Lcom/intellij/database/scripting/Operation;", "generator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "root", "intellij.database.scripting"})
public final class PgCreateDefType
extends CreateProducer<PostgresDefType>
implements PostgresBaseOwnerAwareProducer {
    @Override
    @NotNull
    public String getObjectType() {
        return PostgresDefTypeProducersKt.access$getTypeKind$p(this);
    }

    @Override
    @NotNull
    public Operation register(@NotNull BaseCreatingGenerator generator, @NotNull Operation root2) {
        Operation operation2;
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Operation $receiver = operation2 = super.register(generator, root2);
        JBIterable<? extends BasicElement> jBIterable = ((PostgresDefType)this.getElement()).getChildren();
        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"element.children");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            BasicElement it;
            BasicElement basicElement = it = (BasicElement)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
            generator.prepareElement(basicElement, $receiver, true);
        }
        return operation2;
    }

    @Override
    public void produceCreate() {
        switch (PgCreateDefType$WhenMappings.$EnumSwitchMapping$0[((PostgresDefType)this.getElement()).getSubKind().ordinal()]) {
            case 1: {
                this.generateEnum();
                break;
            }
            case 2: {
                this.generateDomain();
                break;
            }
            case 3: {
                this.generateComposite();
                break;
            }
            default: {
                this.newCoding((Function1<ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
                    final /* synthetic */ PgCreateDefType this$0;

                    public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        $receiver.error("Unknown how to generate " + ((PostgresDefType)this.this$0.getElement()).getSubKind().human_readable_name() + " type");
                    }
                    {
                        this.this$0 = pgCreateDefType;
                        super(1);
                    }
                }));
            }
        }
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, "type", comment);
    }

    private final void generateEnum() {
        String name = this.fqName();
        List<String> list = ((PostgresDefType)this.getElement()).getLabels();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.labels");
        String labels2 = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)generateEnum.labels.1.INSTANCE, (int)31, null);
        String cmd = "create type " + name + " as enum (" + labels2 + ')';
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
            final /* synthetic */ PgCreateDefType this$0;
            final /* synthetic */ String $cmd;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, null, 14, null);
            }
            {
                this.this$0 = pgCreateDefType;
                this.$cmd = string;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDomain() {
        PostgresDefType d = (PostgresDefType)this.getElement();
        String name = this.fqName();
        String def2 = d.getDefinition();
        String cmd = "create domain " + name + " as " + def2 + (d.isNotNull() ? " not null" : "");
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd, d){
            final /* synthetic */ PgCreateDefType this$0;
            final /* synthetic */ String $cmd;
            final /* synthetic */ PostgresDefType $d;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, null, 14, null);
                ElementProducer.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateDomain.1 this$0;

                    public final void invoke() {
                        if (this.this$0.$d.getDefaultExpression() != null) {
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "default " + this.this$0.$d.getDefaultExpression(), null, false, null, 14, null);
                        }
                        Iterable $receiver$iv = this.this$0.this$0.getNestedOperations();
                        for (T element$iv : $receiver$iv) {
                            Operation it = (Operation)element$iv;
                            it.getProducer().produce();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 1, null);
            }
            {
                this.this$0 = pgCreateDefType;
                this.$cmd = string;
                this.$d = postgresDefType;
                super(0);
            }
        }, 3, null);
    }

    private final void generateComposite() {
        ElementProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PgCreateDefType this$0;

            public final void invoke() {
                String name = this.this$0.fqName();
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "create type " + name + " as", null, false, null, 14, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, null, 14, null);
                CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                Iterator<T> iterator2 = ((PostgresDefType)this.this$0.getElement()).getAttributes().iterator();
                while (iterator2.hasNext()) {
                    PostgresDefTypeAttribute a;
                    PostgresDefTypeAttribute postgresDefTypeAttribute = a = (PostgresDefTypeAttribute)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeAttribute, (String)"a");
                    String n = ElementProducer.quote$default(this.this$0, postgresDefTypeAttribute, null, 2, null);
                    DataType t = a.getDataType();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), n + ' ' + t + ',', null, false, null, 14, null);
                }
                this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                this.this$0.getBuilder().unindent();
                CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, null, 14, null);
            }
            {
                this.this$0 = pgCreateDefType;
                super(0);
            }
        }, 3, null);
    }

    public PgCreateDefType(@NotNull ScriptingContext context, @NotNull PostgresDefType element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicElement)element);
    }

    @Override
    public boolean getShouldGenerate() {
        return PostgresBaseOwnerAwareProducer.DefaultImpls.getShouldGenerate(this);
    }

    @Override
    public void produceOwner() {
        PostgresBaseOwnerAwareProducer.DefaultImpls.produceOwner(this);
    }

    @Override
    @NotNull
    public String definition(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.definition(this, $receiver);
    }

    @Override
    @Nullable
    public PostgresBaseObjectWithOwner element(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.element(this, $receiver);
    }
}

