/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.postgres.PostgresForeignTableColumn;
import com.intellij.database.model.postgres.PostgresLocalTableColumn;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateLikeColumn;
import com.intellij.database.scripting.postgres.PostgresScriptingHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/scripting/postgres/producers/PgCreateLikeColumn;", "Lcom/intellij/database/scripting/base/producers/CreateLikeColumn;", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/basic/BasicLikeColumn;)V", "generalColumnSpecification", "", "column", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "produceComment", "", "exists", "", "comment", "register", "Lcom/intellij/database/scripting/Operation;", "generator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "root", "intellij.database.scripting"})
public final class PgCreateLikeColumn
extends CreateLikeColumn<BasicLikeColumn> {
    @Override
    @NotNull
    public Operation register(@NotNull BaseCreatingGenerator generator, @NotNull Operation root2) {
        Operation operation2;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation2 = super.register(generator, root2);
            if (!(this.getElement() instanceof PostgresLocalTableColumn) || ((PostgresLocalTableColumn)this.getElement()).getSequenceName() == null) break block3;
            BasicNode basicNode = ((PostgresLocalTableColumn)this.getElement()).getSchema();
            if (basicNode != null && (basicNode = basicNode.getSequences()) != null) {
                String string = ((PostgresLocalTableColumn)this.getElement()).getSequenceName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((basicNode = (PostgresSequence)basicNode.get(string)) != null) {
                    BasicNode basicNode2;
                    BasicNode it = basicNode2 = basicNode;
                    generator.prepareElement((BasicElement)it, $receiver, true);
                }
            }
        }
        return operation2;
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, "column", comment);
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column2).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column2) : super.makeNormalColumnSpecification(column2);
    }

    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        PostgresTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PostgresTable)) {
            basicElement = null;
        }
        PostgresTable postgresTable = table = (PostgresTable)basicElement;
        if (postgresTable != null) {
            if (postgresTable.isPartition()) {
                return "";
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append(super.generalColumnSpecification(column2));
        if (column2 instanceof PostgresForeignTableColumn) {
            List<String> list = ((PostgresForeignTableColumn)column2).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"column.options");
            string = PostgresScriptingHelperKt.optionsToString(list, false);
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String makeSerialColumnSpecification(PostgresTableColumn column2) {
        String specification;
        String string;
        DataType dt = column2.getDataType();
        String string2 = dt.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dt.typeName");
        if (StringsKt.startsWith$default((String)string2, (String)"small", (boolean)false, (int)2, null)) {
            string = "smallserial";
        } else {
            String string3 = dt.typeName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dt.typeName");
            string = specification = StringsKt.startsWith$default((String)string3, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial";
        }
        if (column2.isNotNull()) {
            specification = specification + " not null";
        }
        return specification;
    }

    public PgCreateLikeColumn(@NotNull ScriptingContext context, @NotNull BasicLikeColumn element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, element);
    }
}

