/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres.producers;

import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseObjectWithOwner;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.postgres_base.producers.PgBaseCreateFunction;
import com.intellij.database.scripting.postgres_base.producers.PostgresBaseOwnerAwareProducer;
import com.intellij.database.scripting.postgres_base.producers.PostgresBaseRoutineProducersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0014\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/scripting/postgres/producers/PgCreateRoutine;", "Lcom/intellij/database/scripting/postgres_base/producers/PgBaseCreateFunction;", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "Lcom/intellij/database/scripting/postgres_base/producers/PostgresBaseOwnerAwareProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/postgres/PostgresRoutine;)V", "objectType", "", "getObjectType", "()Ljava/lang/String;", "appendRoutineAttributes", "", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "floatAttributeName", "", "s", "getVolatilityKind", "definition", "Lcom/intellij/database/scripting/base/ElementProducer;", "intellij.database.scripting"})
public final class PgCreateRoutine
extends PgBaseCreateFunction<PostgresRoutine>
implements PostgresBaseOwnerAwareProducer {
    @Override
    @NotNull
    public String getObjectType() {
        return "function";
    }

    @Override
    @NotNull
    public String definition(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        StringBuilder stringBuilder = new StringBuilder().append(ElementProducer.currentScopeName$default($receiver, $receiver.getElement(), null, 1, null)).append("(");
        Object obj = $receiver.getElement();
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresRoutine");
        }
        Iterable iterable = ((PostgresRoutine)obj).getArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"(element as PostgresRoutine).arguments");
        return stringBuilder.append(SequencesKt.joinToString$default(PostgresBaseRoutineProducersKt.mapToDefinitions($receiver, iterable, false, false), null, null, null, (int)0, null, null, (int)63, null)).append(")").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendRoutineAttributes(@NotNull PostgresBaseRoutine f) {
        CodeTextBuilder this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        super.appendRoutineAttributes(f);
        PostgresRoutine postgresRoutine = (PostgresRoutine)f;
        if (postgresRoutine.isLeakproof()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "leakproof", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isWindow()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "window", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isStrict()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "strict", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isSecurityDefiner()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "security definer", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.getConcurrencyKind() != PostgresRoutineConcurrencyKind.UNSAFE) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder codeTextBuilder = this.getBuilder();
                StringBuilder stringBuilder = new StringBuilder().append("parallel ");
                PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = postgresRoutine.getConcurrencyKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)postgresRoutineConcurrencyKind), (String)"postgresRoutine.concurrencyKind");
                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(postgresRoutineConcurrencyKind.getModifier()).toString(), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (PostgresModelFun.isCostDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), this.floatAttributeName(postgresRoutine.getCost(), "cost") + ' ' + PostgresModelFun.costAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (PostgresModelFun.isRowsDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), this.floatAttributeName(postgresRoutine.getRows(), "rows") + ' ' + PostgresModelFun.rowsAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        List<String> configurationParameters = postgresRoutine.getConfigurationParameters();
        for (String configurationParameter : configurationParameters) {
            CodeTextBuilder this_$iv2 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv2, null, 1, null);
            try {
                this.getBuilder().phrase("SET", configurationParameter);
            }
            finally {
                this_$iv2.unindent();
            }
        }
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        if (f.getVolatilityKind() == PostgresVolatilityKind.VOLATILE) {
            string = null;
        } else {
            Object object = f.getVolatilityKind();
            if (object != null && (object = object.name()) != null) {
                Object object2;
                Object object3 = object2 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
        }
        return string;
    }

    private final String floatAttributeName(float f, String s) {
        float f2 = f;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = Float.isInfinite(f2);
        return stringBuilder.append(bl ? "--" : "").append(s).toString();
    }

    public PgCreateRoutine(@NotNull ScriptingContext context, @NotNull PostgresRoutine element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (PostgresBaseRoutine)element);
    }

    @Override
    public boolean getShouldGenerate() {
        return PostgresBaseOwnerAwareProducer.DefaultImpls.getShouldGenerate(this);
    }

    @Override
    public void produceOwner() {
        PostgresBaseOwnerAwareProducer.DefaultImpls.produceOwner(this);
    }

    @Override
    @Nullable
    public PostgresBaseObjectWithOwner element(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.element(this, $receiver);
    }
}

