/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres.producers;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresLocalTable;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgresbase.PostgresBaseObjectWithOwner;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateTable;
import com.intellij.database.scripting.postgres.PostgresScriptingHelperKt;
import com.intellij.database.scripting.postgres.producers.PgCreateTable;
import com.intellij.database.scripting.postgres_base.producers.PostgresBaseOwnerAwareProducer;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0011H\u0014J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\rH\u0014R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/intellij/database/scripting/postgres/producers/PgCreateTable;", "Lcom/intellij/database/scripting/base/producers/CreateTable;", "Lcom/intellij/database/model/postgres/PostgresTable;", "Lcom/intellij/database/scripting/postgres_base/producers/PostgresBaseOwnerAwareProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/postgres/PostgresTable;)V", "objectType", "", "getObjectType", "()Ljava/lang/String;", "acceptColumn", "", "column", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "elementKindNameForCreate", "Lcom/intellij/database/model/basic/BasicElement;", "findPropertyInAncestors", "condition", "Lkotlin/Function1;", "isModifiedColumnFromAncestor", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produceComment", "", "exists", "comment", "registerColumn", "generator", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "root", "Lcom/intellij/database/scripting/Operation;", "shouldProduceChildren", "intellij.database.scripting"})
public final class PgCreateTable
extends CreateTable<PostgresTable>
implements PostgresBaseOwnerAwareProducer {
    @Override
    @NotNull
    public String getObjectType() {
        String string = this.elementKindNameForCreate((BasicElement)this.getElement());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    protected void registerColumn(@NotNull BaseCreatingGenerator generator, @NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (!(column2 instanceof PostgresTableColumn) || this.acceptColumn((PostgresTableColumn)column2)) {
            super.registerColumn(generator, column2, root2);
        }
    }

    private final boolean acceptColumn(PostgresTableColumn column2) {
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PostgresTable)) {
            basicElement = null;
        }
        PostgresTable postgresTable = (PostgresTable)basicElement;
        if (postgresTable == null) {
            return true;
        }
        PostgresTable table = postgresTable;
        return !table.isPartition() && !column2.isInherited() || table.isPartition() && this.isModifiedColumnFromAncestor(column2);
    }

    @Override
    protected boolean shouldProduceChildren() {
        return super.shouldProduceChildren() || !((PostgresTable)this.getElement()).isPartition();
    }

    private final boolean isModifiedColumnFromAncestor(PostgresTableColumn element) {
        return element.getDefaultExpression() != null && !this.findPropertyInAncestors(element, (Function1<? super PostgresTableColumn, Boolean>)((Function1)new Function1<PostgresTableColumn, Boolean>(element){
            final /* synthetic */ PostgresTableColumn $element;

            public final boolean invoke(@NotNull PostgresTableColumn it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)this.$element.getDefaultExpression(), (Object)it.getDefaultExpression());
            }
            {
                this.$element = postgresTableColumn;
                super(1);
            }
        })) || element.isNotNull() && !this.findPropertyInAncestors(element, (Function1<? super PostgresTableColumn, Boolean>)((Function1)isModifiedColumnFromAncestor.2.INSTANCE));
    }

    private final boolean findPropertyInAncestors(PostgresTableColumn column2, Function1<? super PostgresTableColumn, Boolean> condition) {
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PostgresTable)) {
            basicElement = null;
        }
        PostgresTable postgresTable = (PostgresTable)basicElement;
        if (postgresTable == null) {
            return false;
        }
        PostgresTable parent = postgresTable;
        List<PostgresTable> ancestors = PostgresModelFun.getAncestors(parent);
        for (PostgresTable ancestor : ancestors) {
            PostgresTableColumn sameInAncestor2;
            if (ancestor.getColumns().find((Predicate<? extends PostgresTableColumn>)new Predicate<PostgresTableColumn>(column2){
                final /* synthetic */ PostgresTableColumn $column;

                public final boolean test(PostgresTableColumn it) {
                    PostgresTableColumn postgresTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)postgresTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)postgresTableColumn.getName(), (Object)this.$column.getName());
                }
                {
                    this.$column = postgresTableColumn;
                }
            }) == null) {
                continue;
            }
            if (!((Boolean)condition.invoke((Object)sameInAncestor2)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        HeaderFooter hf = super.makeTableHeaderFooter();
        PostgresTable t = (PostgresTable)this.getElement();
        String footer = null;
        String header = hf.getHeader();
        makeTableHeaderFooter.1 nextLine$ = makeTableHeaderFooter.1.INSTANCE;
        List<Long> list = t.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.ancestorIds");
        Collection collection = list;
        if (!collection.isEmpty()) {
            List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
            if (t.isPartition()) {
                header = nextLine$.invoke(header) + "partition of " + ElementProducer.currentScopeName$default(this, (BasicElement)CollectionsKt.first(ancestors), null, 1, null);
                footer = t.getPartitionExpression();
            } else {
                footer = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                    final /* synthetic */ PgCreateTable this$0;

                    @NotNull
                    public final String invoke(@NotNull PostgresTable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return ElementProducer.currentScopeName$default(this.this$0, it, null, 1, null);
                    }
                    {
                        this.this$0 = pgCreateTable;
                        super(1);
                    }
                }), (int)31, null) + ")";
            }
        }
        if (t instanceof PostgresLocalTable && ((PostgresLocalTable)t).isPartitioned()) {
            footer = nextLine$.invoke(footer) + "partition by " + ((PostgresLocalTable)t).getPartitionKey();
        }
        if (t instanceof PostgresForeignTable) {
            StringBuilder stringBuilder = new StringBuilder().append(nextLine$.invoke(footer)).append("server ").append(((PostgresForeignTable)t).getServer());
            List<String> list2 = ((PostgresForeignTable)t).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"t.options");
            footer = stringBuilder.append(PostgresScriptingHelperKt.optionsToString(list2, true)).toString();
        }
        return new HeaderFooter(header, footer);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, this.getElement() instanceof PostgresLocalTable ? "table" : "foreign table", comment);
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element);
    }

    public PgCreateTable(@NotNull ScriptingContext context, @NotNull PostgresTable element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }

    @Override
    public boolean getShouldGenerate() {
        return PostgresBaseOwnerAwareProducer.DefaultImpls.getShouldGenerate(this);
    }

    @Override
    public void produceOwner() {
        PostgresBaseOwnerAwareProducer.DefaultImpls.produceOwner(this);
    }

    @Override
    @NotNull
    public String definition(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.definition(this, $receiver);
    }

    @Override
    @Nullable
    public PostgresBaseObjectWithOwner element(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.element(this, $receiver);
    }
}

