/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres.producers;

import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ElementProducerKt;
import com.intellij.database.scripting.base.producers.AlterProducer;
import com.intellij.database.scripting.base.producers.Flag;
import com.intellij.database.scripting.base.producers.SourceAwareProducersKt;
import com.intellij.database.scripting.postgres.PostgresScriptingHelperKt;
import com.intellij.database.scripting.postgres_base.PostgresBaseScriptingHelperKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlWhereClause;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ5\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u0002H\u000e2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/scripting/postgres/producers/PostgresAlterRule;", "Lcom/intellij/database/scripting/base/producers/AlterProducer;", "Lcom/intellij/database/model/postgres/PostgresRule;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterDefinition", "Lcom/intellij/database/scripting/base/producers/Flag;", "()Lcom/intellij/database/scripting/base/producers/Flag;", "checkAlterDefinition", "", "foldFlags", "T", "f", "acc", "Lkotlin/Function2;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "produceAlter", "", "produceAlterComment", "produceAlterDefinition", "produceRename", "trimCommandsAndCondition", "", "file", "Lcom/intellij/sql/psi/SqlFile;", "intellij.database.scripting"})
public final class PostgresAlterRule
extends AlterProducer<PostgresRule> {
    @NotNull
    private final Flag isAlterDefinition;

    @NotNull
    public final Flag isAlterDefinition() {
        return this.isAlterDefinition;
    }

    @Override
    public <T> T foldFlags(T f, @NotNull Function2<? super T, ? super Flag, ? extends T> acc) {
        Intrinsics.checkParameterIsNotNull(acc, (String)"acc");
        return (T)acc.invoke(super.foldFlags(f, acc), (Object)this.isAlterDefinition);
    }

    @Override
    public void produceAlter() {
        super.produceAlter();
        if (this.isAlterDefinition.getV()) {
            this.produceAlterDefinition();
        }
    }

    @Override
    public void produceRename() {
        PostgresScriptingHelperKt.alterRenameOnParent(this, "rule");
    }

    @Override
    public void produceAlterComment() {
        PostgresBaseScriptingHelperKt.commentOnInner$default(this, "rule", null, 2, null);
    }

    private final void produceAlterDefinition() {
        SourceAwareProducersKt.orReplaceScript(this);
    }

    public final boolean checkAlterDefinition() {
        if (Intrinsics.areEqual(((PostgresRule)this.getElement()).getEvents(), ((PostgresRule)this.getTo()).getEvents()) ^ true) {
            return true;
        }
        if (((PostgresRule)this.getElement()).getTurn() != ((PostgresRule)this.getTo()).getTurn()) {
            return true;
        }
        if (!SourceAwareProducersKt.equalOrMissing(this, ((PostgresRule)this.getElement()).getSourceText(), ((PostgresRule)this.getTo()).getSourceText())) {
            CompositeText compositeText = ((PostgresRule)this.getElement()).getSourceText();
            CompositeText compositeText2 = ((PostgresRule)this.getTo()).getSourceText();
            if (!SourceAwareProducersKt.equalOrMissingProcessed(this, compositeText != null ? compositeText.getText() : null, compositeText2 != null ? compositeText2.getText() : null, (Function1<? super SqlFile, ? extends CharSequence>)((Function1)new Function1<SqlFile, String>(this){

                @NotNull
                public final String invoke(@NotNull SqlFile p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return PostgresAlterRule.access$trimCommandsAndCondition((PostgresAlterRule)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PostgresAlterRule.class);
                }

                public final String getName() {
                    return "trimCommandsAndCondition";
                }

                public final String getSignature() {
                    return "trimCommandsAndCondition(Lcom/intellij/sql/psi/SqlFile;)Ljava/lang/String;";
                }
            }))) {
                return true;
            }
        }
        return false;
    }

    private final String trimCommandsAndCondition(SqlFile file) {
        String string;
        CharSequence charSequence;
        SqlCreateStatement sqlCreateStatement = ElementProducerKt.getCreateStmt(file);
        Object c = sqlCreateStatement != null ? sqlCreateStatement.getFirstChild() : null;
        if (c == null) {
            String string2 = file.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.text");
            return string2;
        }
        StringBuilder res = new StringBuilder();
        while (c != null) {
            if (c instanceof SqlStatement) {
                res.append(((SqlStatement)c).getText()).append("\n");
            } else if (c instanceof SqlWhereClause && (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)c, SqlExpression.class) != null) {
                CharSequence it;
                CharSequence charSequence2 = it = charSequence;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"it");
                res.append(charSequence2.getText()).append("\n");
            }
            c = c.getNextSibling();
        }
        charSequence = res;
        if (charSequence.length() == 0) {
            String string3 = file.getText();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.text");
        } else {
            String string4 = res.toString();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"res.toString()");
        }
        return string;
    }

    public PostgresAlterRule(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends PostgresRule> elements) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        super(context, elements);
        this.isAlterDefinition = new Flag(this.checkAlterDefinition());
    }

    @NotNull
    public static final /* synthetic */ String access$trimCommandsAndCondition(PostgresAlterRule $this, @NotNull SqlFile file) {
        return $this.trimCommandsAndCondition(file);
    }
}

