/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.redshift.producers;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.redshift.RedshiftExternalTable;
import com.intellij.database.model.redshift.RedshiftExternalTableColumn;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.base.AbstractScriptingServiceKt;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.ScriptingHelperKt;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateTable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/redshift/producers/RsCreateExternalTable;", "Lcom/intellij/database/scripting/base/producers/CreateTable;", "Lcom/intellij/database/model/redshift/RedshiftExternalTable;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/redshift/RedshiftExternalTable;)V", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "elementKindNameForCreate", "", "Lcom/intellij/database/model/basic/BasicElement;", "externalTableFooter", "externalTableHeader", "findProperty", "properties", "", "key", "generateRowFormat", "table", "fieldDelimiter", "generateSerDeRowFormat", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "intellij.database.scripting"})
public final class RsCreateExternalTable
extends CreateTable<RedshiftExternalTable> {
    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return AbstractScriptingServiceKt.getUNSUPPORTED();
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        return new HeaderFooter(this.externalTableHeader(), this.externalTableFooter());
    }

    /*
     * WARNING - void declaration
     */
    private final String externalTableHeader() {
        void $receiver$iv;
        void this_$iv;
        String[] stringArray = new String[3];
        ObjectKind objectKind = ((RedshiftExternalTable)this.getElement()).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        stringArray[0] = BaseProducersKt.createOrReplace(this, objectKind);
        stringArray[1] = this.elementKindNameForCreate((BasicElement)this.getElement());
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((RedshiftExternalTable)this.getElement()).getSchemaName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.schemaName!!");
        String string2 = string;
        RsCreateExternalTable rsCreateExternalTable = this;
        StringBuilder stringBuilder2 = stringBuilder;
        int n = 2;
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        String string3 = this_$iv.getContext().getNaming().nameToScript((String)$receiver$iv, false);
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append('.');
        String string4 = this.nameScr();
        if (string4 == null) {
            string4 = "???";
        }
        stringArray2[n] = stringBuilder3.append(string4).toString();
        return ScriptingUtilsKt.phrase(stringArray3);
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "external table" : super.elementKindNameForCreate(element);
    }

    private final String externalTableFooter() {
        Iterable $receiver$iv;
        boolean hasNullStorageFormats;
        boolean unknownStorage;
        block10: {
            boolean bl;
            unknownStorage = ((RedshiftExternalTable)this.getElement()).getStorageType() == RedshiftExternalTableStorageType.UNKNOWN;
            for (String string : new String[]{((RedshiftExternalTable)this.getElement()).getInputFormat(), ((RedshiftExternalTable)this.getElement()).getOutputFormat(), ((RedshiftExternalTable)this.getElement()).getLocation()}) {
                String it = string;
                if (!(it == null)) continue;
                bl = true;
                break block10;
            }
            bl = hasNullStorageFormats = false;
        }
        if (unknownStorage && hasNullStorageFormats) {
            return "-- unable to generate footer: broken storage attributes";
        }
        StringBuilder sb = new StringBuilder();
        PositioningNamingFamily<? extends RedshiftExternalTableColumn> positioningNamingFamily = ((RedshiftExternalTable)this.getElement()).getColumns();
        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
        Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : iterable) {
            RedshiftExternalTableColumn it;
            RedshiftExternalTableColumn redshiftExternalTableColumn = it = (RedshiftExternalTableColumn)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
            if (!(redshiftExternalTableColumn.getPartitionKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable iterable2 = $receiver$iv;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                RedshiftExternalTableColumn it;
                RedshiftExternalTableColumn redshiftExternalTableColumn = it = (RedshiftExternalTableColumn)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
                it = (RedshiftExternalTableColumn)b;
                Comparable comparable = Integer.valueOf(redshiftExternalTableColumn.getPartitionKeyOrder());
                RedshiftExternalTableColumn redshiftExternalTableColumn2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn2, (String)"it");
                Integer n = redshiftExternalTableColumn2.getPartitionKeyOrder();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        List partitionKeys = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
        if (!($receiver$iv = (Collection)partitionKeys).isEmpty()) {
            sb.append("partitioned by (").append(CollectionsKt.joinToString$default((Iterable)partitionKeys, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<RedshiftExternalTableColumn, String>(this){
                final /* synthetic */ RsCreateExternalTable this$0;

                @NotNull
                public final String invoke(RedshiftExternalTableColumn it) {
                    StringBuilder stringBuilder = new StringBuilder();
                    RedshiftExternalTableColumn redshiftExternalTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
                    StringBuilder stringBuilder2 = stringBuilder.append(ElementProducer.quote$default(this.this$0, redshiftExternalTableColumn, null, 2, null)).append(' ');
                    DataType dataType = it.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                    return stringBuilder2.append(this.this$0.script(dataType)).toString();
                }
                {
                    this.this$0 = rsCreateExternalTable;
                    super(1);
                }
            }), (int)30, null)).append(")\n");
        }
        List<String> list = ((RedshiftExternalTable)this.getElement()).getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.serdeProperties");
        String fieldDelimiter = this.findProperty(list, "field.delim");
        List<String> list2 = ((RedshiftExternalTable)this.getElement()).getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.serdeProperties");
        String string = this.findProperty(list2, "serialization.format");
        sb.append(Intrinsics.areEqual((Object)((RedshiftExternalTable)this.getElement()).getSerializationLib(), (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe") && fieldDelimiter != null && Intrinsics.areEqual((Object)fieldDelimiter, (Object)string) ? this.generateRowFormat((RedshiftExternalTable)this.getElement(), fieldDelimiter) : this.generateSerDeRowFormat((RedshiftExternalTable)this.getElement()));
        sb.append("stored as\n");
        if (unknownStorage) {
            StringBuilder stringBuilder = new StringBuilder().append("inputformat ");
            String string2 = ((RedshiftExternalTable)this.getElement()).getInputFormat();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.inputFormat!!");
            StringBuilder stringBuilder2 = sb.append(stringBuilder.append(ScriptingHelperKt.getSqlString(string2)).append('\n').toString());
            StringBuilder stringBuilder3 = new StringBuilder().append("outputformat ");
            String string3 = ((RedshiftExternalTable)this.getElement()).getOutputFormat();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.outputFormat!!");
            StringBuilder stringBuilder4 = stringBuilder2.append(stringBuilder3.append(ScriptingHelperKt.getSqlString(string3)).append('\n').toString());
            StringBuilder stringBuilder5 = new StringBuilder().append("location ");
            String string4 = ((RedshiftExternalTable)this.getElement()).getLocation();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.location!!");
            stringBuilder4.append(stringBuilder5.append(ScriptingHelperKt.getSqlString(string4)).append('\n').toString());
        } else {
            sb.append(((RedshiftExternalTable)this.getElement()).getStorageType().getSqlDefinition() + '\n');
        }
        List<String> list3 = ((RedshiftExternalTable)this.getElement()).getProps();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.props");
        object = list3;
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("table properties (");
            List<String> list4 = ((RedshiftExternalTable)this.getElement()).getProps();
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"element.props");
            sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
        }
        String string5 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
        return string5;
    }

    private final String generateRowFormat(RedshiftExternalTable table, String fieldDelimiter) {
        StringBuffer sb = new StringBuffer();
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
        String lineDelimiter = this.findProperty(list, "line.delim");
        sb.append("row format delimited\n").append("fields terminated by '" + fieldDelimiter + "'\n");
        if (lineDelimiter != null) {
            sb.append("lines terminated by '" + fieldDelimiter + "'\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String generateSerDeRowFormat(RedshiftExternalTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("row format serde '" + table.getSerializationLib() + "'\n");
        if (!table.getSerdeProperties().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("with serdeproperties(");
            List<String> list = table.getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
            sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(")\n").toString());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String findProperty(List<String> properties, String key2) {
        Iterator iterator2;
        block5: {
            Iterable iterable;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)properties;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                void s;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                List list = StringUtil.splitHonorQuotes((String)s, (char)'=');
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"StringUtil.splitHonorQuotes(s, '=')");
                Iterable iterable3 = $receiver$iv2 = (Iterable)list;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void var16_16;
                    void it;
                    String string2 = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    void v1 = var16_16;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string3 = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString(), (char)'\'');
                    collection2.add(string3);
                }
                List list2 = (List)destination$iv$iv2;
                collection.add(list2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                List it = (List)element$iv$iv;
                if (!(it.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = iterable = (Iterable)((List)destination$iv$iv);
            for (Iterator iterator3 : iterable2) {
                List it = (List)((Object)iterator3);
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first((List)it)), (Object)key2)) continue;
                iterator2 = iterator3;
                break block5;
            }
            iterator2 = null;
        }
        List list = (List)((Object)iterator2);
        return list != null ? (String)CollectionsKt.last((List)list) : null;
    }

    public RsCreateExternalTable(@NotNull ScriptingContext context, @NotNull RedshiftExternalTable element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }
}

