/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.redshift.producers;

import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseObjectWithOwner;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftModelFunKt;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.ElementProducer;
import com.intellij.database.scripting.base.producers.BaseProducersKt;
import com.intellij.database.scripting.base.producers.CreateTable;
import com.intellij.database.scripting.postgres_base.producers.PostgresBaseOwnerAwareProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/redshift/producers/RsCreateTable;", "Lcom/intellij/database/scripting/base/producers/CreateTable;", "Lcom/intellij/database/model/redshift/RedshiftTable;", "Lcom/intellij/database/scripting/postgres_base/producers/PostgresBaseOwnerAwareProducer;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "element", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/model/redshift/RedshiftTable;)V", "objectType", "", "getObjectType", "()Ljava/lang/String;", "localTableFooter", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produceComment", "", "exists", "", "comment", "intellij.database.scripting"})
public final class RsCreateTable
extends CreateTable<RedshiftTable>
implements PostgresBaseOwnerAwareProducer {
    @Override
    @NotNull
    public String getObjectType() {
        return "table";
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, "table", comment);
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        return new HeaderFooter(super.makeTableHeaderFooter().getHeader(), this.localTableFooter());
    }

    /*
     * WARNING - void declaration
     */
    private final String localTableFooter() {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        RedshiftTableDistStyle style;
        StringBuilder sb = new StringBuilder();
        if (((RedshiftTable)this.getElement()).getBackupMode() != RedshiftTableBackupMode.ON) {
            sb.append("backup no\n");
        }
        if ((style = ((RedshiftTable)this.getElement()).getDistStyle()) != RedshiftTableDistStyle.EVEN) {
            String string = style.name();
            StringBuilder stringBuilder = new StringBuilder().append("diststyle ");
            StringBuilder stringBuilder2 = sb;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            stringBuilder2.append(stringBuilder.append(string4).append('\n').toString());
        }
        PositioningNamingFamily<? extends RedshiftTableColumn> positioningNamingFamily = ((RedshiftTable)this.getElement()).getColumns();
        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
        Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            RedshiftTableColumn it;
            RedshiftTableColumn redshiftTableColumn = it = (RedshiftTableColumn)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn, (String)"it");
            if (!(redshiftTableColumn.getSortKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                RedshiftTableColumn it;
                RedshiftTableColumn redshiftTableColumn = it = (RedshiftTableColumn)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn, (String)"it");
                it = (RedshiftTableColumn)b;
                Comparable comparable = Integer.valueOf(Math.abs(redshiftTableColumn.getSortKeyOrder()));
                RedshiftTableColumn redshiftTableColumn2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn2, (String)"it");
                Integer n = Math.abs(redshiftTableColumn2.getSortKeyOrder());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        List sortedColumns = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)comparator);
        if (sortedColumns.isEmpty()) {
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }
        if (RedshiftModelFunKt.hasInterleavedSortKey((RedshiftTable)this.getElement())) {
            sb.append("interleaved ");
        }
        sb.append("sortkey(");
        $receiver$iv = sortedColumns;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void col;
            Object element$iv$iv;
            int n = index$iv++;
            element$iv$iv = (RedshiftTableColumn)item$iv;
            int idx = n;
            if (idx != 0) {
                sb.append(", ");
            }
            void v6 = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"col");
            sb.append(v6.getName());
        }
        sb.append(")\n");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public RsCreateTable(@NotNull ScriptingContext context, @NotNull RedshiftTable element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }

    @Override
    public boolean getShouldGenerate() {
        return PostgresBaseOwnerAwareProducer.DefaultImpls.getShouldGenerate(this);
    }

    @Override
    public void produceOwner() {
        PostgresBaseOwnerAwareProducer.DefaultImpls.produceOwner(this);
    }

    @Override
    @NotNull
    public String definition(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.definition(this, $receiver);
    }

    @Override
    @Nullable
    public PostgresBaseObjectWithOwner element(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PostgresBaseOwnerAwareProducer.DefaultImpls.element(this, $receiver);
    }
}

