/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.sqlite;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.base.BaseCreatingGenerator;
import com.intellij.database.scripting.sqlite.SqliteCreatingGenerator$WhenMappings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/sqlite/SqliteCreatingGenerator;", "Lcom/intellij/database/scripting/base/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "(Lcom/intellij/database/scripting/ScriptingContext;)V", "canGenerateElementRightNow", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "isIndexExplicitFor", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "intellij.database.scripting"})
public final class SqliteCreatingGenerator
extends BaseCreatingGenerator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        if (!super.canGenerateHere(locus, element)) return false;
        switch (SqliteCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1: {
                if (!(element instanceof SqliteKey)) return true;
                BasicIndex basicIndex = ((SqliteKey)element).getUnderlyingIndex();
                if (!(basicIndex instanceof SqliteIndex)) {
                    basicIndex = null;
                }
                SqliteIndex sqliteIndex = (SqliteIndex)basicIndex;
                if (sqliteIndex == null) return true;
                SqliteIndex sqliteIndex2 = sqliteIndex;
                SqliteIndex it = sqliteIndex2;
                if (!it.getReverseColNames().isEmpty() && !((SqliteKey)element).isPrimary()) {
                    return false;
                }
                if (it.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
                    return true;
                }
                List<String> list = it.getColumnCollations();
                List<String> it2 = list;
                if (it2.isEmpty()) return true;
                if (it2.size() != 1) return false;
                if (!StringUtil.isEmpty((String)it2.get(0))) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    @Override
    protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!super.canGenerateElementRightNow(element)) {
            return false;
        }
        if (!(element instanceof SqliteKey) || ((SqliteKey)element).getColNames().size() != 1) {
            return true;
        }
        SqliteIndex index2 = (SqliteIndex)((SqliteKey)element).getUnderlyingIndex();
        if (index2 == null || index2.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
            return true;
        }
        List<String> collations = index2.getColumnCollations();
        return collations.isEmpty() || collations.size() == 1 && StringUtil.isEmpty((String)collations.get(0));
    }

    @Override
    public boolean isIndexExplicitFor(@Nullable BasicIndex index2, @NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return index2 != null && index2.getNaturalName() != null && index2.getColNames().size() == key2.getColNames().size() && Intrinsics.areEqual((Object)index2.getName(), (Object)key2.getName()) ^ true;
    }

    public SqliteCreatingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }
}

