/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserParametersTable
implements ConfigurableUi<DatabaseSettings> {
    private static final String ANY_DISPLAY_NAME = "All";
    private static final String ANY_DISPLAY_NAME_LINK = "All languages";
    private static final String ANY_ID = "*";
    private static final int PATTERN_OFFSET = 1;
    private static final Condition<CheckedTreeNode> CHECKED_NODE = CheckedTreeNode::isChecked;
    private final JComponent myComponent;
    private final ListTableModel<UserPatterns.ParameterPattern> myTableModel;
    private final ArrayList<Pair<String, String>> myPatternErrors = ContainerUtil.newArrayList();
    private final JBTable myTable;
    private final LexerEditorHighlighter myHighlighter = UserParametersTable.createRegExpHighlighter();
    private JBPopup myPopup;

    public UserParametersTable(final Disposable parent) {
        this.myTableModel = new ListTableModel<UserPatterns.ParameterPattern>(new ColumnInfo[]{UserParametersTable.createColumnInfo()}){

            public void addRow() {
                this.addRow(new UserPatterns.ParameterPattern());
            }
        };
        JBTable table = new JBTable(this.myTableModel);
        table.getInputMap(1).put(KeyStroke.getKeyStroke("F2"), "startEditing");
        Dimension size = table.getPreferredSize();
        size.height = table.getRowHeight() * 5;
        table.setPreferredScrollableViewportSize(size);
        table.setSelectionMode(0);
        table.setBackground(this.myHighlighter.getScheme().getDefaultBackground());
        JBListTable listTable = new JBListTable((JTable)table, parent){
            private final EditorTextFieldJBTableRowRenderer renderer;
            private final JBTableRowEditor editor;
            {
                super(arg0, arg1);
                this.renderer = new MyRowRenderer(parent);
                this.editor = new MyRowEditor();
            }

            protected JBTableRowRenderer getRowRenderer(int row) {
                return this.renderer;
            }

            protected JBTableRowEditor getRowEditor(int row) {
                return this.editor;
            }
        };
        this.myTable = listTable.getTable();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)listTable.getTable()).setRemoveActionUpdater(e -> {
            int[] rows;
            for (int row : rows = listTable.getTable().getSelectedRows()) {
                UserPatterns.ParameterPattern item = (UserPatterns.ParameterPattern)this.myTableModel.getItem(row);
                if (item == null || item.id == null) continue;
                return false;
            }
            return rows.length != 0;
        });
        this.myComponent = decorator.createPanel();
        new UiNotifyConnector((Component)this.myComponent, (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                UserParametersTable.this.disposeContextPopup();
            }
        });
    }

    private static <T extends UserPatterns.ParameterPattern> ColumnInfo<T, T> createColumnInfo() {
        return new ColumnInfo<T, T>(" "){

            @Nullable
            public T valueOf(T o) {
                return o;
            }
        };
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            UserParametersTable.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            UserParametersTable.$$$reportNull$$$0(1);
        }
        TableUtil.stopEditing((JTable)this.myTable);
        List<UserPatterns.ParameterPattern> patterns = settings.getUserPatterns().patterns;
        ArrayList copy = ContainerUtil.newArrayListWithCapacity((int)patterns.size());
        for (UserPatterns.ParameterPattern p : patterns) {
            copy.add(p.clone());
        }
        this.myTableModel.setItems((List)copy);
    }

    public void apply(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            UserParametersTable.$$$reportNull$$$0(2);
        }
        TableUtil.stopEditing((JTable)this.myTable);
        UserPatterns userPatterns = settings.getUserPatterns();
        userPatterns.patterns.clear();
        for (UserPatterns.ParameterPattern p : this.myTableModel.getItems()) {
            if (StringUtil.isEmptyOrSpaces((String)p.pattern)) continue;
            userPatterns.patterns.add(p.clone());
        }
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            UserParametersTable.$$$reportNull$$$0(3);
        }
        return !Comparing.equal(settings.getUserPatterns().patterns, (Object)this.myTableModel.getItems());
    }

    @NotNull
    static Language getRegExpLanguage() {
        Language regexp = Language.findLanguageByID((String)"RegExp");
        Language language = regexp == null ? StdLanguages.TEXT : regexp;
        if (language == null) {
            UserParametersTable.$$$reportNull$$$0(4);
        }
        return language;
    }

    @NotNull
    private static LexerEditorHighlighter createRegExpHighlighter() {
        EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        Language regExp = (Language)ObjectUtils.chooseNotNull((Object)Language.findLanguageByID((String)"RegExp"), (Object)FileTypes.PLAIN_TEXT.getLanguage());
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)regExp, null, null);
        LexerEditorHighlighter lexerEditorHighlighter = new LexerEditorHighlighter(highlighter, scheme);
        if (lexerEditorHighlighter == null) {
            UserParametersTable.$$$reportNull$$$0(5);
        }
        return lexerEditorHighlighter;
    }

    private static Set<Language> newSet() {
        return ContainerUtil.newTreeSet((Comparator)LanguageUtil.LANGUAGE_COMPARATOR);
    }

    private int getMaxPatternLength() {
        int max = 0;
        for (UserPatterns.ParameterPattern p : this.myTableModel.getItems()) {
            max = Math.max(UserParametersTable.getPatternText(p).length(), max);
        }
        return max;
    }

    private static StringBuilder langsToDisplay(LangSet set, int chars, StringBuilder sb) {
        TreeSet s1 = ContainerUtil.newTreeSet((Comparator)NaturalComparator.INSTANCE);
        s1.addAll(set.included2);
        for (Language language : set.included) {
            s1.add(language == Language.ANY ? ANY_DISPLAY_NAME : language.getID());
        }
        TreeSet s2 = ContainerUtil.newTreeSet((Comparator)NaturalComparator.INSTANCE);
        s2.addAll(set.excluded2);
        for (Language l : set.excluded) {
            s2.add(l == Language.ANY ? ANY_DISPLAY_NAME : l.getID());
        }
        String string = StringUtil.join((Collection)s1, (String)", ");
        String str2 = StringUtil.join((Collection)s2, (String)", ");
        int restChars = (StringUtil.isNotEmpty((String)string) ? string : ANY_DISPLAY_NAME).length() + (StringUtil.isNotEmpty((String)str2) ? str2.length() : 0);
        int max1 = Math.max(15, chars * string.length() / restChars);
        int max2 = Math.max(15, chars * str2.length() / restChars);
        sb.append(StringUtil.isNotEmpty((String)string) ? StringUtil.first((String)string, (int)max1, (boolean)false) : ANY_DISPLAY_NAME);
        if (StringUtil.isNotEmpty((String)str2)) {
            sb.append(" excl. ").append(StringUtil.first((String)str2, (int)max2, (boolean)false));
        }
        if (max1 + max2 < string.length() + str2.length()) {
            sb.append("...");
        }
        return sb;
    }

    @NotNull
    private static String langsToScope(@NotNull LangSet set) {
        if (set == null) {
            UserParametersTable.$$$reportNull$$$0(6);
        }
        TreeSet s1 = ContainerUtil.newTreeSet((Comparator)NaturalComparator.INSTANCE);
        if (!set.included.contains(Language.ANY)) {
            s1.addAll(set.included2);
        } else {
            set.included2.clear();
        }
        for (Language l : set.included) {
            s1.add(l == Language.ANY ? ANY_ID : l.getID());
        }
        HashSet s2 = ContainerUtil.newHashSet();
        s2.addAll(set.excluded2);
        for (Language l : set.excluded) {
            s2.add(l == Language.ANY ? ANY_ID : l.getID());
        }
        s1.addAll(s2);
        if (s1.size() == 1 && ANY_ID.equals(ContainerUtil.getFirstItem((Collection)s1))) {
            if (ANY_ID == null) {
                UserParametersTable.$$$reportNull$$$0(7);
            }
            return ANY_ID;
        }
        String string = StringUtil.join((Collection)s1, s -> s2.contains(s) ? "-" + s : s, (String)",");
        if (string == null) {
            UserParametersTable.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void stringToLangs(String string, LangSet set) {
        set.clear();
        if (string.isEmpty()) {
            set.included.add(Language.ANY);
            return;
        }
        for (String s : string.split("[\\s,]+")) {
            boolean keepId;
            boolean exclude = s.startsWith("-");
            Language language = ANY_ID.equals(s) ? Language.ANY : Language.findLanguageByID((String)(exclude ? s.substring(1) : s));
            boolean bl = keepId = language == null || !LanguageUtil.isFileLanguage((Language)language) || !UserParametersTable.mayHaveInjection(language);
            if (language != Language.ANY && keepId) {
                if (s.isEmpty()) continue;
                (exclude ? set.excluded2 : set.included2).add(s);
                continue;
            }
            (exclude ? set.excluded : set.included).add(language);
        }
    }

    static boolean mayHaveInjection(Language language) {
        return language != StdLanguages.TEXT && language != StdLanguages.DTD;
    }

    private boolean disposeContextPopup() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
            this.myPopup = null;
            return true;
        }
        return false;
    }

    private void invokePopup(JComponent sourceComponent, LangSet set, Runnable onChange) {
        JPanel content = UserParametersTable.createPopupContent(set, onChange);
        JTree tree = (JTree)UIUtil.uiTraverser((Component)content).filter(JTree.class).first();
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, (JComponent)tree).setResizable(true).setDimensionServiceKey(null, this.getClass() + ".Popup", false).createPopup();
        this.myPopup.setRequestFocus(true);
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(LightweightWindowEvent event) {
                TableUtil.stopEditing((JTable)UserParametersTable.this.myTable);
            }
        });
        this.myPopup.showUnderneathOf((Component)sourceComponent);
    }

    @Nullable
    private String getPatternError(int row) {
        this.ensureSize();
        if (row < 0 || row >= this.myPatternErrors.size()) {
            return "Error";
        }
        Pair cached = this.myPatternErrors.get(row);
        UserPatterns.ParameterPattern p = (UserPatterns.ParameterPattern)this.myTableModel.getRowValue(row);
        if (cached == null || !Comparing.equal((String)((String)cached.first), (String)p.pattern)) {
            cached = Pair.create((Object)p.pattern, (Object)TokenPatternCache.getPatternError(p.pattern));
            this.myPatternErrors.add((Pair<String, String>)cached);
        }
        return (String)cached.second;
    }

    private void ensureSize() {
        int hasSize;
        int needSize = this.myTableModel.getRowCount();
        this.myPatternErrors.ensureCapacity(needSize);
        if (hasSize >= needSize) {
            this.myPatternErrors.subList(needSize, hasSize).clear();
        } else {
            for (hasSize = this.myPatternErrors.size(); hasSize < needSize; ++hasSize) {
                this.myPatternErrors.add(null);
            }
        }
    }

    private static JPanel createPopupContent(final LangSet set, final Runnable onChange) {
        ArrayList languages = ContainerUtil.newArrayList((Iterable)LanguageUtil.getFileLanguages());
        Iterator it = languages.iterator();
        while (it.hasNext()) {
            if (UserParametersTable.mayHaveInjection((Language)it.next())) continue;
            it.remove();
        }
        JPanel panel = new JPanel(new BorderLayout());
        MultiMap hierarchy = MultiMap.createLinkedSet();
        for (Language language : languages) {
            hierarchy.putValue(ObjectUtils.notNull((Object)language.getBaseLanguage(), (Object)Language.ANY), (Object)language);
        }
        CheckedTreeNode root2 = new CheckedTreeNode((Object)Language.ANY);
        final CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Language o = (Language)((DefaultMutableTreeNode)value).getUserObject();
                this.getTextRenderer().append(o == Language.ANY ? "Languages" : o.getDisplayName());
            }
        }, root2, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root2){

            @Override
            public void valueForPathChanged(TreePath path, Object o) {
                super.valueForPathChanged(path, o);
                UserParametersTable.updateSets(tree, set);
                onChange.run();
            }
        });
        tree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                super.treeNodesChanged(e);
            }
        });
        tree.setVisibleRowCount(20);
        tree.setRootVisible(true);
        HashMap nodeMap = ContainerUtil.newHashMap();
        nodeMap.put(Language.ANY, root2);
        root2.setChecked(set.included.contains(Language.ANY));
        for (Language l : languages) {
            CheckedTreeNode node = new CheckedTreeNode((Object)l);
            node.setChecked(set.included.contains(l));
            nodeMap.put(l, node);
        }
        for (Language parent : hierarchy.keySet()) {
            for (Language child : hierarchy.get((Object)parent)) {
                ((CheckedTreeNode)nodeMap.get(parent)).add((MutableTreeNode)nodeMap.get(child));
            }
        }
        for (CheckedTreeNode node : UserParametersTable.traverser((TreeNode)root2).filter(CheckedTreeNode.class)) {
            Language l = (Language)node.getUserObject();
            if (node.isChecked() || set.excluded.contains(l) || node.getParent() == null || !((CheckedTreeNode)node.getParent()).isChecked()) continue;
            node.setChecked(true);
        }
        ((DefaultTreeModel)tree.getModel()).nodeStructureChanged((TreeNode)root2);
        for (CheckedTreeNode node : UserParametersTable.traverser((TreeNode)root2).filter(CheckedTreeNode.class).filter(CHECKED_NODE)) {
            tree.expandPath(new TreePath(node.getPath()).getParentPath());
        }
        panel.add(ScrollPaneFactory.createScrollPane((Component)tree));
        return panel;
    }

    private static void updateSets(CheckboxTree tree, LangSet set) {
        set.included.clear();
        set.excluded.clear();
        JBTreeTraverser<TreeNode> traverser2 = UserParametersTable.traverser((TreeNode)tree.getModel().getRoot());
        for (CheckedTreeNode node : traverser2.filter(CheckedTreeNode.class)) {
            boolean parentChecked;
            Language l = (Language)node.getUserObject();
            boolean bl = parentChecked = l != Language.ANY && ((CheckedTreeNode)node.getParent()).isChecked();
            if (node.isChecked() == parentChecked) continue;
            (node.isChecked() ? set.included : set.excluded).add(l);
        }
    }

    private static JBTreeTraverser<TreeNode> traverser(TreeNode root2) {
        return (JBTreeTraverser)JBTreeTraverser.from(node -> {
            int count2 = node.getChildCount();
            return JBIterable.generate((Object)0, i2 -> i2 + 1).take(count2).transform(node::getChildAt);
        }).withRoot((Object)root2);
    }

    private static String getPatternText(UserPatterns.ParameterPattern p) {
        return p.id == null ? p.pattern : "\"" + p.id + "\"";
    }

    static /* synthetic */ Set access$200() {
        return UserParametersTable.newSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/UserParametersTable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/UserParametersTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegExpLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegExpHighlighter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "langsToScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "langsToScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRowEditor
    extends JBTableRowEditor
    implements HyperlinkListener {
        LangSet myLanguages = new LangSet();
        UserPatterns.ParameterPattern p;
        EditorTextField myTextField = new EditorTextField("", ProjectManager.getInstance().getDefaultProject(), (FileType)UserParametersTable.getRegExpLanguage().getAssociatedFileType());
        JBCheckBox myScriptsCheckBox = new JBCheckBox("In scripts");
        JBCheckBox myLiteralsCheckBox = new JBCheckBox("In literals");
        HyperlinkLabel myScopeLink = new HyperlinkLabel("", this.getBackground());

        private MyRowEditor() {
            this.myTextField.addSettingsProvider(this::customizeSettings);
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel p1 = new JPanel();
            JPanel p2 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 0));
            p2.setLayout(new BoxLayout(p2, 0));
            this.add(Box.createVerticalStrut(5));
            this.add(p1);
            this.add(Box.createVerticalStrut(5));
            this.add(p2);
            this.add(Box.createVerticalStrut(5));
            this.add(Box.createVerticalGlue());
            p1.add(Box.createHorizontalStrut(10));
            p1.add((Component)new JBLabel("Pattern:"));
            p1.add(Box.createHorizontalStrut(5));
            p1.add((Component)this.myTextField);
            p1.add(Box.createHorizontalStrut(5));
            p1.add(Box.createHorizontalGlue());
            p2.add((Component)this.myScriptsCheckBox);
            p2.add(Box.createHorizontalStrut(5));
            p2.add((Component)this.myLiteralsCheckBox);
            p2.add(Box.createHorizontalStrut(10));
            p2.add((Component)this.myScopeLink);
            p2.add(Box.createHorizontalGlue());
            this.myScopeLink.addHyperlinkListener((HyperlinkListener)this);
            this.myScopeLink.setAlignmentX(1.0f);
            this.myScriptsCheckBox.addActionListener(e -> {
                if (this.p != null) {
                    this.p.inScripts = this.myScriptsCheckBox.isSelected();
                }
            });
            this.myLiteralsCheckBox.addActionListener(e -> {
                if (this.p != null) {
                    this.p.inLiterals = this.myLiteralsCheckBox.isSelected();
                }
            });
            this.myTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    if (MyRowEditor.this.p != null) {
                        MyRowEditor.this.p.pattern = MyRowEditor.this.myTextField.getText();
                    }
                }
            });
        }

        public void customizeSettings(Editor editor) {
            if (editor != null) {
                editor.getContentComponent().setToolTipText(this.p.id != null ? "Predefined" : "");
            }
        }

        public void prepareEditor(JTable table, int row) {
            this.p = (UserPatterns.ParameterPattern)UserParametersTable.this.myTableModel.getRowValue(row);
            this.myTextField.setText(this.p.pattern);
            boolean predefined = this.p.id != null;
            this.myTextField.setEnabled(!predefined);
            this.myScopeLink.setEnabled(!predefined);
            this.customizeSettings(this.myTextField.getEditor());
            this.myScriptsCheckBox.setSelected(this.p.inScripts);
            this.myLiteralsCheckBox.setSelected(this.p.inLiterals);
            UserParametersTable.stringToLangs(this.p.scope, this.myLanguages);
            this.updateLinkText(this.myScopeLink);
        }

        public JBTableRow getValue() {
            return column2 -> this.p;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField.getFocusTarget();
        }

        public JComponent[] getFocusableComponents() {
            return new JComponent[]{this.myTextField.getFocusTarget(), this.myScriptsCheckBox, this.myLiteralsCheckBox, this.myScopeLink};
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            this.invokePopup((HyperlinkLabel)event.getSource());
        }

        private void invokePopup(HyperlinkLabel label) {
            if (UserParametersTable.this.disposeContextPopup()) {
                return;
            }
            UserParametersTable.stringToLangs(this.p.scope, this.myLanguages);
            UserParametersTable.this.invokePopup((JComponent)label, this.myLanguages, () -> this.onPopupChanged(label));
        }

        private void onPopupChanged(HyperlinkLabel label) {
            this.p.scope = UserParametersTable.langsToScope(this.myLanguages);
            this.updateLinkText(label);
        }

        private void updateLinkText(HyperlinkLabel label) {
            String text2 = UserParametersTable.langsToDisplay(this.myLanguages, 30, new StringBuilder()).toString();
            label.setHyperlinkText(UserParametersTable.ANY_DISPLAY_NAME.equals(text2) ? UserParametersTable.ANY_DISPLAY_NAME_LINK : text2);
        }
    }

    private class MyRowRenderer
    extends EditorTextFieldJBTableRowRenderer {
        LangSet myLanguages;

        public MyRowRenderer(Disposable parent) {
            super(null, null, parent);
            this.myLanguages = new LangSet();
        }

        protected String getText(JTable table, int row) {
            int width = UserParametersTable.this.myComponent.getWidth();
            UserPatterns.ParameterPattern p = (UserPatterns.ParameterPattern)UserParametersTable.this.myTableModel.getRowValue(row);
            String text2 = UserParametersTable.getPatternText(p);
            StringBuilder sb = new StringBuilder(StringUtil.repeat((String)" ", (int)1)).append(text2);
            sb.append(StringUtil.repeatSymbol((char)' ', (int)(UserParametersTable.this.getMaxPatternLength() - text2.length() + 1)));
            if (p.inScripts && p.inLiterals) {
                sb.append("everywhere ");
            }
            if (p.inScripts && !p.inLiterals) {
                sb.append("in scripts ");
            } else if (!p.inScripts && p.inLiterals) {
                sb.append("in literals");
            } else if (!p.inScripts && !p.inLiterals) {
                sb.append("disabled   ");
            }
            sb.append("  ");
            int w0 = UserParametersTable.this.myComponent.getFontMetrics(UserParametersTable.this.myComponent.getFont()).charWidth('m') * sb.length();
            int w1 = width - w0;
            int chars = w1 * sb.length() / w0 - 20;
            UserParametersTable.stringToLangs(p.scope, this.myLanguages);
            UserParametersTable.langsToDisplay(this.myLanguages, chars, sb);
            return StringUtil.trimEnd((String)sb.toString(), (String)UserParametersTable.ANY_DISPLAY_NAME);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column2) {
            Component component = super.getTableCellRendererComponent(table, value, selected, focused, row, column2);
            ((JComponent)component).setToolTipText(UserParametersTable.this.getPatternError(row));
            return component;
        }

        protected void customizeEditor(@NotNull EditorEx editor, JTable table, Object value, boolean selected, int row, int column2) {
            if (editor == null) {
                MyRowRenderer.$$$reportNull$$$0(0);
            }
            MarkupModelEx mm = editor.getMarkupModel();
            mm.removeAllHighlighters();
            super.customizeEditor(editor, table, value, selected, row, column2);
            UserPatterns.ParameterPattern p = (UserPatterns.ParameterPattern)UserParametersTable.this.myTableModel.getRowValue(row);
            String text2 = UserParametersTable.getPatternText(p);
            if (p.id == null) {
                UserParametersTable.this.myHighlighter.setText((CharSequence)text2);
                HighlighterIterator it = UserParametersTable.this.myHighlighter.createIterator(0);
                while (!it.atEnd()) {
                    TextAttributes attr = it.getTextAttributes();
                    if (selected) {
                        attr = TextAttributes.fromFlyweight((AttributesFlyweight)attr.getFlyweight().withForeground(table.getSelectionForeground()).withBackground(table.getSelectionBackground()));
                    }
                    mm.addRangeHighlighter(1 + it.getStart(), 1 + it.getEnd(), 3000, attr, HighlighterTargetArea.EXACT_RANGE);
                    it.advance();
                }
            }
            mm.addRangeHighlighter(1 + text2.length(), editor.getDocument().getTextLength(), 3000, editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT), HighlighterTargetArea.EXACT_RANGE);
            String error2 = UserParametersTable.this.getPatternError(row);
            if (error2 != null) {
                mm.addRangeHighlighter(1, 1 + text2.length(), 5000, editor.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES), HighlighterTargetArea.EXACT_RANGE);
            }
        }

        @NotNull
        protected EditorTextFieldCellRenderer.RendererComponent createRendererComponent(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            EditorTextFieldCellRenderer.SimpleRendererComponent simpleRendererComponent = new EditorTextFieldCellRenderer.SimpleRendererComponent(project, fileType, inheritFontFromLaF);
            if (simpleRendererComponent == null) {
                MyRowRenderer.$$$reportNull$$$0(1);
            }
            return simpleRendererComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/settings/UserParametersTable$MyRowRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/settings/UserParametersTable$MyRowRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeEditor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LangSet {
        final Set<Language> included = UserParametersTable.access$200();
        final Set<Language> excluded = UserParametersTable.access$200();
        final Set<String> included2 = ContainerUtil.newTreeSet();
        final Set<String> excluded2 = ContainerUtil.newTreeSet();

        private LangSet() {
        }

        public void clear() {
            this.included.clear();
            this.excluded.clear();
            this.included2.clear();
            this.excluded2.clear();
        }
    }
}

