/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseParameterPatternProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.RegExp;

@Tag(value="text-mode")
public class UserPatterns {
    @Attribute(value="in-scripts")
    public boolean inScripts = true;
    @Attribute(value="in-literals")
    public boolean inLiterals = true;
    @Attribute(value="process-strings")
    public boolean processStrings = false;
    @Tag(value="parameter-patterns")
    @XCollection
    public List<ParameterPattern> patterns = ContainerUtil.newArrayList();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPatterns mode = (UserPatterns)o;
        if (this.inLiterals != mode.inLiterals) {
            return false;
        }
        if (this.inScripts != mode.inScripts) {
            return false;
        }
        return this.patterns.equals(mode.patterns);
    }

    public int hashCode() {
        int result2 = this.patterns.hashCode();
        result2 = 31 * result2 + (this.inLiterals ? 1 : 0);
        result2 = 31 * result2 + (this.inScripts ? 1 : 0);
        return result2;
    }

    public void migrate(int version) {
        if (version < 3) {
            Map byPattern = ContainerUtil.newMapFromValues(UserPatterns.getPredefined().iterator(), p -> p.pattern);
            ContainerUtil.fillMapWithValues((Map)byPattern, UserPatterns.getPredefined().iterator(), p -> p.pattern.replaceAll("[()]", ""));
            for (ParameterPattern pattern : this.patterns) {
                boolean isPredef = "true".equals(pattern.id) || pattern.id == null;
                ParameterPattern predef = isPredef ? (ParameterPattern)byPattern.get(pattern.pattern) : null;
                if (predef == null) continue;
                pattern.id = predef.id;
            }
        }
        HashSet existing = ContainerUtil.newHashSet();
        for (ParameterPattern pattern : this.patterns) {
            if (pattern.id == null) continue;
            ParameterPattern predef = UserPatterns.getPredefinedById().get(pattern.id);
            if (predef == null) {
                pattern.id = null;
                continue;
            }
            existing.add(pattern.id);
            pattern.pattern = predef.pattern;
            if (pattern.isSetByUserFlag) continue;
            pattern.scope = predef.scope;
        }
        for (ParameterPattern predef : UserPatterns.getPredefined()) {
            if (existing.contains(predef.id)) continue;
            ParameterPattern pattern = predef.clone();
            this.patterns.add(pattern);
        }
    }

    public static Collection<ParameterPattern> getPredefined() {
        return UserPatterns.getPredefinedById().values();
    }

    public static Map<String, ParameterPattern> getPredefinedById() {
        return Predef.ourPredefined;
    }

    @Tag(value="parameter-pattern")
    public static class ParameterPattern
    implements Cloneable {
        @Attribute(value="value")
        public String pattern = "";
        @Attribute(value="in-scripts")
        public boolean inScripts = false;
        @Attribute(value="in-literals")
        public boolean inLiterals = true;
        @Attribute(value="scope")
        public String scope = "";
        @Attribute(value="predefined")
        public String id = null;
        private transient boolean isSetByUserFlag = false;

        @Attribute(value="set-by-user")
        public void setSetByUser(boolean s) {
            this.isSetByUserFlag = s;
        }

        @Attribute(value="set-by-user")
        public boolean isSetByUser() {
            if (this.id == null) {
                return false;
            }
            ParameterPattern predef = UserPatterns.getPredefinedById().get(this.id);
            if (predef == null) {
                return false;
            }
            return !Comparing.equal((String)predef.scope, (String)this.scope);
        }

        public ParameterPattern() {
        }

        public ParameterPattern(@RegExp String pattern) {
            this.pattern = pattern;
            this.inScripts = true;
        }

        public ParameterPattern(@RegExp String pattern, String scope, String id) {
            this.pattern = pattern;
            this.scope = scope;
            this.id = id;
            this.inScripts = true;
        }

        public ParameterPattern enabled(boolean inScripts, boolean inLiterals) {
            this.inScripts = inScripts;
            this.inLiterals = inLiterals;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterPattern pattern1 = (ParameterPattern)o;
            if (this.id != pattern1.id) {
                return false;
            }
            if (this.inScripts != pattern1.inScripts) {
                return false;
            }
            if (this.inLiterals != pattern1.inLiterals) {
                return false;
            }
            if (this.pattern != null ? !this.pattern.equals(pattern1.pattern) : pattern1.pattern != null) {
                return false;
            }
            return !(this.scope != null ? !this.scope.equals(pattern1.scope) : pattern1.scope != null);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.pattern);
            result2 = 31 * result2 + Objects.hashCode(this.id);
            result2 = 31 * result2 + (this.inScripts ? 1 : 0);
            result2 = 31 * result2 + (this.inLiterals ? 1 : 0);
            result2 = 31 * result2 + Objects.hashCode(this.scope);
            return result2;
        }

        public ParameterPattern clone() {
            try {
                return (ParameterPattern)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    public static class Predef {
        public static final List<ParameterPattern> HARDCODED_PATTERNS = ContainerUtil.immutableList((Object[])new ParameterPattern[]{new ParameterPattern("\\$\\{([^{}]*)}", "*,-SQL", "${name} - hardcoded").enabled(false, true), new ParameterPattern("#\\{([^{}]*)}", "*,-SQL", "#{name} - hardcoded").enabled(false, true)});
        public static final Map<String, ParameterPattern> ourPredefined = ContainerUtil.newLinkedHashMap();

        private static void add(ParameterPattern ... params) {
            for (ParameterPattern param : params) {
                ourPredefined.put(param.id, param);
            }
        }

        static {
            if (Extensions.getRootArea().hasExtensionPoint(DatabaseParameterPatternProvider.EP.getName())) {
                for (DatabaseParameterPatternProvider provider : (DatabaseParameterPatternProvider[])DatabaseParameterPatternProvider.EP.getExtensions()) {
                    Predef.add(provider.getPatterns());
                }
            }
            Predef.add(new ParameterPattern("\\$\\{([^\\{\\}]*)\\}", "", "${name}"), new ParameterPattern("\\$\\(([^\\)]+)\\)", "", "$(name)"));
        }
    }
}

