/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseUsagesCollectors {
    private static final String DRIVERS_GROUP = "statistics.db.driver.classes";
    private static final String FAMILIES_GROUP = "statistics.db.vendor.families";
    private static final String PRODUCTS_GROUP = "statistics.db.vendor.versions";
    private static final String MANAGERS_GROUP = "statistics.db.managers";
    private static final String CONFIG_GROUP = "statistics.db.datasource.config";
    private static final String DDL_DIALECTS_GROUP = "statistics.db.ddl.dialects";

    @NotNull
    private static JBIterable<LocalDataSource> dbs(@Nullable Project p) {
        DataSourceStorage storage = p == null ? DataSourceStorage.getStorage() : DataSourceStorage.getProjectStorage(p);
        JBIterable jBIterable = JBIterable.from(storage.getOwnDataSources());
        if (jBIterable == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @NotNull
    private static Set<UsageDescriptor> unique(@Nullable Project p, @NotNull Function<LocalDataSource, String> mapper) {
        if (mapper == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(1);
        }
        Set set = DatabaseUsagesCollectors.dbs(p).map(mapper).unique().map(o -> new UsageDescriptor(o, 1)).toSet();
        if (set == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static String toValue(@NotNull NameVersion nameVersion) {
        if (nameVersion == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(3);
        }
        String string = nameVersion.name.isEmpty() || nameVersion.version.isEmpty() ? "none" : nameVersion.name + " " + nameVersion.version;
        if (string == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static Set<UsageDescriptor> configImpl(@Nullable Project p) {
        Set set = DatabaseUsagesCollectors.dbs(p).flatMap(o -> JBIterable.of((Object[])new String[]{o.isReadOnly() ? "read-only on" : "read-only off", o.isAutoSynchronize() ? "auto-sync on" : "auto-sync off", o.isAutoCommit() ? "auto-commit on" : "auto-commit off", o.getSshConfiguration() != null ? "ssh on" : "ssh off", o.getSslCfg() != null ? "ssl on" : "ssl off", o.useLegacyIntrospector() ? "legacy introspector on" : "legacy introspector off", "schema control " + StringUtil.toLowerCase((String)o.getSchemaControl().name()), "introspect " + StringUtil.toLowerCase((String)o.getSourceLoading().name())})).unique().map(o -> new UsageDescriptor(o, 1)).toSet();
        if (set == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dbs";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "configImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DdlDbDialectsPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.DDL_DIALECTS_GROUP == null) {
                DdlDbDialectsPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.DDL_DIALECTS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                DdlDbDialectsPrj.$$$reportNull$$$0(1);
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)p);
            Set set = JBIterable.from((Iterable)facade.getDataSources()).filter(o -> facade.getDataSourceManager(o).getClass().getSimpleName().equals("SqlDataSourceManager")).map(o -> ((DbDataSourceImpl)((Object)o)).getSqlDialect().getID()).map(o -> new UsageDescriptor(o, 1)).toSet();
            if (set == null) {
                DdlDbDialectsPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DdlDbDialectsPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DdlDbDialectsPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConfigPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.CONFIG_GROUP == null) {
                ConfigPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.CONFIG_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                ConfigPrj.$$$reportNull$$$0(1);
            }
            Set set = DatabaseUsagesCollectors.configImpl(p);
            if (set == null) {
                ConfigPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConfigApp
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.CONFIG_GROUP == null) {
                ConfigApp.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.CONFIG_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set set = DatabaseUsagesCollectors.configImpl(null);
            if (set == null) {
                ConfigApp.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigApp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ProductsPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.PRODUCTS_GROUP == null) {
                ProductsPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.PRODUCTS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                ProductsPrj.$$$reportNull$$$0(1);
            }
            Set set = DatabaseUsagesCollectors.unique(p, (Function<LocalDataSource, String>)o -> DatabaseUsagesCollectors.toValue(o.getDatabaseVersion()));
            if (set == null) {
                ProductsPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ProductsPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ProductsPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ProductsApp
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.PRODUCTS_GROUP == null) {
                ProductsApp.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.PRODUCTS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set set = DatabaseUsagesCollectors.unique(null, (Function<LocalDataSource, String>)o -> DatabaseUsagesCollectors.toValue(o.getDatabaseVersion()));
            if (set == null) {
                ProductsApp.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ProductsApp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class FamiliesPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.FAMILIES_GROUP == null) {
                FamiliesPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.FAMILIES_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                FamiliesPrj.$$$reportNull$$$0(1);
            }
            Set set = DatabaseUsagesCollectors.unique(p, (Function<LocalDataSource, String>)o -> DatabaseFamilyId.forDataSource((DasDataSource)o).getName());
            if (set == null) {
                FamiliesPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$FamiliesPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$FamiliesPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FamiliesApp
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.FAMILIES_GROUP == null) {
                FamiliesApp.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.FAMILIES_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set set = DatabaseUsagesCollectors.unique(null, (Function<LocalDataSource, String>)o -> DatabaseFamilyId.forDataSource((DasDataSource)o).getName());
            if (set == null) {
                FamiliesApp.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$FamiliesApp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class DriversPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.DRIVERS_GROUP == null) {
                DriversPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.DRIVERS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                DriversPrj.$$$reportNull$$$0(1);
            }
            Set set = DatabaseUsagesCollectors.unique(p, (Function<LocalDataSource, String>)o -> o.getDriverClass());
            if (set == null) {
                DriversPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DriversPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DriversPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DriversApp
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.DRIVERS_GROUP == null) {
                DriversApp.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.DRIVERS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set set = DatabaseUsagesCollectors.unique(null, (Function<LocalDataSource, String>)o -> o.getDriverClass());
            if (set == null) {
                DriversApp.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DriversApp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ManagersPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if (DatabaseUsagesCollectors.MANAGERS_GROUP == null) {
                ManagersPrj.$$$reportNull$$$0(0);
            }
            return DatabaseUsagesCollectors.MANAGERS_GROUP;
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project p) {
            if (p == null) {
                ManagersPrj.$$$reportNull$$$0(1);
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)p);
            Set set = JBIterable.from((Iterable)facade.getDataSources()).map(o -> facade.getDataSourceManager(o).getClass().getSimpleName()).map(o -> StringUtil.toLowerCase((String)StringUtil.trimEnd((String)o, (String)"DataSourceManager"))).unique().map(o -> new UsageDescriptor(o, 1)).toSet();
            if (set == null) {
                ManagersPrj.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

